/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.server;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.rdf4j.http.server.ClientHTTPException;
import org.eclipse.rdf4j.http.server.ServerHTTPException;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public abstract class ServerInterceptor
extends HandlerInterceptorAdapter {
    private volatile String origThreadName;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.origThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this.getThreadName());
        this.setRequestAttributes(request);
        return super.preHandle(request, response, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception exception) throws Exception {
        try {
            this.cleanUpResources();
        }
        finally {
            Thread.currentThread().setName(this.origThreadName);
        }
    }

    protected abstract String getThreadName() throws ServerHTTPException;

    protected void setRequestAttributes(HttpServletRequest request) throws ClientHTTPException, ServerHTTPException {
    }

    protected void cleanUpResources() throws ServerHTTPException {
    }
}

