/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mapdb.DataInput2;
import org.mapdb.DataOutput2;
import org.mapdb.Fun;
import org.mapdb.LongConcurrentHashMap;
import org.mapdb.LongHashMap;
import org.mapdb.LongMap;
import org.mapdb.Serializer;
import org.mapdb.Store;
import org.mapdb.Volume;

@Deprecated
class StoreAppend
extends Store {
    protected static final long HEADER = 1239900952130003033L;
    protected static final int FILE_SHIFT = 24;
    protected static final long FILE_MASK = 0xFFFFFFL;
    protected static final int MAX_FILE_SIZE_SHIFT = 20;
    protected static final long SIZEP = 2L;
    protected static final long RECIDP = 3L;
    protected static final long END = -2L;
    protected static final long SKIP = -1L;
    protected final File file;
    protected final boolean useRandomAccessFile;
    protected final boolean readOnly;
    protected final boolean syncOnCommit;
    protected final boolean deleteFilesAfterClose;
    protected final boolean tx;
    protected volatile boolean closed = false;
    protected volatile boolean modified = false;
    protected final LongConcurrentHashMap<Volume> volumes = new LongConcurrentHashMap();
    protected Volume currVolume;
    protected long currPos;
    protected long currFileNum;
    protected long maxRecid;
    protected long rollbackCurrPos;
    protected long rollbackCurrFileNum;
    protected long rollbackMaxRecid;
    protected Volume index = new Volume.MemoryVol(false, 0L, 20);
    protected final LongMap<Long> indexInTx;

    public StoreAppend(File file, boolean useRandomAccessFile, boolean readOnly, boolean transactionDisabled, boolean deleteFilesAfterClose, boolean syncOnCommitDisabled, boolean checksum, boolean compress, byte[] password, boolean disableLocks) {
        super(checksum, compress, password, disableLocks);
        long l;
        Volume zero;
        this.file = file;
        this.useRandomAccessFile = useRandomAccessFile;
        this.readOnly = readOnly;
        this.deleteFilesAfterClose = deleteFilesAfterClose;
        this.syncOnCommit = !syncOnCommitDisabled;
        this.tx = !transactionDisabled;
        this.indexInTx = this.tx ? new LongConcurrentHashMap() : null;
        File parent = file.getAbsoluteFile().getParentFile();
        if (!parent.exists() || !parent.isDirectory()) {
            throw new IllegalArgumentException("Parent dir does not exist: " + file);
        }
        TreeSet<Fun.Tuple2<Long, File>> sortedFiles = new TreeSet<Fun.Tuple2<Long, File>>();
        String prefix = file.getName();
        for (File f : parent.listFiles()) {
            String number;
            String name = f.getName();
            if (!name.startsWith(prefix) || name.length() <= prefix.length() + 1 || !(number = name.substring(prefix.length() + 1, name.length())).matches("^[0-9]+$")) continue;
            sortedFiles.add(Fun.t2(Long.valueOf(number), f));
        }
        if (sortedFiles.isEmpty()) {
            zero = Volume.volumeForFile(this.getFileFromNum(0L), useRandomAccessFile, readOnly, 0L, 20, 0);
            zero.ensureAvailable(64L);
            zero.putLong(0L, 1239900952130003033L);
            l = 8L;
            for (long recid = 1L; recid <= 7L; ++recid) {
                l += (long)zero.putPackedLong(l, recid + 3L);
                l += (long)zero.putPackedLong(l, 2L);
            }
            this.maxRecid = 7L;
            this.index.ensureAvailable(64L);
            this.volumes.put(0L, zero);
            if (this.tx) {
                this.rollbackCurrPos = l;
                this.rollbackMaxRecid = this.maxRecid;
                this.rollbackCurrFileNum = 0L;
                zero.putUnsignedByte(l, 1);
                ++l;
            }
        } else {
            for (Fun.Tuple2 tuple2 : sortedFiles) {
                File f;
                Long num = (Long)tuple2.a;
                f = (File)tuple2.b;
                Volume vol = Volume.volumeForFile(f, useRandomAccessFile, readOnly, 0L, 20, 0);
                if (vol.isEmpty() || vol.getLong(0L) != 1239900952130003033L) {
                    vol.sync();
                    vol.close();
                    Iterator<Volume> vols = this.volumes.valuesIterator();
                    while (vols.hasNext()) {
                        Volume next = vols.next();
                        next.sync();
                        next.close();
                    }
                    throw new IOError(new IOException("File corrupted: " + f));
                }
                this.volumes.put(num, vol);
                long pos2 = 8L;
                while (pos2 <= 0xFFFFFFL) {
                    long recid = vol.getPackedLong(pos2);
                    pos2 += (long)StoreAppend.packedLongSize(recid);
                    this.maxRecid = Math.max(recid -= 3L, this.maxRecid);
                    if (recid == -2L) {
                        this.currVolume = vol;
                        this.currPos = pos2;
                        this.currFileNum = num;
                        this.rollbackCurrFileNum = num;
                        this.rollbackMaxRecid = this.maxRecid;
                        this.rollbackCurrPos = pos2 - 1L;
                        return;
                    }
                    if (recid == -1L) continue;
                    if (recid <= 0L) {
                        Iterator<Volume> vols = this.volumes.valuesIterator();
                        while (vols.hasNext()) {
                            Volume next = vols.next();
                            next.sync();
                            next.close();
                        }
                        throw new IOError(new IOException("File corrupted: " + f));
                    }
                    this.index.ensureAvailable(recid * 8L + 8L);
                    long indexVal = num << 24 | pos2;
                    long size = vol.getPackedLong(pos2);
                    pos2 += (long)StoreAppend.packedLongSize(size);
                    if ((size -= 2L) == 0L) {
                        this.index.putLong(recid * 8L, 0L);
                        continue;
                    }
                    if (size > 0L) {
                        pos2 += size;
                        this.index.putLong(recid * 8L, indexVal);
                        continue;
                    }
                    this.index.putLong(recid * 8L, Long.MIN_VALUE);
                }
            }
            Iterator<Volume> vols = this.volumes.valuesIterator();
            while (vols.hasNext()) {
                Volume volume = vols.next();
                volume.sync();
                volume.close();
            }
            throw new IOError(new IOException("File not sealed, data possibly corrupted"));
        }
        this.currVolume = zero;
        this.currPos = l;
    }

    public StoreAppend(File file) {
        this(file, false, false, false, false, false, false, false, null, false);
    }

    protected File getFileFromNum(long fileNumber) {
        return new File(this.file.getPath() + "." + fileNumber);
    }

    protected void rollover() {
        if (this.currVolume.getLong(0L) != 1239900952130003033L) {
            throw new AssertionError();
        }
        if (this.currPos <= 0xFFFFFFL || this.readOnly) {
            return;
        }
        this.currVolume.sync();
        ++this.currFileNum;
        this.currVolume = Volume.volumeForFile(this.getFileFromNum(this.currFileNum), this.useRandomAccessFile, this.readOnly, 0L, 20, 0);
        this.currVolume.ensureAvailable(8L);
        this.currVolume.putLong(0L, 1239900952130003033L);
        this.currPos = 8L;
        this.volumes.put(this.currFileNum, this.currVolume);
    }

    protected long indexVal(long recid) {
        Long val;
        if (this.tx && (val = this.indexInTx.get(recid)) != null) {
            return val;
        }
        return this.index.getLong(recid * 8L);
    }

    protected void setIndexVal(long recid, long indexVal) {
        if (this.tx) {
            this.indexInTx.put(recid, indexVal);
        } else {
            this.index.ensureAvailable(recid * 8L + 8L);
            this.index.putLong(recid * 8L, indexVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long preallocate() {
        ReentrantReadWriteLock.ReadLock lock = this.locks[new Random().nextInt(this.locks.length)].readLock();
        lock.lock();
        try {
            long recid;
            this.structuralLock.lock();
            try {
                recid = ++this.maxRecid;
                this.modified = true;
            }
            finally {
                this.structuralLock.unlock();
            }
            assert (recid > 0L);
            long l = recid;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preallocate(long[] recids) {
        ReentrantReadWriteLock.ReadLock lock = this.locks[new Random().nextInt(this.locks.length)].readLock();
        lock.lock();
        try {
            this.structuralLock.lock();
            try {
                for (int i = 0; i < recids.length; ++i) {
                    recids[i] = ++this.maxRecid;
                    assert (recids[i] > 0L);
                }
                this.modified = true;
            }
            finally {
                this.structuralLock.unlock();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> long put(A value, Serializer<A> serializer) {
        assert (value != null);
        DataOutput2 out = this.serialize(value, serializer);
        ReentrantReadWriteLock.ReadLock lock = this.locks[new Random().nextInt(this.locks.length)].readLock();
        lock.lock();
        try {
            long oldPos;
            long indexVal;
            long recid;
            this.structuralLock.lock();
            try {
                this.rollover();
                this.currVolume.ensureAvailable(this.currPos + 6L + 4L + (long)out.pos);
                recid = ++this.maxRecid;
                this.currPos += (long)this.currVolume.putPackedLong(this.currPos, recid + 3L);
                indexVal = this.currFileNum << 24 | this.currPos;
                this.currPos += (long)this.currVolume.putPackedLong(this.currPos, (long)out.pos + 2L);
                oldPos = this.currPos;
                this.currPos += (long)out.pos;
                this.modified = true;
            }
            finally {
                this.structuralLock.unlock();
            }
            this.currVolume.putData(oldPos, out.buf, 0, out.pos);
            this.recycledDataOuts.offer(out);
            this.setIndexVal(recid, indexVal);
            assert (recid > 0L);
            long l = recid;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public <A> A get(long recid, Serializer<A> serializer) {
        assert (recid > 0L);
        ReentrantReadWriteLock.ReadLock lock = this.locks[Store.lockPos(recid)].readLock();
        lock.lock();
        try {
            A a = this.getNoLock(recid, serializer);
            return a;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            lock.unlock();
        }
    }

    protected <A> A getNoLock(long recid, Serializer<A> serializer) throws IOException {
        long indexVal = this.indexVal(recid);
        if (indexVal == 0L) {
            return null;
        }
        Volume vol = this.volumes.get(indexVal >>> 24);
        long fileOffset = indexVal & 0xFFFFFFL;
        long size = vol.getPackedLong(fileOffset);
        fileOffset += (long)StoreAppend.packedLongSize(size);
        if ((size -= 2L) < 0L) {
            return null;
        }
        if (size == 0L) {
            return serializer.deserialize(new DataInput2(new byte[0]), 0);
        }
        DataInput2 in = (DataInput2)vol.getDataInput(fileOffset, (int)size);
        return this.deserialize(serializer, (int)size, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void update(long recid, A value, Serializer<A> serializer) {
        assert (value != null);
        assert (recid > 0L);
        DataOutput2 out = this.serialize(value, serializer);
        ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(recid)].writeLock();
        lock.lock();
        try {
            this.updateNoLock(recid, out);
        }
        finally {
            lock.unlock();
        }
        this.recycledDataOuts.offer(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNoLock(long recid, DataOutput2 out) {
        long oldPos;
        long indexVal;
        this.structuralLock.lock();
        try {
            this.rollover();
            this.currVolume.ensureAvailable(this.currPos + 6L + 4L + (long)out.pos);
            this.currPos += (long)this.currVolume.putPackedLong(this.currPos, recid + 3L);
            indexVal = this.currFileNum << 24 | this.currPos;
            this.currPos += (long)this.currVolume.putPackedLong(this.currPos, (long)out.pos + 2L);
            oldPos = this.currPos;
            this.currPos += (long)out.pos;
            this.modified = true;
        }
        finally {
            this.structuralLock.unlock();
        }
        this.currVolume.putData(oldPos, out.buf, 0, out.pos);
        this.setIndexVal(recid, indexVal);
    }

    @Override
    public <A> boolean compareAndSwap(long recid, A expectedOldValue, A newValue, Serializer<A> serializer) {
        boolean ret;
        assert (expectedOldValue != null && newValue != null);
        assert (recid > 0L);
        DataOutput2 out = this.serialize(newValue, serializer);
        ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(recid)].writeLock();
        lock.lock();
        try {
            A old = this.getNoLock(recid, serializer);
            if (expectedOldValue.equals(old)) {
                this.updateNoLock(recid, out);
                ret = true;
            } else {
                ret = false;
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        finally {
            lock.unlock();
        }
        this.recycledDataOuts.offer(out);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <A> void delete(long recid, Serializer<A> serializer) {
        assert (recid > 0L);
        ReentrantReadWriteLock.WriteLock lock = this.locks[Store.lockPos(recid)].writeLock();
        lock.lock();
        try {
            this.structuralLock.lock();
            try {
                this.rollover();
                this.currVolume.ensureAvailable(this.currPos + 6L + 0L);
                this.currPos += (long)this.currVolume.putPackedLong(this.currPos, recid + 2L);
                this.setIndexVal(recid, this.currFileNum << 24 | this.currPos);
                this.currPos += (long)this.currVolume.putPackedLong(this.currPos, 1L);
                this.modified = true;
            }
            finally {
                this.structuralLock.unlock();
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        for (Runnable closeListener : this.closeListeners) {
            closeListener.run();
        }
        if (this.serializerPojo != null && this.serializerPojo.hasUnsavedChanges()) {
            this.serializerPojo.save(this);
        }
        Iterator<Volume> iter = this.volumes.valuesIterator();
        if (!this.readOnly && this.modified) {
            this.rollover();
            this.currVolume.putUnsignedByte(this.currPos, 1);
        }
        while (iter.hasNext()) {
            Volume v = iter.next();
            v.sync();
            v.close();
            if (!this.deleteFilesAfterClose) continue;
            v.deleteFile();
        }
        this.volumes.clear();
        this.index.close();
        this.index = null;
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        if (!this.tx) {
            this.currVolume.sync();
            return;
        }
        this.lockAllWrite();
        try {
            LongMap.LongMapIterator<Long> iter = this.indexInTx.longMapIterator();
            while (iter.moveToNext()) {
                this.index.ensureAvailable(iter.key() * 8L + 8L);
                this.index.putLong(iter.key() * 8L, iter.value());
            }
            Volume rollbackCurrVolume = this.volumes.get(this.rollbackCurrFileNum);
            rollbackCurrVolume.putUnsignedByte(this.rollbackCurrPos, 2);
            if (this.syncOnCommit) {
                rollbackCurrVolume.sync();
            }
            this.indexInTx.clear();
            this.rollover();
            this.rollbackCurrPos = this.currPos++;
            this.rollbackMaxRecid = this.maxRecid;
            this.rollbackCurrFileNum = this.currFileNum;
            this.currVolume.putUnsignedByte(this.rollbackCurrPos, 1);
            if (this.serializerPojo != null && this.serializerPojo.hasUnsavedChanges()) {
                this.serializerPojo.save(this);
            }
        }
        finally {
            this.unlockAllWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws UnsupportedOperationException {
        if (!this.tx) {
            throw new UnsupportedOperationException("Transactions are disabled");
        }
        this.lockAllWrite();
        try {
            this.indexInTx.clear();
            this.currVolume = this.volumes.get(this.rollbackCurrFileNum);
            this.currPos = this.rollbackCurrPos;
            this.maxRecid = this.rollbackMaxRecid;
            this.currFileNum = this.rollbackCurrFileNum;
        }
        finally {
            this.unlockAllWrite();
        }
    }

    @Override
    public boolean canRollback() {
        return this.tx;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void clearCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compact() {
        if (this.readOnly) {
            throw new IllegalAccessError("readonly");
        }
        this.lockAllWrite();
        try {
            if (!this.indexInTx.isEmpty()) {
                throw new IllegalAccessError("uncommited changes");
            }
            LongHashMap<Boolean> ff = new LongHashMap<Boolean>();
            for (long recid = 0L; recid <= this.maxRecid; ++recid) {
                long indexVal = this.index.getLong(recid * 8L);
                if (indexVal == 0L) continue;
                long fileNum = indexVal >>> 24;
                ff.put(fileNum, true);
            }
            LongMap.LongMapIterator<Volume> iter = this.volumes.longMapIterator();
            while (iter.moveToNext()) {
                long fileNum = iter.key();
                if (fileNum == this.currFileNum || ff.get(fileNum) != null) continue;
                Volume v = iter.value();
                v.sync();
                v.close();
                v.deleteFile();
                iter.remove();
            }
        }
        finally {
            this.unlockAllWrite();
        }
    }

    @Override
    public long getMaxRecid() {
        return this.maxRecid;
    }

    @Override
    public ByteBuffer getRaw(long recid) {
        byte[] bb = this.get(recid, Serializer.BYTE_ARRAY_NOSIZE);
        if (bb == null) {
            return null;
        }
        return ByteBuffer.wrap(bb);
    }

    @Override
    public Iterator<Long> getFreeRecids() {
        return Fun.EMPTY_ITERATOR;
    }

    @Override
    public void updateRaw(long recid, ByteBuffer data) {
        this.rollover();
        byte[] b = null;
        if (data != null) {
            data = data.duplicate();
            b = new byte[data.remaining()];
            data.get(b);
        }
        this.update(recid, b, Serializer.BYTE_ARRAY_NOSIZE);
        this.modified = true;
    }

    @Override
    public long getSizeLimit() {
        return 0L;
    }

    @Override
    public long getCurrSize() {
        return this.currFileNum * 0xFFFFFFL;
    }

    @Override
    public long getFreeSize() {
        return 0L;
    }

    @Override
    public String calculateStatistics() {
        return null;
    }

    protected static int packedLongSize(long value) {
        int ret = 1;
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            ++ret;
            value >>>= 7;
        }
        return ret;
    }
}

