/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.lucene.spin.config;

import java.util.Properties;
import org.eclipse.rdf4j.lucene.spin.LuceneSpinSail;
import org.eclipse.rdf4j.lucene.spin.config.LuceneSpinSailConfig;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailFactory;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.lucene.config.AbstractLuceneSailConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneSpinSailFactory
implements SailFactory {
    private static final Logger log = LoggerFactory.getLogger(LuceneSpinSailFactory.class);
    public static final String SAIL_TYPE = "openrdf:LuceneSpinSail";

    public String getSailType() {
        return SAIL_TYPE;
    }

    public SailImplConfig getConfig() {
        return new LuceneSpinSailConfig();
    }

    public Sail getSail(SailImplConfig config) throws SailConfigException {
        if (!SAIL_TYPE.equals(config.getType())) {
            throw new SailConfigException("Invalid Sail type: " + config.getType());
        }
        LuceneSpinSail sail = new LuceneSpinSail();
        Properties params = sail.getParameters();
        params.setProperty("index", "org.eclipse.rdf4j.sail.lucene.LuceneIndex");
        if (config instanceof AbstractLuceneSailConfig) {
            AbstractLuceneSailConfig luceneConfig = (AbstractLuceneSailConfig)config;
            log.debug("Lucene indexDir: {}", (Object)luceneConfig.getIndexDir());
            params.setProperty("lucenedir", luceneConfig.getIndexDir());
            for (String key : luceneConfig.getParameterNames()) {
                params.setProperty(key, luceneConfig.getParameter(key));
            }
        }
        return sail;
    }
}

