/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean.concurrent;

import com.opencsv.bean.CsvToBeanFilter;
import com.opencsv.bean.MappingStrategy;
import com.opencsv.bean.OpencsvUtils;
import com.opencsv.bean.concurrent.OrderedObject;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvConstraintViolationException;
import com.opencsv.exceptions.CsvDataTypeMismatchException;
import com.opencsv.exceptions.CsvException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.BlockingQueue;

public class ProcessCsvLine<T>
implements Runnable {
    private final long lineNumber;
    private final MappingStrategy<T> mapper;
    private final CsvToBeanFilter filter;
    private final String[] line;
    private final BlockingQueue<OrderedObject<T>> resultantBeanQueue;
    private final BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue;
    private final boolean throwExceptions;

    public ProcessCsvLine(long lineNumber, MappingStrategy<T> mapper, CsvToBeanFilter filter, String[] line, BlockingQueue<OrderedObject<T>> resultantBeanQueue, BlockingQueue<OrderedObject<CsvException>> thrownExceptionsQueue, boolean throwExceptions) {
        this.lineNumber = lineNumber;
        this.mapper = mapper;
        this.filter = filter;
        this.line = line;
        this.resultantBeanQueue = resultantBeanQueue;
        this.thrownExceptionsQueue = thrownExceptionsQueue;
        this.throwExceptions = throwExceptions;
    }

    @Override
    public void run() {
        try {
            if (this.filter == null || this.filter.allowLine(this.line)) {
                T obj = this.processLine();
                OpencsvUtils.queueRefuseToAcceptDefeat(this.resultantBeanQueue, new OrderedObject<T>(this.lineNumber, obj));
            }
        }
        catch (CsvException e) {
            e.setLineNumber(this.lineNumber);
            if (this.throwExceptions) {
                throw new RuntimeException(e);
            }
            OpencsvUtils.queueRefuseToAcceptDefeat(this.thrownExceptionsQueue, new OrderedObject<CsvException>(this.lineNumber, e));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private T processLine() throws IllegalAccessException, InvocationTargetException, InstantiationException, IntrospectionException, CsvBadConverterException, CsvDataTypeMismatchException, CsvRequiredFieldEmptyException, CsvConstraintViolationException {
        return this.mapper.populateNewBean(this.line);
    }
}

