/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.model.vocabulary.SPINX;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.TripleSource;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.TripleSources;
import org.eclipse.rdf4j.spin.Argument;
import org.eclipse.rdf4j.spin.SpinParser;
import org.eclipse.rdf4j.spin.function.FunctionParser;
import org.eclipse.rdf4j.spin.function.SpinxFunction;

public class SpinxFunctionParser
implements FunctionParser {
    private final SpinParser parser;
    private final ScriptEngineManager scriptManager;

    public SpinxFunctionParser(SpinParser parser) {
        this.parser = parser;
        this.scriptManager = new ScriptEngineManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Function parse(IRI funcUri, TripleSource store) throws RDF4JException {
        ScriptEngine engine;
        String code;
        block14: {
            String file;
            Value codeValue = TripleSources.singleValue((Resource)funcUri, SPINX.JAVA_SCRIPT_CODE_PROPERTY, store);
            code = codeValue instanceof Literal ? ((Literal)codeValue).getLabel() : null;
            Value fileValue = TripleSources.singleValue((Resource)funcUri, SPINX.JAVA_SCRIPT_FILE_PROPERTY, store);
            String string = file = fileValue instanceof Literal ? ((Literal)fileValue).getLabel() : null;
            if (code == null && file == null) {
                return null;
            }
            if (code == null) {
                code = funcUri.getLocalName();
            }
            engine = this.scriptManager.getEngineByName("javascript");
            try {
                if (file == null) break block14;
                String ns = funcUri.getNamespace();
                try {
                    InputStreamReader reader = new InputStreamReader(new URL(new URL(ns.substring(0, ns.length() - 1)), file).openStream());
                    try {
                        engine.eval(reader);
                    }
                    finally {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (IOException e) {
                    throw new QueryEvaluationException((Throwable)e);
                }
            }
            catch (ScriptException e) {
                throw new QueryEvaluationException((Throwable)e);
            }
        }
        Value returnValue = TripleSources.singleValue((Resource)funcUri, SPIN.RETURN_TYPE_PROPERTY, store);
        Map<IRI, Argument> templateArgs = this.parser.parseArguments(funcUri, store);
        SpinxFunction func = new SpinxFunction(funcUri.stringValue());
        func.setScriptEngine(engine);
        func.setScript(code);
        func.setReturnType((URI)(returnValue instanceof IRI ? (IRI)returnValue : null));
        List<IRI> orderedArgs = SpinParser.orderArguments(templateArgs.keySet());
        for (IRI IRI2 : orderedArgs) {
            Argument arg = templateArgs.get(IRI2);
            func.addArgument(arg);
        }
        return func;
    }
}

