/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iterations;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingNode
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(LoggingNode.class);
    PlanNode parent;
    String message;
    private boolean pullAll = true;
    public static boolean loggingEnabled = false;

    public LoggingNode(PlanNode parent, String message) {
        this.parent = parent;
        this.message = message;
        assert (message != null);
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        if (!loggingEnabled) {
            return this.parent.iterator();
        }
        return new CloseableIteration<Tuple, SailException>(){
            CloseableIteration<Tuple, SailException> parentIterator;
            {
                this.parentIterator = LoggingNode.this.parent.iterator();
                if (LoggingNode.this.pullAll) {
                    this.parentIterator = this.cachedIterator(this.parentIterator);
                }
            }

            private CloseableIteration<Tuple, SailException> cachedIterator(CloseableIteration<Tuple, SailException> fromIterator) {
                Stream stream = Iterations.stream(fromIterator);
                final List collect = stream.collect(Collectors.toList());
                return new CloseableIteration<Tuple, SailException>(){
                    Iterator<Tuple> iterator;
                    {
                        this.iterator = collect.iterator();
                    }

                    public void close() throws SailException {
                    }

                    public boolean hasNext() throws SailException {
                        return this.iterator.hasNext();
                    }

                    public Tuple next() throws SailException {
                        return this.iterator.next();
                    }

                    public void remove() throws SailException {
                    }
                };
            }

            public void close() throws SailException {
                this.parentIterator.close();
            }

            public boolean hasNext() throws SailException {
                boolean hasNext = this.parentIterator.hasNext();
                return hasNext;
            }

            public Tuple next() throws SailException {
                assert (this.parentIterator.hasNext()) : this.parentIterator.getClass().getSimpleName() + " does not have any more items but next was still called!!!";
                Tuple next = (Tuple)this.parentIterator.next();
                assert (next != null);
                logger.info(LoggingNode.this.leadingSpace() + LoggingNode.this.message + LoggingNode.this.parent.getClass().getSimpleName() + ".next():  " + next.toString());
                return next;
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        this.parent.getPlanAsGraphvizDot(stringBuilder);
    }

    @Override
    public String getId() {
        return this.parent.getId();
    }

    @Override
    public IteratorData getIteratorDataType() {
        return this.parent.getIteratorDataType();
    }

    private String leadingSpace() {
        return StringUtils.leftPad((String)"", (int)this.depth(), (String)"    ");
    }
}

