/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene.fn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteratorIteration;
import org.eclipse.rdf4j.common.iteration.ConvertingIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryContext;
import org.eclipse.rdf4j.query.algebra.evaluation.function.TupleFunction;
import org.eclipse.rdf4j.sail.lucene.DistanceQuerySpec;
import org.eclipse.rdf4j.sail.lucene.LuceneSailSchema;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.eclipse.rdf4j.sail.lucene.SearchIndexQueryContextInitializer;

public class DistanceTupleFunction
implements TupleFunction {
    @Override
    public String getURI() {
        return LuceneSailSchema.WITHIN_DISTANCE.toString();
    }

    @Override
    public CloseableIteration<? extends List<? extends Value>, QueryEvaluationException> evaluate(ValueFactory valueFactory, Value ... args) throws QueryEvaluationException {
        int i = 0;
        Literal from = (Literal)args[i++];
        Literal maxDist = (Literal)args[i++];
        IRI units = (IRI)args[i++];
        IRI geoProperty = (IRI)args[i++];
        String geoVar = "geometry";
        String subjectVar = "subject";
        String distanceVar = null;
        if (args.length - i > 0 && LuceneSailSchema.DISTANCE.equals((Object)args[i])) {
            distanceVar = "distance";
            ++i;
        }
        Var contextVar = null;
        if (args.length - i > 0) {
            contextVar = new Var("context");
            Resource context = (Resource)args[i];
            if (!LuceneSailSchema.CONTEXT.equals((Object)context)) {
                contextVar.setValue((Value)context);
            }
        }
        final DistanceQuerySpec query = new DistanceQuerySpec(from, units, maxDist.doubleValue(), distanceVar, geoProperty, geoVar, subjectVar, contextVar);
        SearchIndex luceneIndex = SearchIndexQueryContextInitializer.getSearchIndex(QueryContext.getQueryContext());
        Collection<BindingSet> results = luceneIndex.evaluate(query);
        return new ConvertingIteration<BindingSet, List<Value>, QueryEvaluationException>((Iteration)new CloseableIteratorIteration(results.iterator())){

            protected List<Value> convert(BindingSet bindings) throws QueryEvaluationException {
                ArrayList<Value> results = new ArrayList<Value>(3);
                if (query.getSubjectVar() != null) {
                    results.add(bindings.getValue(query.getSubjectVar()));
                }
                if (query.getGeoVar() != null) {
                    results.add(bindings.getValue(query.getGeoVar()));
                }
                if (query.getDistanceVar() != null) {
                    results.add(bindings.getValue(query.getDistanceVar()));
                }
                if (query.getContextVar() != null) {
                    results.add(bindings.getValue(query.getContextVar().getName()));
                }
                return results;
            }
        };
    }
}

