/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail;

import java.util.ArrayList;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResultHandler;
import org.eclipse.rdf4j.query.QueryResults;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.impl.TupleQueryResultImpl;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.ParsedTupleQuery;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailConnectionQuery;
import org.eclipse.rdf4j.sail.SailException;

public class SailConnectionTupleQuery
extends SailConnectionQuery
implements TupleQuery {
    public SailConnectionTupleQuery(ParsedTupleQuery tupleQuery, SailConnection sailConnection) {
        super((ParsedQuery)tupleQuery, sailConnection);
    }

    public ParsedTupleQuery getParsedQuery() {
        return (ParsedTupleQuery)super.getParsedQuery();
    }

    public TupleQueryResult evaluate() throws QueryEvaluationException {
        TupleExpr tupleExpr = this.getParsedQuery().getTupleExpr();
        try {
            SailConnection sailCon = this.getSailConnection();
            CloseableIteration bindingsIter = sailCon.evaluate(tupleExpr, this.getActiveDataset(), this.getBindings(), this.getIncludeInferred());
            bindingsIter = this.enforceMaxQueryTime(bindingsIter);
            return new TupleQueryResultImpl(new ArrayList(tupleExpr.getBindingNames()), bindingsIter);
        }
        catch (SailException e) {
            throw new QueryEvaluationException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public void evaluate(TupleQueryResultHandler handler) throws QueryEvaluationException, TupleQueryResultHandlerException {
        TupleQueryResult queryResult = this.evaluate();
        QueryResults.report((TupleQueryResult)queryResult, (QueryResultHandler)handler);
    }
}

