/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail;

import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailConnectionQuery;
import org.eclipse.rdf4j.sail.SailException;

public class SailConnectionBooleanQuery
extends SailConnectionQuery
implements BooleanQuery {
    public SailConnectionBooleanQuery(ParsedBooleanQuery tupleQuery, SailConnection sailConnection) {
        super((ParsedQuery)tupleQuery, sailConnection);
    }

    public ParsedBooleanQuery getParsedQuery() {
        return (ParsedBooleanQuery)super.getParsedQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluate() throws QueryEvaluationException {
        boolean bl;
        ParsedBooleanQuery parsedBooleanQuery = this.getParsedQuery();
        TupleExpr tupleExpr = parsedBooleanQuery.getTupleExpr();
        Dataset dataset = this.getDataset();
        if (dataset == null) {
            dataset = parsedBooleanQuery.getDataset();
        }
        SailConnection sailCon = this.getSailConnection();
        CloseableIteration bindingsIter = sailCon.evaluate(tupleExpr, dataset, this.getBindings(), this.getIncludeInferred());
        bindingsIter = this.enforceMaxQueryTime(bindingsIter);
        try {
            bl = bindingsIter.hasNext();
        }
        catch (Throwable throwable) {
            try {
                bindingsIter.close();
                throw throwable;
            }
            catch (SailException e) {
                throw new QueryEvaluationException(e.getMessage(), (Throwable)((Object)e));
            }
        }
        bindingsIter.close();
        return bl;
    }
}

