/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.CastFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public class StringCast
extends CastFunction {
    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException(this.getXsdName() + " cast requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            IRI datatype = literal.getDatatype();
            if (QueryEvaluationUtil.isSimpleLiteral(literal)) {
                String lexicalValue = XMLDatatypeUtil.collapseWhiteSpace((String)literal.getLabel());
                if (this.isValidForDatatype(lexicalValue)) {
                    return valueFactory.createLiteral(lexicalValue, this.getXsdDatatype());
                }
            } else if (datatype != null && datatype.equals((Object)this.getXsdDatatype())) {
                return literal;
            }
            return this.convert(valueFactory, (Value)literal);
        }
        return this.convert(valueFactory, args[0]);
    }

    @Override
    protected Literal convert(ValueFactory valueFactory, Value value) throws ValueExprEvaluationException {
        if (value instanceof IRI) {
            return valueFactory.createLiteral(value.toString(), XMLSchema.STRING);
        }
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            IRI datatype = literal.getDatatype();
            if (QueryEvaluationUtil.isSimpleLiteral(literal)) {
                return valueFactory.createLiteral(literal.getLabel(), XMLSchema.STRING);
            }
            if (!Literals.isLanguageLiteral((Literal)literal)) {
                if (XMLDatatypeUtil.isNumericDatatype((IRI)datatype) || datatype.equals((Object)XMLSchema.BOOLEAN) || datatype.equals((Object)XMLSchema.DATETIME)) {
                    if (XMLDatatypeUtil.isValidValue((String)literal.getLabel(), (IRI)datatype)) {
                        String normalizedValue = XMLDatatypeUtil.normalize((String)literal.getLabel(), (IRI)datatype);
                        return valueFactory.createLiteral(normalizedValue, XMLSchema.STRING);
                    }
                    return valueFactory.createLiteral(literal.getLabel(), XMLSchema.STRING);
                }
                return valueFactory.createLiteral(literal.getLabel(), XMLSchema.STRING);
            }
        }
        throw this.typeError(value, null);
    }

    @Override
    protected IRI getXsdDatatype() {
        return XMLSchema.STRING;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return true;
    }
}

