/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.string;

import java.util.Optional;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public class LowerCase
implements Function {
    @Override
    public String getURI() {
        return FN.LOWER_CASE.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException("LCASE requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            if (QueryEvaluationUtil.isStringLiteral(literal)) {
                String lexicalValue = literal.getLabel().toLowerCase();
                Optional language = literal.getLanguage();
                if (language.isPresent()) {
                    return valueFactory.createLiteral(lexicalValue, (String)language.get());
                }
                if (XMLSchema.STRING.equals((Object)literal.getDatatype())) {
                    return valueFactory.createLiteral(lexicalValue, XMLSchema.STRING);
                }
                return valueFactory.createLiteral(lexicalValue);
            }
            throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
        }
        throw new ValueExprEvaluationException("unexpected input value for function: " + args[0]);
    }
}

