/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.sail.shacl.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class PatternFilter
extends FilterPlanNode {
    private final Pattern pattern;

    public PatternFilter(PlanNode parent, String pattern, Optional<String> flags) {
        super(parent);
        if (flags.isPresent()) {
            int flag = 0;
            String flagsString = flags.get();
            if (flagsString.contains("i")) {
                flag |= 2;
            }
            if (flagsString.contains("d")) {
                flag |= 1;
            }
            if (flagsString.contains("m")) {
                flag |= 8;
            }
            if (flagsString.contains("s")) {
                flag |= 0x20;
            }
            if (flagsString.contains("u")) {
                flag |= 0x40;
            }
            if (flagsString.contains("x")) {
                flag |= 4;
            }
            if (flagsString.contains("U")) {
                flag |= 0x100;
            }
            this.pattern = Pattern.compile(pattern, flag);
        } else {
            this.pattern = Pattern.compile(pattern);
        }
    }

    @Override
    boolean checkTuple(Tuple t) {
        Value literal = t.line.get(1);
        return this.pattern.matcher(literal.stringValue()).matches();
    }

    @Override
    public String toString() {
        return "PatternFilter{pattern=" + this.pattern + '}';
    }
}

