/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.CastFunction;

public class FloatCast
extends CastFunction {
    @Override
    protected Literal convert(ValueFactory valueFactory, Value value) throws ValueExprEvaluationException {
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            IRI datatype = literal.getDatatype();
            if (XMLDatatypeUtil.isNumericDatatype(datatype)) {
                try {
                    float floatValue = literal.floatValue();
                    return valueFactory.createLiteral(floatValue);
                }
                catch (NumberFormatException e) {
                    throw this.typeError(literal, e);
                }
            }
            if (datatype.equals(XMLSchema.BOOLEAN)) {
                try {
                    return valueFactory.createLiteral(literal.booleanValue() ? 1.0f : 0.0f);
                }
                catch (IllegalArgumentException e) {
                    throw this.typeError(literal, e);
                }
            }
        }
        throw this.typeError(value, null);
    }

    @Override
    protected IRI getXsdDatatype() {
        return XMLSchema.FLOAT;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return XMLDatatypeUtil.isValidFloat(lexicalValue);
    }
}

