/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.CalType;
import com.ibm.icu.impl.Grego;
import com.ibm.icu.impl.ICUResourceBundle;
import com.ibm.icu.util.ICUException;
import com.ibm.icu.util.TimeZone;
import com.ibm.icu.util.UResourceBundle;
import com.ibm.icu.util.UResourceBundleIterator;
import java.util.ArrayList;
import java.util.Arrays;

public class EraRules {
    private static final int MAX_ENCODED_START_YEAR = Short.MAX_VALUE;
    private static final int MIN_ENCODED_START_YEAR = Short.MIN_VALUE;
    public static final int MIN_ENCODED_START = EraRules.encodeDate(Short.MIN_VALUE, 1, 1);
    private static final int YEAR_MASK = -65536;
    private static final int MONTH_MASK = 65280;
    private static final int DAY_MASK = 255;
    private int[] startDates;
    private int minEra;
    private int numEras;
    private int currentEra;

    private EraRules(int[] startDates, int minEra, int numEras) {
        this.startDates = startDates;
        this.minEra = minEra;
        this.numEras = numEras;
        this.initCurrentEra();
    }

    public static EraRules getInstance(CalType calType, boolean includeTentativeEra) {
        return EraRules.getInstance(calType.getId(), includeTentativeEra);
    }

    public static EraRules getInstance(String calId, boolean includeTentativeEra) {
        int eraIdx;
        UResourceBundle supplementalDataRes = UResourceBundle.getBundleInstance("com/ibm/icu/impl/data/icudata", "supplementalData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle calendarDataRes = supplementalDataRes.get("calendarData");
        UResourceBundle calendarTypeRes = calendarDataRes.get(calId);
        UResourceBundle erasRes = calendarTypeRes.get("eras");
        int numEras = erasRes.getSize();
        int firstTentativeIdx = Integer.MAX_VALUE;
        ArrayList<Integer> eraStartDates = new ArrayList<Integer>(numEras);
        UResourceBundleIterator itr = erasRes.getIterator();
        while (itr.hasNext()) {
            UResourceBundle eraRuleRes = itr.next();
            String eraIdxStr = eraRuleRes.getKey();
            eraIdx = -1;
            try {
                eraIdx = Integer.parseInt(eraIdxStr);
            }
            catch (NumberFormatException e) {
                throw new ICUException("Invalid era rule key:" + eraIdxStr + " in era rule data for " + calId);
            }
            if (eraIdx < 0) {
                throw new ICUException("Era rule key:" + eraIdxStr + " in era rule data for " + calId + " must be >= 0");
            }
            if (eraIdx + 1 > eraStartDates.size()) {
                eraStartDates.ensureCapacity(eraIdx + 1);
                while (eraStartDates.size() < eraIdx + 1) {
                    eraStartDates.add(0);
                }
            }
            if (EraRules.isSet((Integer)eraStartDates.get(eraIdx))) {
                throw new ICUException("Duplicated era rule for rule key:" + eraIdxStr + " in era rule data for " + calId);
            }
            boolean hasName = true;
            boolean hasEnd = false;
            UResourceBundleIterator ruleItr = eraRuleRes.getIterator();
            while (ruleItr.hasNext()) {
                UResourceBundle res = ruleItr.next();
                String key = res.getKey();
                if (key.equals("start")) {
                    int[] fields = res.getIntVector();
                    if (fields.length != 3 || !EraRules.isValidRuleStartDate(fields[0], fields[1], fields[2])) {
                        throw new ICUException("Invalid era rule date data:" + Arrays.toString(fields) + " in era rule data for " + calId);
                    }
                    eraStartDates.set(eraIdx, EraRules.encodeDate(fields[0], fields[1], fields[2]));
                    continue;
                }
                if (key.equals("named")) {
                    String val = res.getString();
                    if (!val.equals("false")) continue;
                    hasName = false;
                    continue;
                }
                if (!key.equals("end")) continue;
                hasEnd = true;
            }
            if (EraRules.isSet((Integer)eraStartDates.get(eraIdx))) {
                if (hasEnd) {
                    // empty if block
                }
            } else if (hasEnd) {
                eraStartDates.set(eraIdx, MIN_ENCODED_START);
            } else {
                throw new ICUException("Missing era start/end rule date for key:" + eraIdxStr + " in era rule data for " + calId);
            }
            if (hasName) {
                if (eraIdx < firstTentativeIdx) continue;
                throw new ICUException("Non-tentative era(" + eraIdx + ") must be placed before the first tentative era");
            }
            if (eraIdx >= firstTentativeIdx) continue;
            firstTentativeIdx = eraIdx;
        }
        if (!includeTentativeEra) {
            while (firstTentativeIdx < eraStartDates.size()) {
                int lastEraIdx = eraStartDates.size() - 1;
                if (EraRules.isSet((Integer)eraStartDates.get(lastEraIdx))) {
                    --numEras;
                }
                eraStartDates.remove(lastEraIdx);
            }
            while (eraStartDates.size() > 0 && !EraRules.isSet((Integer)eraStartDates.get(eraStartDates.size() - 1))) {
                eraStartDates.remove(eraStartDates.size() - 1);
            }
        }
        int minEra = 0;
        while (eraStartDates.size() > 0 && !EraRules.isSet((Integer)eraStartDates.get(0))) {
            eraStartDates.remove(0);
            ++minEra;
        }
        int[] startDates = new int[eraStartDates.size()];
        for (eraIdx = 0; eraIdx < eraStartDates.size(); ++eraIdx) {
            startDates[eraIdx] = (Integer)eraStartDates.get(eraIdx);
        }
        return new EraRules(startDates, minEra, numEras);
    }

    public int getNumberOfEras() {
        return this.numEras;
    }

    public int getMaxEraCode() {
        return this.minEra + this.startDates.length - 1;
    }

    public int[] getStartDate(int eraCode, int[] fillIn) {
        int startIdx;
        int startDate = 0;
        if (eraCode >= this.minEra && (startIdx = eraCode - this.minEra) < this.startDates.length) {
            startDate = this.startDates[startIdx];
        }
        if (EraRules.isSet(startDate)) {
            return EraRules.decodeDate(startDate, fillIn);
        }
        throw new IllegalArgumentException("eraCode is not found in our data");
    }

    public int getStartYear(int eraCode) {
        int startIdx;
        int startDate = 0;
        if (eraCode >= this.minEra && (startIdx = eraCode - this.minEra) < this.startDates.length) {
            startDate = this.startDates[startIdx];
        }
        if (EraRules.isSet(startDate)) {
            int[] fields = EraRules.decodeDate(startDate, null);
            return fields[0];
        }
        throw new IllegalArgumentException("eraCode is not found in our data");
    }

    public int getEraCode(int year, int month, int day) {
        int startIdx;
        if (month < 1 || month > 12 || day < 1 || day > 31) {
            throw new IllegalArgumentException("Illegal date - year:" + year + "month:" + month + "day:" + day);
        }
        if (this.numEras > 1 && this.startDates[this.startDates.length - 1] == MIN_ENCODED_START) {
            for (startIdx = 0; startIdx < this.startDates.length; ++startIdx) {
                if (!EraRules.isSet(this.startDates[startIdx]) || EraRules.compareEncodedDateWithYMD(this.startDates[startIdx], year, month, day) > 0) continue;
                return this.minEra + startIdx;
            }
        }
        startIdx = this.startDates.length;
        while (startIdx > 0) {
            if (!EraRules.isSet(this.startDates[--startIdx]) || EraRules.compareEncodedDateWithYMD(this.startDates[startIdx], year, month, day) > 0) continue;
            return this.minEra + startIdx;
        }
        return this.minEra;
    }

    public int getCurrentEraCode() {
        return this.currentEra;
    }

    private void initCurrentEra() {
        long localMillis = System.currentTimeMillis();
        TimeZone zone = TimeZone.getDefault();
        localMillis += (long)zone.getOffset(localMillis);
        int[] fields = Grego.timeToFields(localMillis, null);
        this.currentEra = this.getEraCode(fields[0], fields[1] + 1, fields[2]);
    }

    private static boolean isSet(int startDate) {
        return startDate != 0;
    }

    private static boolean isValidRuleStartDate(int year, int month, int day) {
        return year >= Short.MIN_VALUE && year <= Short.MAX_VALUE && month >= 1 && month <= 12 && day >= 1 && day <= 31;
    }

    private static int encodeDate(int year, int month, int day) {
        return year << 16 | month << 8 | day;
    }

    private static int[] decodeDate(int encodedDate, int[] fillIn) {
        int day;
        int month;
        int year;
        if (encodedDate == MIN_ENCODED_START) {
            year = Integer.MIN_VALUE;
            month = 1;
            day = 1;
        } else {
            year = (encodedDate & 0xFFFF0000) >> 16;
            month = (encodedDate & 0xFF00) >> 8;
            day = encodedDate & 0xFF;
        }
        if (fillIn != null && fillIn.length >= 3) {
            fillIn[0] = year;
            fillIn[1] = month;
            fillIn[2] = day;
            return fillIn;
        }
        int[] result = new int[]{year, month, day};
        return result;
    }

    private static int compareEncodedDateWithYMD(int encoded, int year, int month, int day) {
        if (year < Short.MIN_VALUE) {
            if (encoded == MIN_ENCODED_START) {
                if (year > Integer.MIN_VALUE || month > 1 || day > 1) {
                    return -1;
                }
                return 0;
            }
            return 1;
        }
        if (year > Short.MAX_VALUE) {
            return -1;
        }
        int tmp = EraRules.encodeDate(year, month, day);
        if (encoded < tmp) {
            return -1;
        }
        if (encoded == tmp) {
            return 0;
        }
        return 1;
    }
}

