/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.JSON;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2Controller;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2DOMContentLoadedEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2Deferral;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2Environment;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2Environment2;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2EnvironmentOptions;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2MoveFocusRequestedEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2NavigationCompletedEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2NavigationStartingEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2NewWindowRequestedEventArgs;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2Settings;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2SwtCallback;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2SwtHost;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2WindowFeatures;
import org.eclipse.swt.internal.ole.win32.ICoreWebView2_2;
import org.eclipse.swt.internal.ole.win32.IStream;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

class Edge
extends WebBrowser {
    static final String SDK_TARGET_VERSION = "89.0.721.0";
    static final String APPLOCAL_DIR_KEY = "org.eclipse.swt.internal.win32.appLocalDir";
    static final String BROWSER_DIR_PROP = "org.eclipse.swt.browser.EdgeDir";
    static final String BROWSER_ARGS_PROP = "org.eclipse.swt.browser.EdgeArgs";
    static final String DATA_DIR_PROP = "org.eclipse.swt.browser.EdgeDataDir";
    static final String LANGUAGE_PROP = "org.eclipse.swt.browser.EdgeLanguage";
    static final String VERSIONT_PROP = "org.eclipse.swt.browser.EdgeVersion";
    static String DataDir;
    static ICoreWebView2Environment Environment;
    ICoreWebView2 webView;
    ICoreWebView2_2 webView2;
    ICoreWebView2Controller controller;
    ICoreWebView2Settings settings;
    ICoreWebView2Environment2 environment2;
    static boolean inCallback;
    boolean inNewWindow;
    HashMap<Long, LocationEvent> navigations = new HashMap();

    static {
        Library.loadLibrary("WebView2Loader", false);
    }

    Edge() {
    }

    static String wstrToString(long psz, boolean free) {
        if (psz == 0L) {
            return "";
        }
        int len = OS.wcslen(psz);
        char[] data = new char[len];
        OS.MoveMemory(data, psz, len * 2);
        if (free) {
            OS.CoTaskMemFree(psz);
        }
        return String.valueOf(data);
    }

    static String bstrToString(long bstr) {
        if (bstr == 0L) {
            return "";
        }
        int len = COM.SysStringLen(bstr);
        char[] data = new char[len];
        OS.MoveMemory(data, bstr, len * 2);
        return String.valueOf(data);
    }

    static void error(int code, int hr) {
        SWT.error(code, null, String.format(" [0x%08x]", hr));
    }

    static IUnknown newCallback(ICoreWebView2SwtCallback handler) {
        long punk = COM.CreateSwtWebView2Callback((arg0, arg1) -> {
            inCallback = true;
            try {
                int n = handler.Invoke(arg0, arg1);
                return n;
            }
            finally {
                inCallback = false;
            }
        });
        if (punk == 0L) {
            Edge.error(2, -2147024882);
        }
        return new IUnknown(punk);
    }

    IUnknown newHostObject(ICoreWebView2SwtHost handler) {
        long pdisp = COM.CreateSwtWebView2Host(handler);
        if (pdisp == 0L) {
            Edge.error(2, -2147024882);
        }
        return new IUnknown(pdisp);
    }

    void checkDeadlock() {
        if (inCallback || this.inNewWindow) {
            SWT.error(50, null, " [WebView2: deadlock detected]");
        }
    }

    ICoreWebView2Environment createEnvironment() {
        long pOpts;
        if (Environment != null) {
            return Environment;
        }
        Display display = Display.getCurrent();
        String browserDir = System.getProperty(BROWSER_DIR_PROP);
        String dataDir = System.getProperty(DATA_DIR_PROP);
        String browserArgs = System.getProperty(BROWSER_ARGS_PROP);
        String language = System.getProperty(LANGUAGE_PROP);
        if (dataDir == null) {
            dataDir = (String)display.getData(APPLOCAL_DIR_KEY);
        }
        if ((pOpts = COM.CreateSwtWebView2Options()) == 0L) {
            Edge.error(2, -2147024882);
        }
        ICoreWebView2EnvironmentOptions options = new ICoreWebView2EnvironmentOptions(pOpts);
        char[] pVersion = "89.0.721.0\u0000".toCharArray();
        options.put_TargetCompatibleBrowserVersion(pVersion);
        if (browserArgs != null) {
            char[] pBrowserArgs = (String.valueOf(browserArgs) + "\u0000").toCharArray();
            options.put_AdditionalBrowserArguments(pBrowserArgs);
        }
        if (language != null) {
            char[] pLanguage = (String.valueOf(language) + "\u0000").toCharArray();
            options.put_Language(pLanguage);
        }
        char[] pBrowserDir = browserDir != null ? (String.valueOf(browserDir) + "\u0000").toCharArray() : null;
        char[] pDataDir = (String.valueOf(dataDir) + "\u0000").toCharArray();
        int[] pResult = new int[1];
        long[] ppEnv = new long[1];
        IUnknown completion = Edge.newCallback((result, pEnv) -> {
            nArray[0] = (int)result;
            if ((int)result == 0) {
                lArray[0] = pEnv;
                new IUnknown(pEnv).AddRef();
            }
            return 0;
        });
        pResult[0] = COM.CreateCoreWebView2EnvironmentWithOptions(pBrowserDir, pDataDir, options.getAddress(), completion.getAddress());
        completion.Release();
        options.Release();
        if (pResult[0] == OS.HRESULT_FROM_WIN32(2)) {
            SWT.error(20, null, " [WebView2 runtime not found]");
        }
        while (pResult[0] == 0 && ppEnv[0] == 0L) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (pResult[0] != 0) {
            Edge.error(2, pResult[0]);
        }
        Environment = new ICoreWebView2Environment(ppEnv[0]);
        DataDir = dataDir;
        long[] ppVersion = new long[1];
        Environment.get_BrowserVersionString(ppVersion);
        String version = Edge.wstrToString(ppVersion[0], true);
        System.setProperty(VERSIONT_PROP, version);
        display.disposeExec(() -> {
            Environment.Release();
            Environment = null;
        });
        return Environment;
    }

    @Override
    public void create(Composite parent, int style) {
        this.checkDeadlock();
        ICoreWebView2Environment environment = this.createEnvironment();
        int[] pResult = new int[1];
        long[] ppv = new long[1];
        long[] ppHost = new long[1];
        int hr = environment.QueryInterface(COM.IID_ICoreWebView2Environment2, ppv);
        if (hr == 0) {
            this.environment2 = new ICoreWebView2Environment2(ppv[0]);
        }
        IUnknown completion = Edge.newCallback((result, pHost) -> {
            nArray[0] = (int)result;
            if ((int)result == 0) {
                lArray[0] = pHost;
                new IUnknown(pHost).AddRef();
            }
            return 0;
        });
        pResult[0] = environment.CreateCoreWebView2Controller(this.browser.handle, completion);
        completion.Release();
        Display display = this.browser.getDisplay();
        while (pResult[0] == 0 && ppHost[0] == 0L) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (pResult[0] != 0) {
            Edge.error(2, pResult[0]);
        }
        this.controller = new ICoreWebView2Controller(ppHost[0]);
        this.controller.get_CoreWebView2(ppv);
        this.webView = new ICoreWebView2(ppv[0]);
        this.webView.get_Settings(ppv);
        this.settings = new ICoreWebView2Settings(ppv[0]);
        hr = this.webView.QueryInterface(COM.IID_ICoreWebView2_2, ppv);
        if (hr == 0) {
            this.webView2 = new ICoreWebView2_2(ppv[0]);
        }
        long[] token = new long[1];
        IUnknown handler = Edge.newCallback(this::handleCloseRequested);
        this.webView.add_WindowCloseRequested(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleNavigationStarting);
        this.webView.add_NavigationStarting(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleFrameNavigationStarting);
        this.webView.add_FrameNavigationStarting(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleNavigationCompleted);
        this.webView.add_NavigationCompleted(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleFrameNavigationCompleted);
        this.webView.add_FrameNavigationCompleted(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleDocumentTitleChanged);
        this.webView.add_DocumentTitleChanged(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleNewWindowRequested);
        this.webView.add_NewWindowRequested(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleSourceChanged);
        this.webView.add_SourceChanged(handler, token);
        handler.Release();
        handler = Edge.newCallback(this::handleMoveFocusRequested);
        this.controller.add_MoveFocusRequested(handler, token);
        handler.Release();
        if (this.webView2 != null) {
            handler = Edge.newCallback(this::handleDOMContentLoaded);
            this.webView2.add_DOMContentLoaded(handler, token);
            handler.Release();
        }
        IUnknown hostDisp = this.newHostObject(this::handleCallJava);
        long[] lArray = new long[3];
        lArray[0] = 9L;
        lArray[1] = hostDisp.getAddress();
        long[] hostObj = lArray;
        this.webView.AddHostObjectToScript("swt\u0000".toCharArray(), hostObj);
        hostDisp.Release();
        this.browser.addListener(12, this::browserDispose);
        this.browser.addListener(15, this::browserFocusIn);
        this.browser.addListener(11, this::browserResize);
        this.browser.addListener(10, this::browserMove);
    }

    void browserDispose(Event event) {
        if (this.webView2 != null) {
            this.webView2.Release();
        }
        if (this.environment2 != null) {
            this.environment2.Release();
        }
        this.settings.Release();
        this.webView.Release();
        this.webView2 = null;
        this.environment2 = null;
        this.settings = null;
        this.webView = null;
        if (inCallback) {
            ICoreWebView2Controller controller1 = this.controller;
            this.controller.put_IsVisible(false);
            this.browser.getDisplay().asyncExec(() -> {
                controller1.Close();
                controller1.Release();
            });
        } else {
            this.controller.Close();
            this.controller.Release();
        }
        this.controller = null;
    }

    void browserFocusIn(Event event) {
        this.controller.MoveFocus(0);
    }

    void browserMove(Event event) {
        this.controller.NotifyParentWindowPositionChanged();
    }

    void browserResize(Event event) {
        RECT rect = new RECT();
        OS.GetClientRect(this.browser.handle, rect);
        this.controller.put_Bounds(rect);
        this.controller.put_IsVisible(true);
    }

    @Override
    public Object evaluate(String script) throws SWTException {
        Object data;
        this.checkDeadlock();
        if (!this.jsEnabled) {
            return null;
        }
        int[] pResult = new int[1];
        String[] pJson = new String[1];
        IUnknown completion = Edge.newCallback((result, pszJson) -> {
            nArray[0] = (int)result;
            if ((int)result == 0) {
                stringArray[0] = Edge.wstrToString(pszJson, false);
            }
            return 0;
        });
        script = "(function() {try { " + script + " } catch (e) { return '" + "org.eclipse.swt.browser.error" + "' + e.message; } })();\u0000";
        pResult[0] = this.webView.ExecuteScript(script.toCharArray(), completion);
        completion.Release();
        Display display = this.browser.getDisplay();
        while (pResult[0] == 0 && pJson[0] == null) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (pResult[0] != 0) {
            Edge.error(50, pResult[0]);
        }
        if ((data = JSON.parse(pJson[0])) instanceof String && ((String)data).startsWith("org.eclipse.swt.browser.error")) {
            String errorMessage = ((String)data).substring("org.eclipse.swt.browser.error".length());
            throw new SWTException(50, errorMessage);
        }
        return data;
    }

    @Override
    public boolean execute(String script) {
        if (!this.jsEnabled) {
            return false;
        }
        IUnknown completion = Edge.newCallback((result, json) -> 0);
        int hr = this.webView.ExecuteScript((String.valueOf(script) + "\u0000").toCharArray(), completion);
        completion.Release();
        return hr == 0;
    }

    @Override
    public String getBrowserType() {
        return "edge";
    }

    @Override
    String getJavaCallDeclaration() {
        return "if (!window.callJava) { window.callJava = function(index, token, args) {\nreturn JSON.parse(window.chrome.webview.hostObjects.sync.swt.CallJava(index, token, JSON.stringify(args)));\n}};\n";
    }

    @Override
    public String getText() {
        return (String)this.evaluate("return document.documentElement.outerHTML;");
    }

    @Override
    public String getUrl() {
        long[] ppsz = new long[1];
        this.webView.get_Source(ppsz);
        return Edge.wstrToString(ppsz[0], true);
    }

    int handleCloseRequested(long pView, long pArgs) {
        this.browser.getDisplay().asyncExec(() -> {
            if (this.browser.isDisposed()) {
                return;
            }
            WindowEvent event = new WindowEvent(this.browser);
            event.display = this.browser.getDisplay();
            event.widget = this.browser;
            CloseWindowListener[] closeWindowListenerArray = this.closeWindowListeners;
            int n = this.closeWindowListeners.length;
            int n2 = 0;
            while (n2 < n) {
                CloseWindowListener listener = closeWindowListenerArray[n2];
                listener.close(event);
                if (this.browser.isDisposed()) {
                    return;
                }
                ++n2;
            }
            this.browser.dispose();
        });
        return 0;
    }

    int handleDocumentTitleChanged(long pView, long pArgs) {
        long[] ppsz = new long[1];
        this.webView.get_DocumentTitle(ppsz);
        String title = Edge.wstrToString(ppsz[0], true);
        this.browser.getDisplay().asyncExec(() -> {
            if (this.browser.isDisposed()) {
                return;
            }
            TitleEvent event = new TitleEvent(this.browser);
            event.display = this.browser.getDisplay();
            event.widget = this.browser;
            event.title = title;
            TitleListener[] titleListenerArray = this.titleListeners;
            int n = this.titleListeners.length;
            int n2 = 0;
            while (n2 < n) {
                TitleListener listener = titleListenerArray[n2];
                listener.changed(event);
                if (this.browser.isDisposed()) {
                    return;
                }
                ++n2;
            }
        });
        return 0;
    }

    long handleCallJava(int index, long bstrToken, long bstrArgsJson) {
        Object result = null;
        String token = Edge.bstrToString(bstrToken);
        BrowserFunction function = (BrowserFunction)this.functions.get(index);
        if (function != null && token.equals(function.token)) {
            try {
                String argsJson = Edge.bstrToString(bstrArgsJson);
                Object[] args = (Object[])JSON.parse(argsJson.toCharArray());
                result = function.function(args);
            }
            catch (Throwable e) {
                result = WebBrowser.CreateErrorString(e.getLocalizedMessage());
            }
        }
        String json = JSON.stringify(result);
        return COM.SysAllocStringLen(json.toCharArray(), json.length());
    }

    int handleFrameNavigationStarting(long pView, long pArgs) {
        return this.handleNavigationStarting(pView, pArgs, false);
    }

    int handleNavigationStarting(long pView, long pArgs) {
        return this.handleNavigationStarting(pView, pArgs, true);
    }

    int handleNavigationStarting(long pView, long pArgs, boolean top) {
        ICoreWebView2NavigationStartingEventArgs args = new ICoreWebView2NavigationStartingEventArgs(pArgs);
        long[] ppszUrl = new long[1];
        int hr = args.get_Uri(ppszUrl);
        if (hr != 0) {
            return hr;
        }
        String url = Edge.wstrToString(ppszUrl[0], true);
        long[] pNavId = new long[1];
        args.get_NavigationId(pNavId);
        LocationEvent event = new LocationEvent(this.browser);
        event.display = this.browser.getDisplay();
        event.widget = this.browser;
        event.location = url;
        event.top = top;
        event.doit = true;
        LocationListener[] locationListenerArray = this.locationListeners;
        int n = this.locationListeners.length;
        int n2 = 0;
        while (n2 < n) {
            LocationListener listener = locationListenerArray[n2];
            listener.changing(event);
            if (this.browser.isDisposed()) {
                return 0;
            }
            ++n2;
        }
        if (event.doit) {
            this.navigations.put(pNavId[0], event);
            this.jsEnabled = this.jsEnabledOnNextPage;
            this.settings.put_IsScriptEnabled(this.jsEnabled);
            if (!this.functions.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                for (BrowserFunction function : this.functions.values()) {
                    sb.append(function.functionString);
                }
                this.execute(sb.toString());
            }
        } else {
            args.put_Cancel(true);
        }
        return 0;
    }

    int handleSourceChanged(long pView, long pArgs) {
        long[] ppsz = new long[1];
        int hr = this.webView.get_Source(ppsz);
        if (hr != 0) {
            return hr;
        }
        String url = Edge.wstrToString(ppsz[0], true);
        this.browser.getDisplay().asyncExec(() -> {
            if (this.browser.isDisposed()) {
                return;
            }
            LocationEvent event = new LocationEvent(this.browser);
            event.display = this.browser.getDisplay();
            event.widget = this.browser;
            event.location = url;
            event.top = true;
            LocationListener[] locationListenerArray = this.locationListeners;
            int n = this.locationListeners.length;
            int n2 = 0;
            while (n2 < n) {
                LocationListener listener = locationListenerArray[n2];
                listener.changed(event);
                if (this.browser.isDisposed()) {
                    return;
                }
                ++n2;
            }
        });
        return 0;
    }

    void sendProgressCompleted() {
        this.browser.getDisplay().asyncExec(() -> {
            if (this.browser.isDisposed()) {
                return;
            }
            ProgressEvent event = new ProgressEvent(this.browser);
            event.display = this.browser.getDisplay();
            event.widget = this.browser;
            ProgressListener[] progressListenerArray = this.progressListeners;
            int n = this.progressListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ProgressListener listener = progressListenerArray[n2];
                listener.completed(event);
                if (this.browser.isDisposed()) {
                    return;
                }
                ++n2;
            }
        });
    }

    int handleDOMContentLoaded(long pView, long pArgs) {
        ICoreWebView2DOMContentLoadedEventArgs args = new ICoreWebView2DOMContentLoadedEventArgs(pArgs);
        long[] pNavId = new long[1];
        args.get_NavigationId(pNavId);
        LocationEvent startEvent = this.navigations.get(pNavId[0]);
        if (startEvent != null && startEvent.top) {
            this.sendProgressCompleted();
        }
        return 0;
    }

    int handleNavigationCompleted(long pView, long pArgs) {
        return this.handleNavigationCompleted(pView, pArgs, true);
    }

    int handleFrameNavigationCompleted(long pView, long pArgs) {
        return this.handleNavigationCompleted(pView, pArgs, false);
    }

    int handleNavigationCompleted(long pView, long pArgs, boolean top) {
        ICoreWebView2NavigationCompletedEventArgs args = new ICoreWebView2NavigationCompletedEventArgs(pArgs);
        long[] pNavId = new long[1];
        args.get_NavigationId(pNavId);
        LocationEvent startEvent = this.navigations.remove(pNavId[0]);
        if (this.webView2 == null && startEvent != null && startEvent.top) {
            this.sendProgressCompleted();
        }
        return 0;
    }

    void updateWindowFeatures(ICoreWebView2NewWindowRequestedEventArgs args, WindowEvent event) {
        long[] ppv = new long[1];
        int hr = args.get_WindowFeatures(ppv);
        if (hr != 0) {
            return;
        }
        ICoreWebView2WindowFeatures features = new ICoreWebView2WindowFeatures(ppv[0]);
        int[] px = new int[1];
        int[] py = new int[1];
        features.get_HasPosition(px);
        if (px[0] != 0) {
            features.get_Left(px);
            features.get_Top(py);
            event.location = new Point(px[0], py[0]);
        }
        features.get_HasSize(px);
        if (px[0] != 0) {
            features.get_Width(px);
            features.get_Height(py);
            event.size = new Point(px[0], py[0]);
        }
        features.get_ShouldDisplayMenuBar(px);
        event.menuBar = px[0] != 0;
        features.get_ShouldDisplayStatus(px);
        event.statusBar = px[0] != 0;
        features.get_ShouldDisplayToolbar(px);
        event.toolBar = px[0] != 0;
    }

    int handleNewWindowRequested(long pView, long pArgs) {
        ICoreWebView2NewWindowRequestedEventArgs args = new ICoreWebView2NewWindowRequestedEventArgs(pArgs);
        args.AddRef();
        long[] ppv = new long[1];
        args.GetDeferral(ppv);
        ICoreWebView2Deferral deferral = new ICoreWebView2Deferral(ppv[0]);
        this.inNewWindow = true;
        this.browser.getDisplay().asyncExec(() -> {
            try {
                if (this.browser.isDisposed()) {
                    return;
                }
                WindowEvent openEvent = new WindowEvent(this.browser);
                openEvent.display = this.browser.getDisplay();
                openEvent.widget = this.browser;
                openEvent.required = false;
                OpenWindowListener[] openWindowListenerArray = this.openWindowListeners;
                int n = this.openWindowListeners.length;
                int n2 = 0;
                while (n2 < n) {
                    OpenWindowListener openListener = openWindowListenerArray[n2];
                    openListener.open(openEvent);
                    if (this.browser.isDisposed()) {
                        return;
                    }
                    ++n2;
                }
                if (openEvent.browser != null && !openEvent.browser.isDisposed()) {
                    WebBrowser other = openEvent.browser.webBrowser;
                    args.put_Handled(true);
                    if (other instanceof Edge) {
                        args.put_NewWindow(((Edge)other).webView.getAddress());
                        WindowEvent showEvent = new WindowEvent(other.browser);
                        showEvent.display = this.browser.getDisplay();
                        showEvent.widget = other.browser;
                        this.updateWindowFeatures(args, showEvent);
                        VisibilityWindowListener[] visibilityWindowListenerArray = other.visibilityWindowListeners;
                        int n3 = other.visibilityWindowListeners.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            VisibilityWindowListener showListener = visibilityWindowListenerArray[n4];
                            showListener.show(showEvent);
                            if (other.browser.isDisposed()) {
                                return;
                            }
                            ++n4;
                        }
                    }
                } else if (openEvent.required) {
                    args.put_Handled(true);
                }
            }
            finally {
                deferral.Complete();
                deferral.Release();
                args.Release();
                this.inNewWindow = false;
            }
        });
        return 0;
    }

    int handleMoveFocusRequested(long pView, long pArgs) {
        ICoreWebView2MoveFocusRequestedEventArgs args = new ICoreWebView2MoveFocusRequestedEventArgs(pArgs);
        int[] pReason = new int[1];
        args.get_Reason(pReason);
        args.put_Handled(true);
        switch (pReason[0]) {
            case 1: {
                this.browser.traverse(16);
                break;
            }
            case 2: {
                this.browser.traverse(8);
            }
        }
        return 0;
    }

    @Override
    public boolean isBackEnabled() {
        int[] pval = new int[1];
        this.webView.get_CanGoBack(pval);
        return pval[0] != 0;
    }

    @Override
    public boolean isForwardEnabled() {
        int[] pval = new int[1];
        this.webView.get_CanGoBack(pval);
        return pval[0] != 0;
    }

    @Override
    public boolean back() {
        return this.isBackEnabled() && this.webView.GoBack() == 0;
    }

    @Override
    public boolean forward() {
        return this.isForwardEnabled() && this.webView.GoForward() == 0;
    }

    @Override
    public void refresh() {
        this.webView.Reload();
    }

    @Override
    public void stop() {
        this.webView.Stop();
    }

    @Override
    public boolean setText(String html, boolean trusted) {
        char[] data = new char[html.length() + 1];
        html.getChars(0, html.length(), data, 0);
        return this.webView.NavigateToString(data) == 0;
    }

    @Override
    public boolean setUrl(String url, String postData, String[] headers) {
        int hr;
        if (!url.matches("[a-z][a-z0-9+.-]*:.*")) {
            url = "http://" + url;
        }
        char[] pszUrl = (String.valueOf(url) + "\u0000").toCharArray();
        if (postData != null || headers != null) {
            if (this.environment2 == null || this.webView2 == null) {
                SWT.error(20, null, " [WebView2 version 88+ is required to set postData and headers]");
            }
            long[] ppRequest = new long[1];
            char[] pszMethod = null;
            char[] pszHeaders = null;
            IUnknown stream = null;
            if (postData != null) {
                pszMethod = "POST\u0000".toCharArray();
                byte[] postDataBytes = postData.getBytes(StandardCharsets.UTF_8);
                long pStream = COM.SHCreateMemStream(postDataBytes, postData.length());
                if (pStream == 0L) {
                    Edge.error(2, -2147024882);
                }
                stream = new IStream(pStream);
            } else {
                pszMethod = "GET\u0000".toCharArray();
            }
            if (headers != null) {
                String hblock = String.join((CharSequence)"\r\n", Arrays.asList(headers));
                pszHeaders = new char[hblock.length() + 1];
                hblock.getChars(0, hblock.length(), pszHeaders, 0);
            }
            hr = this.environment2.CreateWebResourceRequest(pszUrl, pszMethod, (IStream)stream, pszHeaders, ppRequest);
            if (stream != null) {
                stream.Release();
            }
            if (hr != 0) {
                Edge.error(2, hr);
            }
            IUnknown request = new IUnknown(ppRequest[0]);
            hr = this.webView2.NavigateWithWebResourceRequest(request);
            request.Release();
        } else {
            hr = this.webView.Navigate(pszUrl);
        }
        return hr == 0;
    }
}

