/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.modules.AbstractAlarmSensor;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class TemperatureAlarm
extends AbstractAlarmSensor {
    private IntegerDataPoint temperature;
    private IntegerDataPoint temperatureThreshhold;

    public TemperatureAlarm(String name, Domain domain, BooleanDataPoint alarm) {
        super(name, domain, alarm, ModuleType.temperatureAlarm, "The detection of abnormal temperature.");
    }

    public TemperatureAlarm(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (BooleanDataPoint)dps.get(DatapointType.alarm.getShortName()));
        IntegerDataPoint temperatureThreshhold = (IntegerDataPoint)dps.get(DatapointType.temperatureThreshhold.getShortName());
        if (temperatureThreshhold != null) {
            this.setTemperatureThreshhold(temperatureThreshhold);
        }
    }

    public void setTemperature(IntegerDataPoint dp) {
        this.temperature = dp;
        this.temperature.setOptional(true);
        this.temperature.setWritable(false);
        this.temperature.setDoc("To report the value of the temperature; the common unit is \u00baC");
        this.addDataPoint((DataPoint)this.temperature);
    }

    public int getTemperature() throws DataPointException, AccessException {
        if (this.temperature == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.temperature.getValue();
    }

    public void setTemperatureThreshhold(IntegerDataPoint dp) {
        this.temperatureThreshhold = dp;
        this.temperatureThreshhold.setOptional(true);
        this.temperatureThreshhold.setDoc("The threshhold to trigger the alarm.");
        this.addDataPoint((DataPoint)this.temperatureThreshhold);
    }

    public int getTemperatureThreshhold() throws DataPointException, AccessException {
        if (this.temperatureThreshhold == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.temperatureThreshhold.getValue();
    }

    public void setTemperatureThreshhold(int v) throws DataPointException, AccessException {
        if (this.temperatureThreshhold == null) {
            throw new DataPointException("Not implemented");
        }
        this.temperatureThreshhold.setValue((Object)v);
    }
}

