/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.NotPermittedAttrException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.persistence.service.DAO;

public class ContainerController
extends Controller {
    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        Patterns patterns = new Patterns();
        DAO<?> dao = patterns.getDAO(request.getTo(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTo());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        List acpsToCheck = null;
        List childContainers = null;
        List subscriptions = null;
        if (parentEntity.getResourceType().intValue() == 5) {
            CSEBaseEntity cseB = (CSEBaseEntity)parentEntity;
            acpsToCheck = cseB.getAccessControlPolicies();
            childContainers = cseB.getChildContainers();
            subscriptions = cseB.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 2) {
            AeEntity ae = (AeEntity)parentEntity;
            acpsToCheck = ae.getAccessControlPolicies();
            childContainers = ae.getChildContainers();
            subscriptions = ae.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 3) {
            ContainerEntity parentContainer = (ContainerEntity)parentEntity;
            acpsToCheck = parentContainer.getAccessControlPolicies();
            childContainers = parentContainer.getChildContainers();
            subscriptions = parentContainer.getSubscriptions();
        }
        if (parentEntity.getResourceType().intValue() == 16) {
            RemoteCSEEntity csr = (RemoteCSEEntity)parentEntity;
            acpsToCheck = csr.getAccessControlPolicies();
            childContainers = csr.getChildCnt();
            subscriptions = csr.getSubscriptions();
        }
        this.checkACP(acpsToCheck, request.getFrom(), Operation.CREATE);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for Container creation");
        }
        Container container = null;
        try {
            container = request.getRequestContentType().equals("application/obj") ? (Container)request.getContent() : (Container)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            LOGGER.debug((Object)"ClassCastException: Incorrect resource type in object conversion.", (Throwable)e);
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (container == null) {
            throw new BadRequestException("Error in provided content");
        }
        ContainerEntity containerEntity = new ContainerEntity();
        ControllerUtil.CreateUtil.fillEntityFromAnnounceableResource((AnnounceableResource)container, (AnnounceableSubordinateEntity)containerEntity);
        if (container.getCreator() != null) {
            containerEntity.setCreator(container.getCreator());
        }
        if (container.getCurrentNrOfInstances() != null) {
            throw new NotPermittedAttrException("Current number of instances is Not Permitted");
        }
        if (container.getCurrentByteSize() != null) {
            throw new NotPermittedAttrException("Current byte size is Not Permitted");
        }
        String generatedId = ContainerController.generateId("", "");
        if (container.getName() != null) {
            if (!patterns.checkResourceName(container.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:" + patterns.ID_STRING);
            }
            containerEntity.setName(container.getName());
        } else {
            containerEntity.setName("cnt_" + generatedId);
        }
        containerEntity.setResourceID("/" + Constants.CSE_ID + "/" + "cnt" + Constants.PREFIX_SEPERATOR + generatedId);
        containerEntity.setHierarchicalURI(String.valueOf(parentEntity.getHierarchicalURI()) + "/" + containerEntity.getName());
        containerEntity.setParentID(parentEntity.getResourceID());
        containerEntity.setResourceType(3);
        containerEntity.setCurrentNrOfInstances(BigInteger.valueOf(0L));
        if (!container.getAccessControlPolicyIDs().isEmpty()) {
            containerEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(container.getAccessControlPolicyIDs(), this.transaction));
        } else {
            containerEntity.getAccessControlPolicies().addAll(acpsToCheck);
        }
        if (!UriMapper.addNewUri(containerEntity.getHierarchicalURI(), containerEntity.getResourceID(), 3)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        if (container.getOntologyRef() != null) {
            containerEntity.setOntologyRef(container.getOntologyRef());
        }
        if (container.getMaxNrOfInstances() != null) {
            containerEntity.setMaxNrOfInstances(container.getMaxNrOfInstances());
        } else {
            containerEntity.setMaxNrOfInstances(Constants.MAX_NBR_OF_INSTANCES);
        }
        if (container.getMaxByteSize() != null) {
            containerEntity.setMaxByteSize(container.getMaxByteSize());
        } else {
            containerEntity.setMaxByteSize(Constants.MAX_BYTE_SIZE);
        }
        if (container.getMaxInstanceAge() != null) {
            containerEntity.setMaxInstanceAge(container.getMaxInstanceAge());
        } else {
            containerEntity.setMaxInstanceAge(BigInteger.valueOf(0L));
        }
        if (container.getLocationID() != null) {
            containerEntity.setLocationID(container.getLocationID());
        }
        containerEntity.setStateTag(BigInteger.valueOf(0L));
        this.dbs.getDAOFactory().getContainerDAO().create(this.transaction, (Object)containerEntity);
        ContainerEntity containerFromDB = (ContainerEntity)this.dbs.getDAOFactory().getContainerDAO().find(this.transaction, (Object)containerEntity.getResourceID());
        childContainers.add(containerFromDB);
        dao.update(this.transaction, (Object)parentEntity);
        this.transaction.commit();
        Notifier.notify(subscriptions, (ResourceEntity)containerFromDB, 1);
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)containerFromDB);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        ContainerEntity containerEntity = (ContainerEntity)this.dbs.getDAOFactory().getContainerDAO().find(this.transaction, (Object)request.getTo());
        if (containerEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        List acpList = containerEntity.getAccessControlPolicies();
        this.checkACP(acpList, request.getFrom(), request.getOperation());
        Container containerResource = EntityMapperFactory.getContainerMapper().mapEntityToResource(containerEntity, request);
        response.setContent((Object)containerResource);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        ContainerEntity containerEntity = (ContainerEntity)this.dbs.getDAOFactory().getContainerDAO().find(this.transaction, (Object)request.getTo());
        if (containerEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.checkACP(containerEntity.getAccessControlPolicies(), request.getFrom(), Operation.UPDATE);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for Container update");
        }
        Container container = null;
        try {
            container = request.getRequestContentType().equals("application/obj") ? (Container)request.getContent() : (Container)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
        }
        catch (ClassCastException e) {
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (container == null) {
            throw new BadRequestException("Error in provided content");
        }
        ControllerUtil.UpdateUtil.checkNotPermittedParameters((Resource)container);
        if (container.getCurrentNrOfInstances() != null) {
            throw new BadRequestException("CurrentNrOfInstances is NP");
        }
        if (container.getCurrentByteSize() != null) {
            throw new BadRequestException("CurrentByteSize is NP");
        }
        Container modifiedAttributes = new Container();
        if (!container.getAccessControlPolicyIDs().isEmpty()) {
            for (AccessControlPolicyEntity acpe : containerEntity.getAccessControlPolicies()) {
                this.checkSelfACP(acpe, request.getFrom(), Operation.UPDATE);
            }
            containerEntity.getAccessControlPolicies().clear();
            containerEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(container.getAccessControlPolicyIDs(), this.transaction));
            modifiedAttributes.getAccessControlPolicyIDs().addAll(container.getAccessControlPolicyIDs());
        }
        if (!container.getLabels().isEmpty()) {
            containerEntity.setLabelsEntitiesFromSring(container.getLabels());
            modifiedAttributes.getLabels().addAll(container.getLabels());
        }
        if (container.getExpirationTime() != null) {
            containerEntity.setExpirationTime(container.getExpirationTime());
            modifiedAttributes.setExpirationTime(container.getExpirationTime());
        }
        if (!container.getAnnounceTo().isEmpty()) {
            containerEntity.getAnnounceTo().clear();
            containerEntity.getAnnounceTo().addAll(container.getAnnounceTo());
            modifiedAttributes.getAnnounceTo().addAll(container.getAnnounceTo());
        }
        if (!container.getAnnouncedAttribute().isEmpty()) {
            containerEntity.getAnnouncedAttribute().clear();
            containerEntity.getAnnouncedAttribute().addAll(container.getAnnouncedAttribute());
            modifiedAttributes.getAnnouncedAttribute().addAll(container.getAnnouncedAttribute());
        }
        if (container.getMaxNrOfInstances() != null) {
            containerEntity.setMaxNrOfInstances(container.getMaxNrOfInstances());
            modifiedAttributes.setMaxNrOfInstances(container.getMaxNrOfInstances());
        }
        if (container.getMaxByteSize() != null) {
            containerEntity.setMaxByteSize(container.getMaxByteSize());
            modifiedAttributes.setMaxByteSize(container.getMaxByteSize());
        }
        if (container.getMaxInstanceAge() != null) {
            containerEntity.setMaxInstanceAge(container.getMaxInstanceAge());
            modifiedAttributes.setMaxInstanceAge(container.getMaxInstanceAge());
        }
        if (container.getLocationID() != null) {
            containerEntity.setLocationID(container.getLocationID());
            modifiedAttributes.setLocationID(container.getLocationID());
        }
        if (container.getOntologyRef() != null) {
            containerEntity.setOntologyRef(container.getOntologyRef());
            modifiedAttributes.setOntologyRef(container.getOntologyRef());
        }
        if (containerEntity.getStateTag() != null) {
            containerEntity.setStateTag(BigInteger.valueOf(containerEntity.getStateTag().intValue() + 1));
            modifiedAttributes.setStateTag(containerEntity.getStateTag());
        }
        containerEntity.setLastModifiedTime(Util.DateUtil.now());
        modifiedAttributes.setLastModifiedTime(containerEntity.getLastModifiedTime());
        response.setContent((Object)modifiedAttributes);
        this.dbs.getDAOFactory().getContainerDAO().update(this.transaction, (Object)containerEntity);
        this.transaction.commit();
        Notifier.notify(containerEntity.getSubscriptions(), (ResourceEntity)containerEntity, 3);
        response.setResponseStatusCode(ResponseStatusCode.UPDATED);
        return response;
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        ContainerEntity containerEntity = (ContainerEntity)this.dbs.getDAOFactory().getContainerDAO().find(this.transaction, (Object)request.getTo());
        if (containerEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.checkACP(containerEntity.getAccessControlPolicies(), request.getFrom(), Operation.DELETE);
        UriMapper.deleteUri(containerEntity.getHierarchicalURI());
        Notifier.notifyDeletion(containerEntity.getSubscriptions(), (ResourceEntity)containerEntity);
        this.dbs.getDAOFactory().getContainerDAO().delete(this.transaction, (Object)containerEntity);
        this.transaction.commit();
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

