/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.AccessControl;
import org.eclipse.om2m.commons.entities.AccessControlContextEntity;
import org.eclipse.om2m.commons.entities.AccessControlOriginatorEntity;
import org.eclipse.om2m.commons.entities.AccessControlRuleEntity;
import org.eclipse.om2m.commons.resource.AccessControlRule;
import org.eclipse.om2m.commons.resource.SetOfAcrs;

public class AcpUtils {
    private AcpUtils() {
    }

    public static SetOfAcrs getSetOfArcsFromACRE(List<AccessControlRuleEntity> ruleEntities) {
        SetOfAcrs result = new SetOfAcrs();
        for (AccessControlRuleEntity ruleEntity : ruleEntities) {
            AccessControlRule rule = new AccessControlRule();
            rule.setAccessControlOperations(AccessControl.getOperationFromACR(ruleEntity));
            for (AccessControlOriginatorEntity originatorEntity : ruleEntity.getAccessControlOriginators()) {
                rule.getAccessControlOriginators().add(originatorEntity.getOriginatorID());
            }
            for (AccessControlContextEntity contextEntity : ruleEntity.getAccessControlContexts()) {
                AccessControlRule.AccessControlContexts context = new AccessControlRule.AccessControlContexts();
                context.getAccessControlWindow().addAll(contextEntity.getAccessControlWindow());
                AccessControlRule.AccessControlContexts.AccessControlIpAddresses addresses = new AccessControlRule.AccessControlContexts.AccessControlIpAddresses();
                addresses.getIpv4Addresses().addAll(contextEntity.getIpv4Addresses());
                addresses.getIpv6Addresses().addAll(contextEntity.getIpv6Addresses());
                context.setAccessControlIpAddresses(addresses);
                context.setAccessControlLocationRegion(contextEntity.getAccessControlLocationRegion());
                rule.getAccessControlContexts().add(context);
            }
            result.getAccessControlRule().add(rule);
        }
        return result;
    }

    public static List<AccessControlRuleEntity> getACREntityFromSetOfArcs(SetOfAcrs setOfAcrs) {
        ArrayList<AccessControlRuleEntity> result = new ArrayList<AccessControlRuleEntity>();
        for (AccessControlRule rule : setOfAcrs.getAccessControlRule()) {
            AccessControlRuleEntity ruleEntity = AccessControl.getARCFromOperation(rule.getAccessControlOperations());
            for (AccessControlRule.AccessControlContexts context : rule.getAccessControlContexts()) {
                AccessControlContextEntity contextEntity = new AccessControlContextEntity();
                contextEntity.getIpv4Addresses().addAll(context.getAccessControlIpAddresses().getIpv4Addresses());
                contextEntity.getIpv6Addresses().addAll(context.getAccessControlIpAddresses().getIpv6Addresses());
                contextEntity.setAccessControlLocationRegion(context.getAccessControlLocationRegion());
                contextEntity.getAccessControlWindow().addAll(context.getAccessControlWindow());
                ruleEntity.getAccessControlContexts().add(contextEntity);
            }
            for (String originator : rule.getAccessControlOriginators()) {
                String[] stringArray = originator.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String splitted = stringArray[n2];
                    AccessControlOriginatorEntity originatorEntity = new AccessControlOriginatorEntity(splitted);
                    ruleEntity.getAccessControlOriginators().add(originatorEntity);
                    ++n2;
                }
            }
            result.add(ruleEntity);
        }
        return result;
    }
}

