/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.MappedSuperclass;
import org.eclipse.om2m.commons.constants.MgmtDefinitionTypes;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoEntity;
import org.eclipse.om2m.commons.entities.DeviceInfoEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.resource.MgmtObj;

@MappedSuperclass
public abstract class MgmtObjEntity
extends AnnounceableSubordinateEntity {
    @Column(name="mgd")
    protected BigInteger mgmtDefinition;
    @Column(name="obis")
    protected List<String> objectIDs;
    @Column(name="obps")
    protected List<String> objectPaths;
    @Column(name="dc")
    protected String description;

    public BigInteger getMgmtDefinition() {
        return this.mgmtDefinition;
    }

    public List<String> getObjectIDs() {
        if (this.objectIDs == null) {
            this.objectIDs = new ArrayList<String>();
        }
        return this.objectIDs;
    }

    public void setObjectIDs(List<String> objectIDs) {
        this.objectIDs = objectIDs;
    }

    public List<String> getObjectPaths() {
        if (this.objectPaths == null) {
            this.objectPaths = new ArrayList<String>();
        }
        return this.objectPaths;
    }

    public void setObjectPaths(List<String> objectPaths) {
        this.objectPaths = objectPaths;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMgmtDefinition(BigInteger mgmtDefinition) {
        this.mgmtDefinition = mgmtDefinition;
    }

    public void fillFrom(MgmtObj mgmtObj) {
        this.mgmtDefinition = mgmtObj.getMgmtDefinition();
        this.description = mgmtObj.getDescription();
        this.objectIDs = mgmtObj.getObjectIDs();
        this.objectPaths = mgmtObj.getObjectPaths();
    }

    public static MgmtObjEntity create(BigInteger mgmtDef) {
        if (mgmtDef.equals(MgmtDefinitionTypes.AREA_NWK_INFO)) {
            return new AreaNwkInfoEntity();
        }
        if (mgmtDef.equals(MgmtDefinitionTypes.AREA_NWK_DEVICE_INFO)) {
            return new AreaNwkDeviceInfoEntity();
        }
        if (mgmtDef.equals(MgmtDefinitionTypes.DEVICE_INFO)) {
            return new DeviceInfoEntity();
        }
        throw new BadRequestException("Not implemented");
    }

    public abstract NodeEntity getParentNode();

    public abstract void setParentNode(NodeEntity var1);

    @Override
    public abstract List<AccessControlPolicyEntity> getAccessControlPolicies();

    public abstract List<SubscriptionEntity> getSubscriptions();
}

