/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.mongodb.dao;

import com.mongodb.client.model.Filters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.ContentInstanceEntity;
import org.eclipse.om2m.persistence.mongodb.DAOImpl;
import org.eclipse.om2m.persistence.mongodb.DBServiceImpl;
import org.eclipse.om2m.persistence.mongodb.DBTransactionImpl;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class ContentInstanceDAO
extends DAOImpl<ContentInstanceEntity>
implements DAO<ContentInstanceEntity> {
    private static final Log LOGGER = LogFactory.getLog(ContentInstanceDAO.class);
    private boolean oldest;
    private DAO<ContainerEntity> ctrDAO;

    public ContentInstanceDAO(boolean oldest) {
        super(ContentInstanceEntity.class);
        this.oldest = oldest;
        this.ctrDAO = DBServiceImpl.getInstance().getDAOFactory().getContainerDAO();
    }

    @Override
    public void create(DBTransaction dbTransaction, ContentInstanceEntity cin) {
        try {
            DBTransactionImpl dbTransactionImpl = (DBTransactionImpl)dbTransaction;
            String json = DBServiceImpl.getInstance().getGson().toJson((Object)cin);
            Document newOject = Document.parse((String)json);
            DBServiceImpl.getInstance().getResourceCollection().insertOne((Object)newOject);
            ContainerEntity parent = cin.getParentContainer();
            parent.getChildContentInstances().add(cin);
            this.ctrDAO.update((DBTransaction)dbTransactionImpl, (Object)parent);
        }
        catch (Exception e) {
            LOGGER.info((Object)("Error create " + cin), (Throwable)e);
        }
    }

    @Override
    public ContentInstanceEntity find(DBTransaction dbTransaction, Object id) {
        return this.oldest ? this.findOldest(dbTransaction, id) : this.findById(dbTransaction, id);
    }

    private ContentInstanceEntity findById(DBTransaction dbTransaction, Object id) {
        DBTransactionImpl dbTransactionImpl = (DBTransactionImpl)dbTransaction;
        Document doc = (Document)DBServiceImpl.getInstance().getResourceCollection().find(Filters.eq((String)"ResourceID", (Object)id)).first();
        if (doc == null) {
            return null;
        }
        ContentInstanceEntity cin = (ContentInstanceEntity)DBServiceImpl.getInstance().getGson().fromJson(doc.toJson(), ContentInstanceEntity.class);
        cin.setParentContainer((ContainerEntity)this.ctrDAO.find((DBTransaction)dbTransactionImpl, (Object)cin.getParentID()));
        return cin;
    }

    private ContentInstanceEntity findOldest(DBTransaction dbTransaction, Object id) {
        ContainerEntity parent = (ContainerEntity)this.ctrDAO.find(dbTransaction, id);
        LOGGER.info((Object)parent.getChildContentInstances());
        String old = "3333";
        ContentInstanceEntity ret = null;
        for (ContentInstanceEntity cin : parent.getChildContentInstances()) {
            if (old.compareTo(cin.getCreationTime()) <= 0) continue;
            old = cin.getCreationTime();
            ret = cin;
        }
        return this.findById(dbTransaction, ret.getResourceID());
    }

    @Override
    public void update(DBTransaction dbTransaction, ContentInstanceEntity resource) {
        try {
            DBTransactionImpl cfr_ignored_0 = (DBTransactionImpl)dbTransaction;
            Document doc = (Document)DBServiceImpl.getInstance().getResourceCollection().find(Filters.eq((String)"ResourceID", (Object)resource.getResourceID())).first();
            if (doc != null) {
                String json = DBServiceImpl.getInstance().getGson().toJson((Object)resource);
                Document newDoc = Document.parse((String)json);
                DBServiceImpl.getInstance().getResourceCollection().replaceOne(Filters.eq((String)"ResourceID", (Object)resource.getResourceID()), (Object)newDoc);
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)("Error update " + resource), (Throwable)e);
        }
    }

    @Override
    public void delete(DBTransaction dbTransaction, ContentInstanceEntity resource) {
        super.delete(dbTransaction, resource);
        ContainerEntity parent = resource.getParentContainer();
        parent.getChildContentInstances().remove(resource);
        this.ctrDAO.update(dbTransaction, (Object)parent);
    }
}

