/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.dacis;

import java.util.ArrayList;
import java.util.UUID;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;

public class AeDacisTest
extends Test {
    public AeDacisTest(CseService pCseService) {
        super("Ae Dacis", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation dac = this.createDAS();
        if (dac == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create DAC");
            return;
        }
        AE toBeCreatedAe = new AE();
        toBeCreatedAe.getDynamicAuthorizationConsultationIDs().add(dac.getResourceID());
        toBeCreatedAe.setAppID("App" + UUID.randomUUID());
        toBeCreatedAe.setRequestReachability(Boolean.FALSE);
        toBeCreatedAe.setName(toBeCreatedAe.getAppID());
        RequestPrimitive createRequest = new RequestPrimitive();
        createRequest.setOperation(Operation.CREATE);
        createRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        createRequest.setTo("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME);
        createRequest.setRequestContentType("application/obj");
        createRequest.setReturnContentType("application/obj");
        createRequest.setResourceType(2);
        createRequest.setContent((Object)toBeCreatedAe);
        ResponsePrimitive createResponse = this.getCseService().doRequest(createRequest);
        if (createResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("response is null");
            return;
        }
        if (!ResponseStatusCode.CREATED.equals(createResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create Ae: expecting " + ResponseStatusCode.CREATED + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        AE createdAe = null;
        try {
            createdAe = (AE)createResponse.getContent();
        }
        catch (ClassCastException classCastException) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a Ae");
            return;
        }
        if (!this.checkEquals(createdAe.getDynamicAuthorizationConsultationIDs(), toBeCreatedAe.getDynamicAuthorizationConsultationIDs(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        ResponsePrimitive retrieveResponse = this.retrieveEntity(createdAe.getResourceID());
        if (retrieveResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve Ae: expecting " + ResponseStatusCode.OK + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        AE retrievedAe = null;
        try {
            retrievedAe = (AE)retrieveResponse.getContent();
        }
        catch (ClassCastException classCastException) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a Ae");
            return;
        }
        if (!this.checkEquals(retrievedAe.getDynamicAuthorizationConsultationIDs(), toBeCreatedAe.getDynamicAuthorizationConsultationIDs(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        RequestPrimitive deleteDACRequest = new RequestPrimitive();
        deleteDACRequest.setOperation(Operation.DELETE);
        deleteDACRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        deleteDACRequest.setTo(dac.getResourceID());
        if (!ResponseStatusCode.DELETED.equals(this.getCseService().doRequest(deleteDACRequest).getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to delete DAC");
            return;
        }
        retrieveResponse = this.retrieveEntity(createdAe.getResourceID());
        if (retrieveResponse == null) {
            this.setState(Test.State.KO);
            this.setMessage("retrieveResponse is null");
            return;
        }
        if (!ResponseStatusCode.OK.equals(retrieveResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("unable to retrieve Ae: expecting " + ResponseStatusCode.OK + ", found " + createResponse.getResponseStatusCode());
            return;
        }
        retrievedAe = null;
        try {
            retrievedAe = (AE)retrieveResponse.getContent();
        }
        catch (ClassCastException classCastException) {
            this.setState(Test.State.KO);
            this.setMessage("expected response content is not a Ae");
            return;
        }
        if (!this.checkEquals(retrievedAe.getDynamicAuthorizationConsultationIDs(), new ArrayList(), "dynamicAuthorizationConsultationIDs")) {
            return;
        }
        this.setState(Test.State.OK);
    }
}

