/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.das.testsuite.crud;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.das.testsuite.Test;

public class DeleteDASTest
extends Test {
    public DeleteDASTest(CseService pCseService) {
        super("Delete DAS", pCseService);
    }

    @Override
    public void performTest() {
        DynamicAuthorizationConsultation createdDas = this.createDAS();
        if (createdDas == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create a DAS");
            return;
        }
        if (!this.deleteDas(createdDas.getResourceID())) {
            return;
        }
        createdDas = this.createDAS();
        if (createdDas == null) {
            this.setState(Test.State.KO);
            this.setMessage("unable to create a DAS");
            return;
        }
        if (!this.deleteDas("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + createdDas.getName())) {
            return;
        }
        this.setState(Test.State.OK);
    }

    private boolean deleteDas(String dasUrl) {
        ResponsePrimitive retrievedResponse;
        RequestPrimitive requestPrimitive = new RequestPrimitive();
        requestPrimitive.setOperation(Operation.DELETE);
        requestPrimitive.setTo(dasUrl);
        requestPrimitive.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        ResponsePrimitive response = this.getCseService().doRequest(requestPrimitive);
        if (response != null) {
            if (!ResponseStatusCode.DELETED.equals(response.getResponseStatusCode())) {
                this.setState(Test.State.KO);
                this.setMessage("expecting " + ResponseStatusCode.UPDATED + " status code, found " + response.getResponseStatusCode());
                return false;
            }
            if (!this.checkNull(response.getContent(), "content")) {
                return false;
            }
        } else {
            this.setState(Test.State.KO);
            this.setMessage("no response");
        }
        if ((retrievedResponse = this.retrieveEntity(dasUrl)) == null) {
            this.setState(Test.State.KO);
            this.setMessage("no response");
            return false;
        }
        if (!ResponseStatusCode.NOT_FOUND.equals(retrievedResponse.getResponseStatusCode())) {
            this.setState(Test.State.KO);
            this.setMessage("resource must not exist");
            return false;
        }
        return true;
    }
}

