/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class EnergyGeneration
extends Module {
    private FloatDataPoint powerGenerationData;
    private IntegerDataPoint roundingEnergyGeneration;
    private IntegerDataPoint significantDigits;
    private IntegerDataPoint multiplyingFactors;

    public EnergyGeneration(String name, Domain domain) {
        super(name, domain, (Identifiers)ModuleType.energyGeneration);
    }

    public EnergyGeneration(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain);
        IntegerDataPoint multiplyingFactors;
        IntegerDataPoint significantDigits;
        IntegerDataPoint roundingEnergyGeneration;
        FloatDataPoint powerGenerationData = (FloatDataPoint)dps.get(DatapointType.powerGenerationData.getShortName());
        if (powerGenerationData != null) {
            this.setPowerGenerationData(powerGenerationData);
        }
        if ((roundingEnergyGeneration = (IntegerDataPoint)dps.get(DatapointType.roundingEnergyGeneration.getShortName())) != null) {
            this.setRoundingEnergyGeneration(roundingEnergyGeneration);
        }
        if ((significantDigits = (IntegerDataPoint)dps.get(DatapointType.significantDigits.getShortName())) != null) {
            this.setSignificantDigits(significantDigits);
        }
        if ((multiplyingFactors = (IntegerDataPoint)dps.get(DatapointType.multiplyingFactors.getShortName())) != null) {
            this.setMultiplyingFactors(multiplyingFactors);
        }
    }

    public float getPowerGenerationData() throws DataPointException, AccessException {
        return ((Float)this.powerGenerationData.getValue()).floatValue();
    }

    public void setPowerGenerationData(float b) throws DataPointException {
        throw new DataPointException("Not writable");
    }

    public void setPowerGenerationData(FloatDataPoint dp) {
        this.powerGenerationData = dp;
        this.powerGenerationData.setOptional(true);
        this.powerGenerationData.setWritable(false);
        this.powerGenerationData.setDoc("Amount of instaneous generation data.");
        this.addDataPoint((DataPoint)this.powerGenerationData);
    }

    public void setMultiplyingFactors(IntegerDataPoint dp) {
        this.multiplyingFactors = dp;
        this.multiplyingFactors.setOptional(true);
        this.multiplyingFactors.setWritable(true);
        this.multiplyingFactors.setDoc("The unit for data (multiplying factors) Ex. 1kWh, 0.1kWh, 0.01kWh etc.");
        this.addDataPoint((DataPoint)this.multiplyingFactors);
    }

    public Integer getMultiplyingFactors() throws DataPointException, AccessException {
        if (this.multiplyingFactors == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.multiplyingFactors.getValue();
    }

    public void setMultiplyingFactors(Integer i) throws DataPointException, AccessException {
        if (this.multiplyingFactors == null) {
            throw new DataPointException("Not implemented");
        }
        this.multiplyingFactors.setValue((Object)i);
    }

    public void setRoundingEnergyGeneration(IntegerDataPoint dp) {
        this.roundingEnergyGeneration = dp;
        this.roundingEnergyGeneration.setOptional(true);
        this.roundingEnergyGeneration.setWritable(false);
        this.roundingEnergyGeneration.setDoc("This energy generation data can be calculated by using significantFigures and units.");
        this.addDataPoint((DataPoint)this.roundingEnergyGeneration);
    }

    public int getRoundingEnergyGeneration() throws DataPointException, AccessException {
        if (this.roundingEnergyGeneration == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.roundingEnergyGeneration.getValue();
    }

    public void setRoundingEnergyGeneration(int b) throws DataPointException {
        throw new DataPointException("Not writable");
    }

    public void setSignificantDigits(IntegerDataPoint dp) {
        this.significantDigits = dp;
        this.significantDigits.setOptional(true);
        this.significantDigits.setWritable(true);
        this.significantDigits.setDoc("The number of effective digits for data.");
        this.addDataPoint((DataPoint)this.significantDigits);
    }

    public int getSignificantDigits() throws DataPointException, AccessException {
        if (this.significantDigits == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.significantDigits.getValue();
    }

    public void setSignificantDigits(int b) throws DataPointException, AccessException {
        if (this.significantDigits == null) {
            throw new DataPointException("Not implemented");
        }
        if (b < 0) {
            throw new DataPointException("Negative value");
        }
        this.significantDigits.setValue((Object)b);
    }
}

