/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;
import org.eclipse.om2m.sdt.home.types.TasteStrength;

public class Brewing
extends Module {
    private IntegerDataPoint cupsNumber;
    private TasteStrength strength;

    public Brewing(String name, Domain domain, IntegerDataPoint cupsNumber, TasteStrength strength) {
        super(name, domain, (Identifiers)ModuleType.brewing);
        if (cupsNumber == null || !cupsNumber.getShortName().equals(DatapointType.cupsNumber.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong cupsNumber datapoint: " + cupsNumber);
        }
        this.cupsNumber = cupsNumber;
        this.cupsNumber.setDoc("The current number of the cups requested to brew.");
        this.addDataPoint((DataPoint)this.cupsNumber);
        if (strength == null || !strength.getShortName().equals(DatapointType.strength.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong strength datapoint: " + (Object)((Object)strength));
        }
        this.strength = strength;
        this.strength.setDoc("The current strength of the drink taste. A higher value indicates a stronger taste.");
        this.addDataPoint((DataPoint)this.strength);
    }

    public Brewing(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (IntegerDataPoint)dps.get(DatapointType.cupsNumber.getShortName()), (TasteStrength)dps.get(DatapointType.strength.getShortName()));
    }

    public int getCupsNumber() throws DataPointException, AccessException {
        return (Integer)this.cupsNumber.getValue();
    }

    public void setCupsNumber(int v) throws DataPointException, AccessException {
        this.cupsNumber.setValue((Object)v);
    }

    public TasteStrength.Values getStrength() throws DataPointException, AccessException {
        return (TasteStrength.Values)((Object)this.strength.getValue());
    }

    public void setStrength(TasteStrength.Values v) throws DataPointException, AccessException {
        this.strength.setValue((Object)v);
    }
}

