/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt;

import org.eclipse.om2m.sdt.Element;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.types.SimpleType;

public class Property
extends Element {
    private final String shortName;
    private boolean optional = false;
    private String value;
    private SimpleType type = SimpleType.String;

    public Property(Identifiers name) {
        super(name.getLongName());
        this.shortName = name.getShortName();
    }

    public Property(Identifiers name, String value) {
        this(name);
        this.setValue(value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public SimpleType getType() {
        return this.type;
    }

    public void setType(SimpleType type) {
        this.type = type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    protected String prettyPrint(String t1) {
        return String.valueOf(t1) + "<Property name=\"" + this.name + "\" value=" + (this.value == null ? this.value : "\"" + this.value + "\"") + "\n" + t1 + "\t" + this.type + "\n" + t1 + "</Property>";
    }

    @Override
    public String toString() {
        return "<" + this.getClass().getSimpleName() + " \"" + this.name + "/" + this.shortName + "\"=" + (this.value == null ? this.value : "\"" + this.value + "\"") + "/>";
    }
}

