/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt;

import java.util.Dictionary;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.flexcontainer.service.FlexContainerService;
import org.eclipse.om2m.ipe.sdt.CseUtil;
import org.eclipse.om2m.ipe.sdt.DeviceList;
import org.eclipse.om2m.ipe.sdt.SDTIpeApplication;
import org.eclipse.om2m.sdt.Device;
import org.eclipse.om2m.sdt.Property;
import org.eclipse.om2m.sdt.events.SDTEventListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class Activator
implements EventHandler {
    private static final String CSE_ID_TO_BE_ANNOUNCED = "cse.id.to.be.announced";
    private static final String CSE_NAME_TO_BE_ANNOUNCED = "cse.name.to.be.announced";
    private static final String ANNOUNCEMENT_ENABLED = "announcement.enabled";
    private static final String IPE_UNDER_ANNOUNCED_RESOURCE = "ipe.under.announced.resource";
    private static final String PROP_PROTOCOL = "proPl";
    private static final String CLOUD_PROTOCOL = "Cloud.";
    private String cseIdToBeAnnounced;
    private String cseNameToBeAnnounced;
    private boolean ipeUnderAnnouncedResource;
    private boolean hasToBeAnnounced;
    private boolean isSDTIPEStarted = false;
    private SDTIpeApplication sdtIPEApplication;
    private static BundleContext bundleContext;
    private static Log logger;

    static {
        logger = LogFactory.getLog(Activator.class);
    }

    protected void activate(BundleContext pBundleContext, Map<String, Object> properties) {
        logger.info((Object)"activate SDT IPE");
        bundleContext = pBundleContext;
        if (this.checkConfigurations(properties)) {
            this.startSdtIpe();
        }
    }

    protected void deactivate(ComponentContext cc) {
        logger.info((Object)"deactivate SDT IPE");
        this.stopSdtIpe();
        bundleContext = null;
    }

    protected void modified(Map<String, Object> properties) {
        logger.info((Object)"Modified SDT IPE");
        this.checkConfigurations(properties);
    }

    protected void setCseService(CseService cseService) {
        logger.info((Object)"setCseService");
        CseUtil.cseService = cseService;
    }

    protected void unsetCseService(CseService pCseService) {
        logger.info((Object)"unsetCseService");
        CseUtil.cseService = null;
    }

    protected void setDevice(Device device) {
        logger.info((Object)("setDevice(" + device.getName() + ") " + device.getProperties()));
        Property protocol = device.getProperty(PROP_PROTOCOL, true);
        logger.info((Object)("Found device, protocol " + protocol));
        if (protocol != null && protocol.getValue().startsWith(CLOUD_PROTOCOL)) {
            logger.info((Object)"Cloud device, ignore...");
        } else {
            DeviceList.getInstance().addDevice(device);
        }
    }

    protected void unsetDevice(Device pDevice) {
        logger.info((Object)("unsetDevice(" + pDevice.getName() + ")"));
        DeviceList.getInstance().removeDevice(pDevice);
    }

    protected void registerSdtIpeApplication(String announceCseId, String cseName, boolean ipeUnder) throws Exception {
        if (this.sdtIPEApplication != null) {
            this.unregisterSdtIpeApplication();
        }
        this.sdtIPEApplication = new SDTIpeApplication(announceCseId, cseName, ipeUnder, this.hasToBeAnnounced);
        this.sdtIPEApplication.publishSDTIPEApplication();
        DeviceList.getInstance().addListenerAndSend(this.sdtIPEApplication);
    }

    protected void unregisterSdtIpeApplication() {
        if (this.sdtIPEApplication != null) {
            DeviceList.getInstance().removeListener(this.sdtIPEApplication);
            this.sdtIPEApplication.deleteIpeApplicationEntity();
            this.sdtIPEApplication = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSdtIpe() {
        Activator activator = this;
        synchronized (activator) {
            this.isSDTIPEStarted = true;
            if (this.checkIfRemoteCSEExists(this.cseIdToBeAnnounced, this.cseNameToBeAnnounced)) {
                try {
                    logger.info((Object)("Start IPE App " + this.cseIdToBeAnnounced + " / " + this.cseNameToBeAnnounced + " / " + this.ipeUnderAnnouncedResource));
                    this.registerSdtIpeApplication(this.cseIdToBeAnnounced, this.cseNameToBeAnnounced, this.ipeUnderAnnouncedResource);
                }
                catch (Exception e) {
                    logger.error((Object)"SdtIpeApplication oneM2M publishing failed", (Throwable)e);
                    this.stopSdtIpe();
                }
            } else {
                logger.error((Object)"Remote CSE not available");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSdtIpe() {
        Activator activator = this;
        synchronized (activator) {
            if (this.isSDTIPEStarted) {
                this.unregisterSdtIpeApplication();
            }
            this.isSDTIPEStarted = false;
        }
    }

    public static ServiceRegistration registerFlexContainerService(FlexContainerService instance) {
        logger.info((Object)("registerFlexContainerService for path " + instance.getFlexContainerLocation()));
        return bundleContext.registerService(FlexContainerService.class.getName(), (Object)instance, null);
    }

    public static ServiceRegistration registerSDTListener(SDTEventListener listener, Dictionary dictionary) {
        logger.info((Object)"registerSDTListener");
        return bundleContext.registerService(SDTEventListener.class.getName(), (Object)listener, dictionary);
    }

    private boolean checkConfigurations(Map<String, Object> properties) {
        boolean isValidConfiguration = false;
        if (properties != null) {
            String propCseIdToBeAnnounced = (String)properties.get(CSE_ID_TO_BE_ANNOUNCED);
            String propCseNameToBeAnnounced = (String)properties.get(CSE_NAME_TO_BE_ANNOUNCED);
            Boolean propAnnouncementEnabled = Boolean.parseBoolean((String)properties.get(ANNOUNCEMENT_ENABLED));
            Boolean propIpeUnderAnnouncedResource = Boolean.parseBoolean((String)properties.get(IPE_UNDER_ANNOUNCED_RESOURCE));
            logger.info((Object)("updated(cse.id.to.be.announced=" + propCseIdToBeAnnounced + ")\n" + "updated(" + CSE_NAME_TO_BE_ANNOUNCED + "=" + propCseNameToBeAnnounced + ")\n" + "updated(" + ANNOUNCEMENT_ENABLED + "=" + propAnnouncementEnabled + ")\n" + "updated(" + IPE_UNDER_ANNOUNCED_RESOURCE + "=" + propIpeUnderAnnouncedResource + ")"));
            if (propAnnouncementEnabled.booleanValue()) {
                if (propCseIdToBeAnnounced != null && propCseNameToBeAnnounced != null) {
                    isValidConfiguration = true;
                    this.hasToBeAnnounced = true;
                    this.cseIdToBeAnnounced = propCseIdToBeAnnounced;
                    this.cseNameToBeAnnounced = propCseNameToBeAnnounced;
                    this.ipeUnderAnnouncedResource = propIpeUnderAnnouncedResource == null ? false : propIpeUnderAnnouncedResource;
                } else {
                    logger.info((Object)"no REMOTE CSE where to announce resource but announcement.enabled=true");
                    isValidConfiguration = false;
                }
            } else if (propIpeUnderAnnouncedResource.booleanValue()) {
                if (propCseIdToBeAnnounced != null && propCseNameToBeAnnounced != null) {
                    isValidConfiguration = true;
                    this.hasToBeAnnounced = false;
                    this.cseIdToBeAnnounced = propCseIdToBeAnnounced;
                    this.cseNameToBeAnnounced = propCseNameToBeAnnounced;
                    this.ipeUnderAnnouncedResource = true;
                } else {
                    isValidConfiguration = false;
                    this.hasToBeAnnounced = false;
                    this.cseIdToBeAnnounced = null;
                    this.cseNameToBeAnnounced = null;
                    this.ipeUnderAnnouncedResource = false;
                    logger.info((Object)"no REMOTE CSE where ipe.under.announced.resource=true");
                }
            } else {
                isValidConfiguration = true;
                this.cseIdToBeAnnounced = null;
                this.cseNameToBeAnnounced = null;
                this.ipeUnderAnnouncedResource = false;
                this.hasToBeAnnounced = false;
            }
        } else {
            logger.info((Object)"No properties. Deactivate announcement");
            this.cseIdToBeAnnounced = null;
            this.cseNameToBeAnnounced = null;
            this.ipeUnderAnnouncedResource = false;
            this.hasToBeAnnounced = false;
            isValidConfiguration = true;
        }
        return isValidConfiguration;
    }

    private boolean checkIfRemoteCSEExists(String remoteCseId, String remoteCseName) {
        if (remoteCseId == null) {
            return true;
        }
        ResponsePrimitive response = null;
        int i = 0;
        while (i < 3) {
            response = CseUtil.sendRetrieveRequest("/" + remoteCseId + "/" + remoteCseName + "/" + Constants.CSE_NAME);
            if (ResponseStatusCode.OK.equals(response.getResponseStatusCode())) break;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return ResponseStatusCode.OK.equals(response.getResponseStatusCode());
    }

    public void handleEvent(Event event) {
        logger.info((Object)"handleEvent!!!!!!");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        String remoteCseId = (String)event.getProperty("remoteCseId");
        String remoteCseName = (String)event.getProperty("remoteCseName");
        String operationProperty = (String)event.getProperty("operation");
        if (remoteCseId == null || remoteCseName == null) {
            return;
        }
        if ("add".equals(operationProperty)) {
            if (remoteCseId.equals(this.cseIdToBeAnnounced) && remoteCseName.equals(this.cseNameToBeAnnounced)) {
                this.startSdtIpe();
            }
        } else if ("remove".equals(operationProperty) && remoteCseId.equals(this.cseIdToBeAnnounced) && remoteCseName.equals(this.cseNameToBeAnnounced)) {
            this.stopSdtIpe();
        }
    }
}

