/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.hue.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.hue.impl.HueBridgeDiscovery;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Deactivate;

public class HueBasedriver
implements ManagedService {
    private static Log Logger = LogFactory.getLog(HueBasedriver.class);
    private static final int SSDP_PORT = 1900;
    private static final int MTIMER_PERIOD = 180000;
    private static final String UPNP_BROADCAST_IP = "239.255.255.250";
    private static final int UDP_PACKET_SIZE = 1024;
    private static final String ENABLE_SSDP_DISCOVERY = "enable.ssdp.discovery";
    private static final String HUE_BRIDGE_DESCRIPTION_URL = "hue.bridge.description.url";
    private static final String HUE_BRIDGE_USER_ID = "hue.bridge.userid";
    private static final String SERVICE_ID = "service.pid";
    private Timer mSearchTimer = new Timer();
    private Thread mSearchThread;
    private Thread aliveThread;
    private Thread bridgeRegistrationThread;
    private MulticastSocket mSearchSocket;
    private MulticastSocket aliveSocket;
    private boolean mSearchInitialized = false;
    private boolean aliveInitialized = false;
    private boolean mSearchActivated = false;
    private boolean newMSearchRequired = true;
    private List<NetworkInterface> networkInterfaces = new ArrayList<NetworkInterface>();
    private HueBridgeDiscovery discovery;

    public HueBasedriver() {
        Logger.info((Object)"HueBasedriver ctor");
    }

    @Activate
    protected void activate(ComponentContext context) {
        Logger.info((Object)"Activating");
        this.discovery = new HueBridgeDiscovery(context.getBundleContext());
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        Logger.info((Object)"Deactivating");
        this.closeSockets();
    }

    private void initMSearchTimer() {
        this.mSearchTimer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (HueBasedriver.this.mSearchInitialized) {
                    HueBasedriver.this.newMSearchRequired = true;
                    HueBasedriver.this.mSearchSocket.close();
                } else {
                    HueBasedriver.this.mSearchActivated = true;
                    HueBasedriver.this.searchHueBridge();
                }
                if (!HueBasedriver.this.aliveInitialized) {
                    HueBasedriver.this.listenAliveHueBridge();
                }
            }
        }, 10L, 180000L);
    }

    private void cancelMSearchTimer() {
        this.mSearchTimer.cancel();
    }

    private void closeSockets() {
        if (this.discovery != null) {
            this.discovery.stopBackgroundProcesses();
        }
        if (this.bridgeRegistrationThread != null) {
            this.bridgeRegistrationThread.interrupt();
        }
        if (this.mSearchThread != null) {
            this.mSearchThread.interrupt();
        }
        if (this.aliveThread != null) {
            this.aliveThread.interrupt();
        }
        this.mSearchActivated = false;
        if (this.mSearchSocket != null) {
            this.mSearchSocket.close();
        }
        if (this.aliveSocket != null) {
            this.aliveSocket.close();
        }
    }

    private void initSearch() {
        try {
            this.mSearchSocket = new MulticastSocket();
            this.mSearchSocket.setReuseAddress(true);
            this.mSearchSocket.setReceiveBufferSize(32768);
            InetSocketAddress multicastAddress = new InetSocketAddress(UPNP_BROADCAST_IP, 1900);
            this.findNetworkInterfaces();
            for (NetworkInterface itf : this.networkInterfaces) {
                try {
                    this.mSearchSocket.joinGroup(multicastAddress, itf);
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException e) {
            Logger.warn((Object)("Init Search IOException : " + e.getMessage()));
        }
    }

    private void initAlive() {
        try {
            this.aliveSocket = new MulticastSocket(1900);
            this.aliveSocket.setReuseAddress(true);
            this.aliveSocket.setReceiveBufferSize(32768);
            InetSocketAddress multicastAddress = new InetSocketAddress(UPNP_BROADCAST_IP, 1900);
            this.findNetworkInterfaces();
            for (NetworkInterface itf : this.networkInterfaces) {
                try {
                    this.aliveSocket.joinGroup(multicastAddress, itf);
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException e) {
            Logger.warn((Object)("Init Alive IOException : " + e.getMessage()));
        }
    }

    private void searchHueBridge() {
        this.mSearchThread = new Thread(){

            @Override
            public void run() {
                block2: while (HueBasedriver.this.mSearchActivated) {
                    HueBasedriver.this.initSearch();
                    HueBasedriver.this.mSearchInitialized = true;
                    HueBasedriver.this.discovery.clearDescriptions();
                    HueBasedriver.this.sendMSearchMessage();
                    HueBasedriver.this.newMSearchRequired = false;
                    byte[] data = new byte[1024];
                    while (!HueBasedriver.this.newMSearchRequired) {
                        DatagramPacket receivePacket = new DatagramPacket(data, data.length);
                        try {
                            HueBasedriver.this.mSearchSocket.receive(receivePacket);
                        }
                        catch (IOException iOException) {
                            continue block2;
                        }
                        HueBasedriver.this.lookingForHueBridge(receivePacket);
                    }
                }
            }
        };
        this.mSearchThread.start();
    }

    private void listenAliveHueBridge() {
        this.aliveThread = new Thread(){

            @Override
            public void run() {
                HueBasedriver.this.initAlive();
                HueBasedriver.this.aliveInitialized = true;
                byte[] data = new byte[1024];
                while (true) {
                    DatagramPacket receivePacket = new DatagramPacket(data, data.length);
                    try {
                        HueBasedriver.this.aliveSocket.receive(receivePacket);
                    }
                    catch (IOException iOException) {}
                    HueBasedriver.this.lookingForHueBridge(receivePacket);
                }
            }
        };
        this.aliveThread.start();
    }

    private void lookingForHueBridge(DatagramPacket receivePacket) {
        String message = new String(receivePacket.getData());
        try {
            String tag = "location:";
            int startIndex = message.toLowerCase().indexOf(tag) + tag.length();
            if (startIndex >= tag.length()) {
                int endIndex = message.indexOf("\r\n", startIndex);
                String location = message.substring(startIndex, endIndex).trim();
                this.discovery.processNewHueBridge(location);
            }
        }
        catch (IOException e) {
            Logger.warn((Object)"Looking for Hue Bridge IOException : ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findNetworkInterfaces() {
        try {
            Enumeration<NetworkInterface> itfs = NetworkInterface.getNetworkInterfaces();
            while (itfs.hasMoreElements()) {
                NetworkInterface itf = itfs.nextElement();
                if (!this.isUsableNetworkInterface(itf)) continue;
                List<NetworkInterface> list = this.networkInterfaces;
                synchronized (list) {
                    this.networkInterfaces.add(itf);
                }
            }
        }
        catch (Exception exception) {}
    }

    private List<InetAddress> getInetAddresses(NetworkInterface networkInterface) {
        return Collections.list(networkInterface.getInetAddresses());
    }

    private boolean isUsableNetworkInterface(NetworkInterface iface) throws Exception {
        if (this.getInetAddresses(iface).isEmpty()) {
            return false;
        }
        if (iface.getDisplayName() != null && iface.getDisplayName().toLowerCase(Locale.ENGLISH).indexOf("vmnet") >= 0) {
            return false;
        }
        String lower = iface.getName().toLowerCase(Locale.ENGLISH);
        return !lower.startsWith("vmnet") && !lower.startsWith("vnic") && !lower.startsWith("ppp") && !lower.startsWith("lo") && lower.indexOf("virtual") == -1;
    }

    protected boolean isUsableAddress(NetworkInterface networkInterface, InetAddress address) {
        return address instanceof Inet4Address || address.isLoopbackAddress();
    }

    private void sendMSearchMessage() {
        StringBuffer msearch = new StringBuffer();
        msearch.append("M-SEARCH * HTTP/1.1\r\n");
        msearch.append("Man: \"ssdp:discover\"\r\n");
        msearch.append("Mx: 3\r\n");
        msearch.append("Host: 239.255.255.250:1900\r\n");
        msearch.append("St: ssdp:all\r\n");
        msearch.append("\r\n");
        try {
            InetAddress group = InetAddress.getByName(UPNP_BROADCAST_IP);
            int msearch_length = msearch.length();
            byte[] msearch_bytes = msearch.toString().getBytes();
            DatagramPacket packet = new DatagramPacket(msearch_bytes, msearch_length, group, 1900);
            this.mSearchSocket.send(packet);
        }
        catch (SocketException e) {
            Logger.warn((Object)"M-SEARCH SocketException : ", (Throwable)e);
        }
        catch (IOException e) {
            Logger.warn((Object)"M-SEARCH IOException : ", (Throwable)e);
        }
        catch (Exception e) {
            Logger.warn((Object)"M-SEARCH Exception : ", (Throwable)e);
        }
    }

    public void updated(final Dictionary properties) throws ConfigurationException {
        this.closeSockets();
        Logger.info((Object)"Updating Hue Bridge connection upon the config file");
        try {
            this.cancelMSearchTimer();
        }
        catch (Exception exception) {}
        if (properties == null) {
            Logger.info((Object)"No found properties... Try SSDP discovery");
            this.initMSearchTimer();
        } else {
            try {
                if (Boolean.valueOf(properties.get(ENABLE_SSDP_DISCOVERY).toString()).booleanValue()) {
                    this.initMSearchTimer();
                    return;
                }
            }
            catch (Exception exception) {}
            final String descriptionUrl = (String)properties.get(HUE_BRIDGE_DESCRIPTION_URL);
            final String userId = (String)properties.get(HUE_BRIDGE_USER_ID);
            Logger.info((Object)("Config file description url: " + descriptionUrl + ", config file user id: " + userId));
            if (userId == null || userId == "") {
                Logger.warn((Object)"No userId for Hue Bridge update...");
            }
            if (descriptionUrl == null) {
                Logger.warn((Object)"No description...");
            } else {
                this.bridgeRegistrationThread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            String newUserId = HueBasedriver.this.discovery.processHueBridge(descriptionUrl, userId);
                            if (newUserId != null && !newUserId.equals(userId)) {
                                HueBasedriver.this.updatePropertiesFile(properties.get(HueBasedriver.SERVICE_ID) + ".properties", HueBasedriver.HUE_BRIDGE_USER_ID, newUserId);
                            }
                        }
                        catch (IOException e) {
                            Logger.warn((Object)"Error processing new bridge", (Throwable)e);
                        }
                    }
                };
                this.bridgeRegistrationThread.run();
            }
        }
    }

    protected void updatePropertiesFile(String filename, String key, String value) {
        try {
            File file = new File("configurations/services/" + filename);
            Properties properties = new Properties();
            FileReader fr = new FileReader(file);
            properties.load(fr);
            Logger.info((Object)("Updating the: " + filename + " file, to save the: " + key + " property"));
            properties.setProperty(key, value);
            properties.store(new FileOutputStream(file), "");
        }
        catch (IOException e) {
            Logger.error((Object)("Error while updating the: " + filename + " file, to save the: " + key + " property"), (Throwable)e);
        }
    }
}

