/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.eclipselink.internal.dao;

import java.math.BigInteger;
import org.eclipse.om2m.commons.constants.MgmtDefinitionTypes;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoAnncEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoAnncEntity;
import org.eclipse.om2m.commons.entities.DeviceInfoAnncEntity;
import org.eclipse.om2m.commons.entities.MgmtObjAnncEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.persistence.eclipselink.internal.DBTransactionJPAImpl;
import org.eclipse.om2m.persistence.eclipselink.internal.dao.AbstractDAO;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class MgmtObjAnncDAO
extends AbstractDAO<MgmtObjAnncEntity> {
    private AbstractDAO<DeviceInfoAnncEntity> deviceInfoDAO = new AbstractDAO<DeviceInfoAnncEntity>(){

        @Override
        public DeviceInfoAnncEntity find(DBTransaction dbTransaction, Object id) {
            DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
            return (DeviceInfoAnncEntity)transaction.getEm().find(DeviceInfoAnncEntity.class, id);
        }

        @Override
        public void delete(DBTransaction dbTransaction, DeviceInfoAnncEntity resource) {
        }
    };
    private AbstractDAO<AreaNwkInfoAnncEntity> areaNwkInfoDAO = new AbstractDAO<AreaNwkInfoAnncEntity>(){

        @Override
        public AreaNwkInfoAnncEntity find(DBTransaction dbTransaction, Object id) {
            DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
            return (AreaNwkInfoAnncEntity)transaction.getEm().find(AreaNwkInfoAnncEntity.class, id);
        }

        @Override
        public void delete(DBTransaction dbTransaction, AreaNwkInfoAnncEntity resource) {
        }
    };
    private AbstractDAO<AreaNwkDeviceInfoAnncEntity> areaNwkDeviceInfoDAO = new AbstractDAO<AreaNwkDeviceInfoAnncEntity>(){

        @Override
        public AreaNwkDeviceInfoAnncEntity find(DBTransaction dbTransaction, Object id) {
            DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
            return (AreaNwkDeviceInfoAnncEntity)transaction.getEm().find(AreaNwkDeviceInfoAnncEntity.class, id);
        }

        @Override
        public void delete(DBTransaction dbTransaction, AreaNwkDeviceInfoAnncEntity resource) {
        }
    };

    @Override
    public void create(DBTransaction dbTransaction, MgmtObjAnncEntity resource) {
        BigInteger mgd = resource.getMgmtDefinition();
        if (mgd.equals(MgmtDefinitionTypes.AREA_NWK_INFO)) {
            this.areaNwkInfoDAO.create(dbTransaction, (AreaNwkInfoAnncEntity)resource);
        } else if (mgd.equals(MgmtDefinitionTypes.AREA_NWK_DEVICE_INFO)) {
            this.areaNwkDeviceInfoDAO.create(dbTransaction, (AreaNwkDeviceInfoAnncEntity)resource);
        } else if (mgd.equals(MgmtDefinitionTypes.DEVICE_INFO)) {
            this.deviceInfoDAO.create(dbTransaction, (DeviceInfoAnncEntity)resource);
        } else {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    @Override
    public MgmtObjAnncEntity find(DBTransaction dbTransaction, Object id) {
        MgmtObjAnncEntity ret = (MgmtObjAnncEntity)this.deviceInfoDAO.find(dbTransaction, id);
        if (ret != null) {
            return ret;
        }
        ret = (MgmtObjAnncEntity)this.areaNwkInfoDAO.find(dbTransaction, id);
        if (ret != null) {
            return ret;
        }
        ret = (MgmtObjAnncEntity)this.areaNwkDeviceInfoDAO.find(dbTransaction, id);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    @Override
    public void delete(DBTransaction dbTransaction, MgmtObjAnncEntity resource) {
        DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
        if (resource.getParentNode() != null) {
            resource.getParentNode().removeMgmtObj(resource);
        }
        transaction.getEm().remove((Object)resource);
        transaction.getEm().getEntityManagerFactory().getCache().evict(NodeEntity.class);
    }
}

