/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.netatmo.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.om2m.sdt.home.netatmo.impl.Activator;
import org.eclipse.om2m.sdt.home.netatmo.impl.Server;
import org.eclipse.om2m.sdt.home.netatmo.model.Event;
import org.eclipse.om2m.sdt.home.netatmo.model.Home;
import org.eclipse.om2m.sdt.home.netatmo.model.HomeListener;
import org.eclipse.om2m.sdt.home.netatmo.model.Person;
import org.eclipse.om2m.sdt.home.netatmo.model.Token;
import org.eclipse.om2m.sdt.home.netatmo.model.WeatherStation;
import org.eclipse.om2m.sdt.home.netatmo.model.WeatherStationModule;
import org.eclipse.om2m.sdt.home.netatmo.model.WelcomeCamera;

public class Discovery {
    public static final String CONFIG_CLIENT_ID = "client.id";
    public static final String CONFIG_CLIENT_SECRET = "client.secret";
    public static final String CONFIG_USERNAME = "username";
    public static final String CONFIG_PASSWORD = "password";
    public static final String CONFIG_WELCOME_CAMERA_SAMPLING = "welcome.camera.sampling";
    public static final String CONFIG_WEATHER_STATION_SAMPLING = "weather.station.sampling";
    public static final String CONFIG_CAMERA_DETECTION_THRESHOLD = "camera.detection.threshold";
    public static final String CONFIG_CAMERA_USE_LOCAL_URL = "camera.use.local.url";
    private static final int WELCOME_CAMERA_SAMPLING_DEFAULT_VALUE = 10000;
    private static final int WEATHER_STATION_SAMPLING_DEFAULT_VALUE = 500000;
    private Timer discoveryWelcomeTimer;
    private TimerTask discoveryWelcomeTimerTask;
    private Timer discoveryWeatherStationTimer;
    private TimerTask discoveryWeatherStationTimerTask;
    private Server server;
    private final List<HomeListener> homeListeners;
    private Home currentHome;
    private Map<String, WeatherStation> currentWeatherStations;
    private int welcomeCameraSampling;
    private int weatherStationSampling;
    private boolean useLocalUrl = false;

    public Discovery(Map properties) {
        Object useLocalUrlProp = properties.get(CONFIG_CAMERA_USE_LOCAL_URL);
        if (useLocalUrlProp != null) {
            this.useLocalUrl = Boolean.parseBoolean(useLocalUrlProp.toString());
        }
        this.server = new Server((String)properties.get(CONFIG_CLIENT_ID), (String)properties.get(CONFIG_CLIENT_SECRET), (String)properties.get(CONFIG_USERNAME), (String)properties.get(CONFIG_PASSWORD));
        try {
            this.welcomeCameraSampling = Integer.parseInt(properties.get(CONFIG_WELCOME_CAMERA_SAMPLING).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.welcomeCameraSampling = 10000;
        }
        try {
            this.weatherStationSampling = Integer.parseInt(properties.get(CONFIG_WEATHER_STATION_SAMPLING).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.weatherStationSampling = 500000;
        }
        this.currentWeatherStations = new HashMap<String, WeatherStation>();
        this.homeListeners = new ArrayList<HomeListener>();
        this.discoveryWelcomeTimerTask = new TimerTask(){

            @Override
            public void run() {
                List<Home> homes = Discovery.this.server.getHomeData(null, 5L);
                if (homes.isEmpty()) {
                    Activator.logger.info("list of homes is empty !!!!!!", Discovery.class);
                    return;
                }
                Home updatedHome = homes.get(0);
                for (WelcomeCamera c : updatedHome.getCameras().values()) {
                    c.setUseLocalUrl(Discovery.this.useLocalUrl);
                }
                if (Discovery.this.currentHome == null) {
                    Discovery.this.currentHome = updatedHome;
                    Discovery.this.notifyHomeAdded(Discovery.this.currentHome);
                } else if (updatedHome.getId().equals(Discovery.this.currentHome.getId())) {
                    for (WelcomeCamera c : updatedHome.getCameras().values()) {
                        boolean updated = Discovery.this.currentHome.addOrUpdateCamera(c);
                        WelcomeCamera currentCamera = Discovery.this.currentHome.getCamera(c.getId());
                        Discovery.this.notifyCameraAddedOrUpdated(Discovery.this.currentHome, currentCamera, updated);
                    }
                    for (Person p : updatedHome.getPersons().values()) {
                        Discovery.this.currentHome.addOrUpdatePerson(p);
                        Discovery.this.notifyPersonAddedOrUpdated(Discovery.this.currentHome, p, true);
                    }
                    Discovery.this.currentHome.setEvents(updatedHome.getEvents());
                    Discovery.this.notifyEventsUpdated(Discovery.this.currentHome, Discovery.this.currentHome.getEvents());
                } else {
                    Activator.logger.info("updated home(id" + updatedHome.getId() + ") != currentHome(id=" + Discovery.this.currentHome.getId() + ")", Discovery.class);
                }
            }
        };
        this.discoveryWeatherStationTimerTask = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<WeatherStation> wss = Discovery.this.server.getStationsData();
                for (WeatherStation ws : wss) {
                    WeatherStation alreadyDiscoveryWS = null;
                    Map map = Discovery.this.currentWeatherStations;
                    synchronized (map) {
                        alreadyDiscoveryWS = (WeatherStation)Discovery.this.currentWeatherStations.get(ws.getId());
                    }
                    if (alreadyDiscoveryWS != null) {
                        alreadyDiscoveryWS.updateData(ws);
                        for (WeatherStationModule module : ws.getModules().values()) {
                            alreadyDiscoveryWS.addOrUpdateModule(module);
                        }
                        Discovery.this.notifyWeatherStationAddedOrUpdated(alreadyDiscoveryWS, true);
                        continue;
                    }
                    map = Discovery.this.currentWeatherStations;
                    synchronized (map) {
                        Discovery.this.currentWeatherStations.put(ws.getId(), ws);
                    }
                    Discovery.this.notifyWeatherStationAddedOrUpdated(ws, false);
                }
            }
        };
    }

    public void startDiscovery() {
        Activator.logger.info("startDiscovery", Discovery.class);
        this.discoveryWelcomeTimer = new Timer();
        this.discoveryWelcomeTimer.schedule(this.discoveryWelcomeTimerTask, 0L, (long)this.welcomeCameraSampling);
        this.discoveryWeatherStationTimer = new Timer();
        this.discoveryWeatherStationTimer.schedule(this.discoveryWeatherStationTimerTask, 0L, (long)this.weatherStationSampling);
    }

    public void stopDiscovery() {
        Activator.logger.info("stopDiscovery", Discovery.class);
        if (this.discoveryWelcomeTimer != null) {
            this.discoveryWelcomeTimer.cancel();
            this.discoveryWelcomeTimer = null;
        }
        if (this.discoveryWeatherStationTimer != null) {
            this.discoveryWeatherStationTimer.cancel();
            this.discoveryWeatherStationTimer = null;
        }
    }

    public Token checkConnectivity() {
        return this.server.getToken();
    }

    public Home getCurrentHome() {
        return this.currentHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHomeListener(HomeListener homeListener) {
        List<HomeListener> list = this.homeListeners;
        synchronized (list) {
            this.homeListeners.add(homeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHomeListener(HomeListener homeListener) {
        List<HomeListener> list = this.homeListeners;
        synchronized (list) {
            this.homeListeners.remove(homeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<HomeListener> getHomeListeners() {
        ArrayList<HomeListener> toBeReturned = new ArrayList<HomeListener>();
        List<HomeListener> list = this.homeListeners;
        synchronized (list) {
            toBeReturned.addAll(this.homeListeners);
        }
        return toBeReturned;
    }

    private void notifyCameraAddedOrUpdated(Home home, WelcomeCamera camera, boolean updated) {
        List<HomeListener> listeners = this.getHomeListeners();
        for (HomeListener listener : listeners) {
            try {
                listener.notifyCameraAddedOrUpdated(home, camera, updated);
            }
            catch (Exception e) {
                Activator.logger.warning(e.toString(), Discovery.class);
            }
        }
    }

    private void notifyHomeAdded(Home newHome) {
        List<HomeListener> listeners = this.getHomeListeners();
        for (HomeListener listener : listeners) {
            try {
                listener.notifyHomeAdded(newHome);
                for (WelcomeCamera wc : newHome.getCameras().values()) {
                    listener.notifyCameraAddedOrUpdated(newHome, wc, false);
                }
                for (Person p : newHome.getPersons().values()) {
                    listener.notifyPersonAddedOrUpdated(newHome, p, false);
                }
                listener.notifyEventsUpdated(newHome, newHome.getEvents());
            }
            catch (Exception e) {
                Activator.logger.warning(e.toString(), Discovery.class);
            }
        }
    }

    private void notifyEventsUpdated(Home home, List<Event> events) {
        List<HomeListener> listeners = this.getHomeListeners();
        for (HomeListener listener : listeners) {
            try {
                listener.notifyEventsUpdated(home, events);
            }
            catch (Exception e) {
                Activator.logger.warning(e.toString(), Discovery.class);
            }
        }
    }

    private void notifyPersonAddedOrUpdated(Home home, Person person, boolean updated) {
        List<HomeListener> listeners = this.getHomeListeners();
        for (HomeListener listener : listeners) {
            try {
                listener.notifyPersonAddedOrUpdated(home, person, updated);
            }
            catch (Exception e) {
                Activator.logger.warning(e.toString(), Discovery.class);
            }
        }
    }

    private void notifyWeatherStationAddedOrUpdated(WeatherStation ws, boolean updated) {
        Activator.logger.info("notifyWeatherStationAddedOrUpdated(ws=" + ws.getId() + ", updated=" + updated + ")", Discovery.class);
        List<HomeListener> listeners = this.getHomeListeners();
        for (HomeListener listener : listeners) {
            try {
                listener.notifyWeatherStationAddedOrUpdated(ws, updated);
            }
            catch (Exception e) {
                Activator.logger.warning(e.toString(), Discovery.class);
            }
        }
    }
}

