/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.eclipse.om2m.commons.entities.AccessControlRuleEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.DeviceInfoEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerAnncEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.PollingChannelEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Entity(name="ACP")
@Inheritance(strategy=InheritanceType.JOINED)
public class AccessControlPolicyEntity
extends AnnounceableSubordinateEntity {
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="selfAccessControlPolicy")
    @JoinTable(name="ACP_ACR_PVS", joinColumns={@JoinColumn(name="ACP_RI", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACR_ID", referencedColumnName="ACR_ID")})
    protected List<AccessControlRuleEntity> selfPrivileges;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="accessControlPolicy")
    @JoinTable(name="ACP_ACR_PV", joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACR_ID", referencedColumnName="ACR_ID")})
    protected List<AccessControlRuleEntity> privileges;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="linkedAccessControlPolicyEntities")
    @JoinTable(name="ACP_DAC_JOIN", inverseJoinColumns={@JoinColumn(name="DAC_JOINID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<DynamicAuthorizationConsultationEntity> dynamicConsultationAuthorizations;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=CSEBaseEntity.class)
    @JoinTable(name="CSEB_CHILDACP", inverseJoinColumns={@JoinColumn(name="CSEB_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected CSEBaseEntity parentCse;
    @ManyToOne
    @JoinTable(name="AE_CHACP", inverseJoinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected AeEntity parentAE;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=RemoteCSEEntity.class)
    @JoinTable(name="CSR_ACPCH_JOIN", inverseJoinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected RemoteCSEEntity parentCsr;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, targetEntity=SubscriptionEntity.class, mappedBy="parentAcp")
    @JoinTable(name="ACP_SUB_JOIN", inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> childSubscriptions;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=CSEBaseEntity.class)
    @JoinTable(name="CSEB_ACP", inverseJoinColumns={@JoinColumn(name="CSEB_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<CSEBaseEntity> linkedCses;
    @ManyToMany
    @JoinTable(name="AE_ACP", inverseJoinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AeEntity> linkedAes;
    @ManyToMany
    @JoinTable(name="CNT_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<ContainerEntity> linkedCnts;
    @ManyToMany
    @JoinTable(name="DAC_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="DAC_JOINID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<DynamicAuthorizationConsultationEntity> linkedDynamicAuthorizationConsultation;
    @ManyToMany
    @JoinTable(name="FCNT_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="FCNT_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<FlexContainerEntity> linkedFlexCnts;
    @ManyToMany
    @JoinTable(name="FCNTA_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="FCNTA_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<FlexContainerAnncEntity> linkedFlexCntAs;
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, targetEntity=SubscriptionEntity.class)
    @JoinTable(name="SUB_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> linkedSubscription;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=PollingChannelEntity.class)
    @JoinTable(name="ACP_PCH_JOIN", inverseJoinColumns={@JoinColumn(name="PCH_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<PollingChannelEntity> linkedPch;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=NodeEntity.class)
    @JoinTable(name="NOD_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<NodeEntity> linkedNodes;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=AreaNwkInfoEntity.class)
    @JoinTable(name="ANI_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="ANI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AreaNwkInfoEntity> areaNwkInfoEntities;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=AreaNwkDeviceInfoEntity.class)
    @JoinTable(name="ANDI_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="ANDI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AreaNwkDeviceInfoEntity> areaNwkDeviceInfoEntities;
    @ManyToMany(fetch=FetchType.LAZY, targetEntity=DeviceInfoEntity.class)
    @JoinTable(name="DVI_ACP_JOIN", inverseJoinColumns={@JoinColumn(name="DVI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<DeviceInfoEntity> deviceInfoEntities;

    public List<AccessControlRuleEntity> getPrivileges() {
        if (this.privileges == null) {
            this.privileges = new ArrayList<AccessControlRuleEntity>();
        }
        return this.privileges;
    }

    public void setPrivileges(List<AccessControlRuleEntity> privileges) {
        this.privileges = privileges;
    }

    public List<AccessControlRuleEntity> getSelfPrivileges() {
        if (this.selfPrivileges == null) {
            this.selfPrivileges = new ArrayList<AccessControlRuleEntity>();
        }
        return this.selfPrivileges;
    }

    public void setSelfPrivileges(List<AccessControlRuleEntity> selfPrivileges) {
        this.selfPrivileges = selfPrivileges;
    }

    public CSEBaseEntity getParentCse() {
        return this.parentCse;
    }

    public void setParentCse(CSEBaseEntity parentCse) {
        this.parentCse = parentCse;
    }

    public AeEntity getParentAE() {
        return this.parentAE;
    }

    public void setParentAE(AeEntity parentAE) {
        this.parentAE = parentAE;
    }

    public RemoteCSEEntity getParentCsr() {
        return this.parentCsr;
    }

    public void setParentCsr(RemoteCSEEntity parentCsr) {
        this.parentCsr = parentCsr;
    }

    public List<CSEBaseEntity> getLinkedCse() {
        if (this.linkedCses == null) {
            this.linkedCses = new ArrayList<CSEBaseEntity>();
        }
        return this.linkedCses;
    }

    public void setLinkedCse(List<CSEBaseEntity> linkedCse) {
        this.linkedCses = linkedCse;
    }

    public List<ContainerEntity> getLinkedContainers() {
        if (this.linkedCnts == null) {
            this.linkedCnts = new ArrayList<ContainerEntity>();
        }
        return this.linkedCnts;
    }

    public void setLinkedContainer(List<ContainerEntity> linkedContainer) {
        this.linkedCnts = linkedContainer;
    }

    public List<FlexContainerEntity> getLinkedFlexContainers() {
        if (this.linkedFlexCnts == null) {
            this.linkedFlexCnts = new ArrayList<FlexContainerEntity>();
        }
        return this.linkedFlexCnts;
    }

    public void setLinkedFlexContainer(List<FlexContainerEntity> linkedFlexContainer) {
        this.linkedFlexCnts = linkedFlexContainer;
    }

    public List<FlexContainerAnncEntity> getLinkedFlexContainerAs() {
        if (this.linkedFlexCntAs == null) {
            this.linkedFlexCntAs = new ArrayList<FlexContainerAnncEntity>();
        }
        return this.linkedFlexCntAs;
    }

    public void setLinkedFlexContainerA(List<FlexContainerAnncEntity> linkedFlexContainerA) {
        this.linkedFlexCntAs = linkedFlexContainerA;
    }

    public List<SubscriptionEntity> getLinkedSubscription() {
        if (this.linkedSubscription == null) {
            this.linkedSubscription = new ArrayList<SubscriptionEntity>();
        }
        return this.linkedSubscription;
    }

    public void setLinkedSubscription(List<SubscriptionEntity> linkedSubscription) {
        this.linkedSubscription = linkedSubscription;
    }

    public List<PollingChannelEntity> getLinkedPch() {
        if (this.linkedPch == null) {
            this.linkedPch = new ArrayList<PollingChannelEntity>();
        }
        return this.linkedPch;
    }

    public void setLinkedPch(List<PollingChannelEntity> linkedPch) {
        this.linkedPch = linkedPch;
    }

    public List<AeEntity> getLinkedAes() {
        if (this.linkedAes == null) {
            this.linkedAes = new ArrayList<AeEntity>();
        }
        return this.linkedAes;
    }

    public void setLinkedAes(List<AeEntity> linkedAes) {
        this.linkedAes = linkedAes;
    }

    public List<SubscriptionEntity> getChildSubscriptions() {
        if (this.childSubscriptions == null) {
            this.childSubscriptions = new ArrayList<SubscriptionEntity>();
        }
        return this.childSubscriptions;
    }

    public void setChildSubscriptions(List<SubscriptionEntity> childSubscription) {
        this.childSubscriptions = childSubscription;
    }

    public List<NodeEntity> getLinkedNodes() {
        if (this.linkedNodes == null) {
            this.linkedNodes = new ArrayList<NodeEntity>();
        }
        return this.linkedNodes;
    }

    public void setLinkedNodes(List<NodeEntity> linkedNodes) {
        this.linkedNodes = linkedNodes;
    }

    public List<AreaNwkInfoEntity> getAreaNwkInfoEntities() {
        if (this.areaNwkInfoEntities == null) {
            this.areaNwkInfoEntities = new ArrayList<AreaNwkInfoEntity>();
        }
        return this.areaNwkInfoEntities;
    }

    public void setAreaNwkInfoEntities(List<AreaNwkInfoEntity> areaNwkInfoEntities) {
        this.areaNwkInfoEntities = areaNwkInfoEntities;
    }

    public List<AreaNwkDeviceInfoEntity> getAreaNwkDeviceInfoEntities() {
        if (this.areaNwkDeviceInfoEntities == null) {
            this.areaNwkDeviceInfoEntities = new ArrayList<AreaNwkDeviceInfoEntity>();
        }
        return this.areaNwkDeviceInfoEntities;
    }

    public void setAreaNwkDeviceInfoEntities(List<AreaNwkDeviceInfoEntity> areaNwkDeviceInfoEntities) {
        this.areaNwkDeviceInfoEntities = areaNwkDeviceInfoEntities;
    }

    public List<DeviceInfoEntity> getDeviceInfoEntities() {
        if (this.deviceInfoEntities == null) {
            this.deviceInfoEntities = new ArrayList<DeviceInfoEntity>();
        }
        return this.deviceInfoEntities;
    }

    public void setDeviceInfoEntities(List<DeviceInfoEntity> deviceInfoEntities) {
        this.deviceInfoEntities = deviceInfoEntities;
    }

    public List<MgmtObjEntity> getMgmtObjEntities() {
        ArrayList<MgmtObjEntity> ret = new ArrayList<MgmtObjEntity>();
        ret.addAll(this.getAreaNwkInfoEntities());
        ret.addAll(this.getAreaNwkDeviceInfoEntities());
        ret.addAll(this.getDeviceInfoEntities());
        return ret;
    }

    public List<DynamicAuthorizationConsultationEntity> getLinkedDynamicAuthorizationConsultation() {
        if (this.linkedDynamicAuthorizationConsultation == null) {
            this.linkedDynamicAuthorizationConsultation = new ArrayList<DynamicAuthorizationConsultationEntity>();
        }
        return this.linkedDynamicAuthorizationConsultation;
    }

    public void setLinkedDynamicAuthorizationConsultation(List<DynamicAuthorizationConsultationEntity> linkedDynamicAuthorizationConsultation) {
        this.linkedDynamicAuthorizationConsultation = linkedDynamicAuthorizationConsultation;
    }

    @Override
    public List<DynamicAuthorizationConsultationEntity> getDynamicAuthorizationConsultations() {
        if (this.dynamicConsultationAuthorizations == null) {
            this.dynamicConsultationAuthorizations = new ArrayList<DynamicAuthorizationConsultationEntity>();
        }
        return this.dynamicConsultationAuthorizations;
    }

    @Override
    public void setDynamicAuthorizationConsultations(List<DynamicAuthorizationConsultationEntity> list) {
        this.dynamicConsultationAuthorizations = list;
    }

    @Override
    public List<AccessControlPolicyEntity> getAccessControlPolicies() {
        return null;
    }

    @Override
    public void setAccessControlPolicies(List<AccessControlPolicyEntity> accessControlPolicies) {
    }
}

