/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.dal.driver.sample.fan.function;

import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.dal.driver.custom.functions.BaseFunction;
import org.eclipse.om2m.dal.driver.sample.Activator;
import org.osgi.service.dal.DeviceException;
import org.osgi.service.dal.FunctionData;
import org.osgi.service.dal.FunctionEvent;
import org.osgi.service.dal.PropertyMetadata;
import org.osgi.service.dal.functions.MultiLevelControl;
import org.osgi.service.dal.functions.data.LevelData;
import org.osgi.service.event.Event;

public class Speed
extends BaseFunction
implements MultiLevelControl {
    private static Log LOGGER = LogFactory.getLog(Speed.class);
    public static BigDecimal LEVEL_0 = new BigDecimal(0);
    public static BigDecimal LEVEL_1 = new BigDecimal(1);
    public static BigDecimal LEVEL_2 = new BigDecimal(2);
    private SpeedValueMetadata speedValueMetadata;
    private BigDecimal data = LEVEL_0;

    public Speed(String devUid, String funcId) {
        super(devUid, "fanspeed", funcId);
    }

    public LevelData getData() throws DeviceException {
        return new LevelData(System.currentTimeMillis(), this.speedValueMetadata.getMetadata(null), this.data, "");
    }

    public void setData(BigDecimal level, String unit) throws DeviceException {
        if (level.compareTo(LEVEL_0) != 0 && level.compareTo(LEVEL_1) != 0 && level.compareTo(LEVEL_2) != 0) {
            throw new DeviceException(String.format("Input level is out of scope (%s, %s, %s)!", LEVEL_0.toString(), LEVEL_1.toString(), LEVEL_2.toString()));
        }
        this.data = level;
        Activator.getEventAdmin().postEvent((Event)new FunctionEvent("org/osgi/service/dal/FunctionEvent/PROPERTY_CHANGED", this.uid, "data", (FunctionData)new LevelData(System.currentTimeMillis(), this.speedValueMetadata.getMetadata(null), this.data, "")));
        LOGGER.info((Object)("Function event (" + this.uid + "-" + this.data + ") is sent."));
    }

    @Override
    protected void setupFuncProperties() {
        this.props.put("dal.function.version", "1.0");
        this.props.put("dal.function.description", "Speed control function");
        this.props.put("dal.function.property.names", new String[]{"data"});
    }

    @Override
    protected void setupPropertyMetadata() {
        this.speedValueMetadata = new SpeedValueMetadata();
        this.propMetadatas.put("data", this.speedValueMetadata);
    }

    @Override
    protected void setupOperationMetadata() {
    }

    private class SpeedValueMetadata
    implements PropertyMetadata {
        private Map<String, Object> metadatas = new Hashtable<String, Object>();

        public SpeedValueMetadata() {
            this.metadatas.put("access", new Integer(3));
            this.metadatas.put("description", "The current speed level.");
        }

        public Map getMetadata(String unit) {
            return this.metadatas;
        }

        public FunctionData getStep(String unit) {
            return null;
        }

        public FunctionData[] getEnumValues(String unit) {
            return new FunctionData[]{new LevelData(0L, this.metadatas, LEVEL_0, ""), new LevelData(0L, this.metadatas, LEVEL_1, ""), new LevelData(0L, this.metadatas, LEVEL_2, "")};
        }

        public FunctionData getMinValue(String unit) {
            return null;
        }

        public FunctionData getMaxValue(String unit) {
            return null;
        }
    }
}

