/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.dal;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.InternalServerErrorException;
import org.eclipse.om2m.commons.obix.Obj;
import org.eclipse.om2m.commons.obix.Str;
import org.eclipse.om2m.commons.obix.io.ObixEncoder;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.interworking.service.InterworkingService;
import org.eclipse.om2m.ipe.dal.Activator;
import org.eclipse.om2m.ipe.dal.FunctionServiceTracker;
import org.eclipse.om2m.persistence.service.DBTransaction;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.dal.Device;
import org.osgi.service.dal.Function;
import org.osgi.util.tracker.ServiceTracker;

public class InterworkingServiceImpl
implements InterworkingService {
    private static Log LOGGER = LogFactory.getLog(InterworkingServiceImpl.class);
    private static HashMap<String, Function> functions = new HashMap();
    public static String poc = "dal";
    public static String CSE_ID = "/" + Constants.CSE_ID;
    public static String CSE_PREFIX = String.valueOf(CSE_ID) + "/" + Constants.CSE_NAME;
    public static final String DATA = "DATA";
    public static final String DESC = "DESCRIPTOR";

    public void activate() {
        ServiceTracker<Object, Object> deviceTracker = new ServiceTracker<Object, Object>(Activator.getContext(), Device.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"Device service removed");
            }

            public Object addingService(ServiceReference<Object> reference) {
                LOGGER.info((Object)"Device service discovered");
                Device device = (Device)this.context.getService(reference);
                InterworkingServiceImpl.this.createDeviceResource(device);
                return device;
            }
        };
        deviceTracker.open();
    }

    public void deactivate() {
    }

    public ResponsePrimitive doExecute(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        String oprName = "";
        String funcResourseName = "";
        if (!request.getQueryStrings().containsKey("op")) {
            throw new BadRequestException("Parameter 'op' is not found.");
        }
        oprName = (String)((List)request.getQueryStrings().get("op")).get(0);
        if (!request.getQueryStrings().containsKey("function")) {
            throw new BadRequestException("Parameter 'function' is not found.");
        }
        funcResourseName = (String)((List)request.getQueryStrings().get("function")).get(0);
        Function function = functions.get(funcResourseName);
        if (function == null) {
            throw new BadRequestException("The specified function can not be found.");
        }
        Method method = null;
        try {
            method = function.getClass().getDeclaredMethod(oprName, new Class[0]);
            method.setAccessible(true);
        }
        catch (Exception exception) {
            throw new BadRequestException("The specified operation is not supported.");
        }
        try {
            Object ret = method.invoke((Object)function, new Object[0]);
            if (ret != null) {
                Obj obj = new Obj();
                obj.add((Object)new Str("Result", ret.toString()));
                response.setContent((Object)ObixEncoder.toString((Obj)obj));
                request.setReturnContentType("application/obix");
            }
        }
        catch (Exception e) {
            throw new InternalServerErrorException(e.getMessage());
        }
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    public String getAPOCPath() {
        return poc;
    }

    public static void addFunction(String resourceName, Function function) {
        functions.put(resourceName, function);
    }

    private void createDeviceResource(Device device) {
        String deviceUid = (String)device.getServiceProperty("dal.device.UID");
        String resourceId = "";
        String appId = deviceUid.replace(':', '_');
        AE ae = new AE();
        ae.setRequestReachability(Boolean.valueOf(true));
        ae.getPointOfAccess().add(poc);
        ae.setAppID(appId);
        ae.setName(appId);
        ResponsePrimitive response = InterworkingServiceImpl.createResource(CSE_ID, (Resource)ae, 2);
        if (response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            resourceId = response.getLocation();
        } else if (response.getResponseStatusCode().equals(ResponseStatusCode.CONFLICT)) {
            DBTransaction dbTransaction = Activator.getDBService().getDbTransaction();
            dbTransaction.open();
            AeEntity dbAe = (AeEntity)Activator.getDBService().getDAOFactory().getAeByAppIdDAO().find(dbTransaction, (Object)appId);
            dbTransaction.close();
            resourceId = dbAe.getResourceID();
        }
        if (!resourceId.isEmpty()) {
            Hashtable<String, Object> dict = new Hashtable<String, Object>();
            ((Dictionary)dict).put("dal.function.device.UID", device.getServiceProperty("dal.device.UID"));
            try {
                FunctionServiceTracker funcTracker = new FunctionServiceTracker(deviceUid, appId);
                funcTracker.open();
            }
            catch (InvalidSyntaxException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    public static ResponsePrimitive createResource(String targetId, Resource resource, int resourceType) {
        RequestPrimitive request = new RequestPrimitive();
        request.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
        request.setTo(targetId);
        request.setResourceType(BigInteger.valueOf(resourceType));
        request.setRequestContentType("application/obj");
        request.setReturnContentType("application/obj");
        request.setContent((Object)resource);
        request.setOperation(Operation.CREATE);
        return Activator.getCseService().doRequest(request);
    }
}

