/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeAnncEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.NodeAnncEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.PollingChannelEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ScheduleEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AEAnnc;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.Group;
import org.eclipse.om2m.commons.resource.Node;
import org.eclipse.om2m.commons.resource.NodeAnnc;
import org.eclipse.om2m.commons.resource.PollingChannel;
import org.eclipse.om2m.commons.resource.RemoteCSE;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.AcpMapper;
import org.eclipse.om2m.core.entitymapper.AeAnncMapper;
import org.eclipse.om2m.core.entitymapper.AeMapper;
import org.eclipse.om2m.core.entitymapper.ContainerMapper;
import org.eclipse.om2m.core.entitymapper.DynamicAuthorizationConsultationMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.entitymapper.FlexContainerMapper;
import org.eclipse.om2m.core.entitymapper.GroupMapper;
import org.eclipse.om2m.core.entitymapper.NodeAnncMapper;
import org.eclipse.om2m.core.entitymapper.NodeMapper;
import org.eclipse.om2m.core.entitymapper.PollingChannelMapper;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class RemoteCSEMapper
extends EntityMapper<RemoteCSEEntity, RemoteCSE> {
    @Override
    protected RemoteCSE createResource() {
        return new RemoteCSE();
    }

    @Override
    protected void mapAttributes(RemoteCSEEntity csrEntity, RemoteCSE csr, int level, int offset) {
        if (level < 0) {
            return;
        }
        EntityMapperFactory.getAnnounceableSubordonateEntity_AnnounceableResourceMapper().mapAttributes((AnnounceableSubordinateEntity)csrEntity, (AnnounceableResource)csr, level, offset);
        csr.setCSEBase(csrEntity.getRemoteCseUri());
        csr.setCSEID(csrEntity.getRemoteCseId());
        csr.setCseType(csrEntity.getCseType());
        csr.setExpirationTime(csrEntity.getExpirationTime());
        csr.setM2MExtID(csrEntity.getM2mExtId());
        csr.setNodeLink(csrEntity.getNodeLink());
        csr.setRequestReachability(Boolean.valueOf(csrEntity.isRequestReachability()));
        csr.setTriggerRecipientID(csrEntity.getTriggerRecipientID());
        if (!csrEntity.getPointOfAccess().isEmpty()) {
            csr.getPointOfAccess().addAll(csrEntity.getPointOfAccess());
        }
    }

    @Override
    protected List<ChildResourceRef> getChildResourceRef(RemoteCSEEntity csrEntity, int level, int offset) {
        ChildResourceRef ch;
        ChildResourceRef child;
        ArrayList<ChildResourceRef> childRefs = new ArrayList<ChildResourceRef>();
        if (level == 0) {
            return childRefs;
        }
        for (SubscriptionEntity sub : csrEntity.getSubscriptions()) {
            child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(23);
            child.setValue(sub.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new SubscriptionMapper().getChildResourceRef(sub, level - 1, offset - 1));
        }
        for (AeEntity ae : csrEntity.getChildAes()) {
            child = new ChildResourceRef();
            child.setResourceName(ae.getName());
            child.setType(2);
            child.setValue(ae.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new AeMapper().getChildResourceRef(ae, level - 1, offset - 1));
        }
        for (AeAnncEntity aeAnnc : csrEntity.getChildAeAnncs()) {
            child = new ChildResourceRef();
            child.setResourceName(aeAnnc.getName());
            child.setType(10002);
            child.setValue(aeAnnc.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new AeAnncMapper().getChildResourceRef(aeAnnc, level - 1, offset - 1));
        }
        for (AccessControlPolicyEntity acp : csrEntity.getChildAcps()) {
            child = new ChildResourceRef();
            child.setResourceName(acp.getName());
            child.setType(1);
            child.setValue(acp.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new AcpMapper().getChildResourceRef(acp, level - 1, offset - 1));
        }
        for (ContainerEntity container : csrEntity.getChildCnt()) {
            child = new ChildResourceRef();
            child.setResourceName(container.getName());
            child.setType(3);
            child.setValue(container.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new ContainerMapper().getChildResourceRef(container, level - 1, offset - 1));
        }
        for (FlexContainerEntity flexContainer : csrEntity.getChildFcnt()) {
            child = new ChildResourceRef();
            child.setResourceName(flexContainer.getName());
            child.setType(28);
            child.setValue(flexContainer.getResourceID());
            child.setSpid(flexContainer.getContainerDefinition());
            childRefs.add(child);
            childRefs.addAll(new FlexContainerMapper().getChildResourceRef(flexContainer, level - 1, offset - 1));
        }
        for (GroupEntity group : csrEntity.getChildGrps()) {
            child = new ChildResourceRef();
            child.setResourceName(group.getName());
            child.setType(9);
            child.setValue(group.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new GroupMapper().getChildResourceRef(group, level - 1, offset - 1));
        }
        for (PollingChannelEntity pollEntity : csrEntity.getPollingChannels()) {
            child = new ChildResourceRef();
            child.setResourceName(pollEntity.getName());
            child.setValue(pollEntity.getResourceID());
            child.setType(15);
            childRefs.add(child);
            childRefs.addAll(new PollingChannelMapper().getChildResourceRef(pollEntity, level - 1, offset - 1));
        }
        ScheduleEntity sch = csrEntity.getLinkedSchedule();
        if (sch != null) {
            ChildResourceRef child2 = new ChildResourceRef();
            child2.setResourceName(sch.getName());
            child2.setValue(sch.getResourceID());
            child2.setType(18);
            childRefs.add(child2);
        }
        for (NodeEntity nod : csrEntity.getChildNodes()) {
            ch = new ChildResourceRef();
            ch.setResourceName(nod.getName());
            ch.setType(14);
            ch.setValue(nod.getResourceID());
            childRefs.add(ch);
            childRefs.addAll(new NodeMapper().getChildResourceRef(nod, level - 1, offset - 1));
        }
        for (NodeEntity nod : csrEntity.getChildAnncNodes()) {
            ch = new ChildResourceRef();
            ch.setResourceName(nod.getName());
            ch.setType(10014);
            ch.setValue(nod.getResourceID());
            childRefs.add(ch);
            childRefs.addAll(new NodeAnncMapper().getChildResourceRef((NodeAnncEntity)nod, level - 1, offset - 1));
        }
        for (DynamicAuthorizationConsultationEntity dace : csrEntity.getChildDynamicAuthorizationConsultation()) {
            ch = new ChildResourceRef();
            ch.setResourceName(dace.getName());
            ch.setType(34);
            ch.setValue(dace.getResourceID());
            childRefs.add(ch);
            childRefs.addAll(new DynamicAuthorizationConsultationMapper().getChildResourceRef(dace, level - 1, offset - 1));
        }
        return childRefs;
    }

    @Override
    protected void mapChildResourceRef(RemoteCSEEntity csrEntity, RemoteCSE csr, int level, int offset) {
        csr.getChildResource().addAll(this.getChildResourceRef(csrEntity, level, offset));
    }

    @Override
    protected void mapChildResources(RemoteCSEEntity csrEntity, RemoteCSE csr, int level, int offset) {
        Node node;
        if (level == 0) {
            return;
        }
        for (SubscriptionEntity sub : csrEntity.getSubscriptions()) {
            Subscription chSub = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            csr.getAEOrContainerOrGroup().add(chSub);
        }
        for (AeEntity ae : csrEntity.getChildAes()) {
            AE chAe = (AE)new AeMapper().mapEntityToResource(ae, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            csr.getAEOrContainerOrGroup().add(chAe);
        }
        for (AeAnncEntity aeAnnc : csrEntity.getChildAeAnncs()) {
            AEAnnc chAeAnnc = (AEAnnc)new AeAnncMapper().mapEntityToResource(aeAnnc, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            csr.getAEOrContainerOrGroup().add(chAeAnnc);
        }
        for (AccessControlPolicyEntity acp : csrEntity.getChildAcps()) {
            AccessControlPolicy chAcp = (AccessControlPolicy)new AcpMapper().mapEntityToResource(acp, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            csr.getAEOrContainerOrGroup().add(chAcp);
        }
        for (ContainerEntity container : csrEntity.getChildCnt()) {
            Container chCnt = (Container)new ContainerMapper().mapEntityToResource(container, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            csr.getAEOrContainerOrGroup().add(chCnt);
        }
        for (FlexContainerEntity flexContainer : csrEntity.getChildFcnt()) {
            AbstractFlexContainer chFcnt = (AbstractFlexContainer)new FlexContainerMapper().mapEntityToResource(flexContainer, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            csr.getAEOrContainerOrGroup().add(chFcnt);
        }
        for (GroupEntity grp : csrEntity.getChildGrps()) {
            Group chGrp = (Group)new GroupMapper().mapEntityToResource(grp, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            csr.getAEOrContainerOrGroup().add(chGrp);
        }
        for (PollingChannelEntity pollEntity : csrEntity.getPollingChannels()) {
            PollingChannel chPch = (PollingChannel)new PollingChannelMapper().mapEntityToResource(pollEntity, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            csr.getAEOrContainerOrGroup().add(chPch);
        }
        for (NodeEntity nod : csrEntity.getChildNodes()) {
            node = (Node)new NodeMapper().mapEntityToResource(nod, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            csr.getAEOrContainerOrGroup().add(node);
        }
        for (NodeEntity nod : csrEntity.getChildAnncNodes()) {
            node = (NodeAnnc)new NodeAnncMapper().mapEntityToResource(nod, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            csr.getAEOrContainerOrGroup().add(node);
        }
        ScheduleEntity sch = csrEntity.getLinkedSchedule();
        for (DynamicAuthorizationConsultationEntity daceEntity : csrEntity.getChildDynamicAuthorizationConsultation()) {
            DynamicAuthorizationConsultation dace = (DynamicAuthorizationConsultation)new DynamicAuthorizationConsultationMapper().mapEntityToResource(daceEntity, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            csr.getAEOrContainerOrGroup().add(dace);
        }
    }
}

