/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.math.BigInteger;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.MgmtDefinitionTypes;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.ConflictException;
import org.eclipse.om2m.commons.exceptions.NotImplementedException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.MgmtObj;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.announcer.Announcer;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.datamapper.DataMapperSelector;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.notifier.Notifier;
import org.eclipse.om2m.core.router.Patterns;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.core.util.ControllerUtil;
import org.eclipse.om2m.persistence.service.DAO;

public class MgmtObjController
extends Controller {
    private static Log LOGGER = LogFactory.getLog(MgmtObjController.class);

    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        String contentFormat = System.getProperty("org.eclipse.om2m.registration.contentFormat", "application/xml");
        Patterns patterns = new Patterns();
        ResponsePrimitive response = new ResponsePrimitive(request);
        DAO<?> dao = patterns.getDAO(request.getTo(), this.dbs);
        if (dao == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        ResourceEntity parentEntity = (ResourceEntity)dao.find(this.transaction, (Object)request.getTo());
        if (parentEntity == null) {
            throw new ResourceNotFoundException("Cannot find parent resource");
        }
        if (parentEntity.getResourceType().intValue() == 10014) {
            throw new NotImplementedException("Parent is Node Annc, not implemented yet.");
        }
        this.transaction.lock((Object)parentEntity);
        NodeEntity nodeEntity = (NodeEntity)parentEntity;
        List acpsToCheck = nodeEntity.getAccessControlPolicies();
        List subscriptions = nodeEntity.getSubscriptions();
        this.checkPermissions(request, (ResourceEntity)nodeEntity, acpsToCheck);
        if (request.getContent() == null) {
            throw new BadRequestException("A content is requiered for MgmtObj creation");
        }
        MgmtObj mgmtObj = null;
        try {
            String payload = null;
            if (request.getRequestContentType().equals("application/obj")) {
                mgmtObj = (MgmtObj)request.getContent();
                payload = DataMapperSelector.getDataMapperList().get(contentFormat).objToString((Object)mgmtObj);
            } else {
                mgmtObj = (MgmtObj)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
                payload = request.getRequestContentType().equals(contentFormat) ? (String)request.getContent() : DataMapperSelector.getDataMapperList().get(contentFormat).objToString((Object)mgmtObj);
            }
            LOGGER.info((Object)("payload: " + payload));
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            LOGGER.info((Object)"ClassCastException: Incorrect resource type in object conversion.", (Throwable)e);
            throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
        }
        if (mgmtObj == null) {
            throw new BadRequestException("Error in provided content");
        }
        BigInteger mgmtDef = mgmtObj.getMgmtDefinition();
        MgmtObjEntity mgmtObjEntity = MgmtObjEntity.create((BigInteger)mgmtDef);
        ControllerUtil.CreateUtil.fillEntityFromAnnounceableResource((AnnounceableResource)mgmtObj, (AnnounceableSubordinateEntity)mgmtObjEntity);
        mgmtObjEntity.fillFrom(mgmtObj);
        String generatedId = MgmtObjController.generateId("", "");
        if (mgmtObj.getName() != null) {
            if (!patterns.checkResourceName(mgmtObj.getName())) {
                throw new BadRequestException("Name provided is incorrect. Must be:" + patterns.ID_STRING);
            }
            mgmtObjEntity.setName(mgmtObj.getName());
        } else {
            mgmtObjEntity.setName(String.valueOf(MgmtDefinitionTypes.getShortName((BigInteger)mgmtDef)) + "_" + generatedId);
        }
        mgmtObjEntity.setResourceID("/" + Constants.CSE_ID + "/" + "mgo" + Constants.PREFIX_SEPERATOR + generatedId);
        mgmtObjEntity.setParentNode(nodeEntity);
        mgmtObjEntity.setHierarchicalURI(String.valueOf(nodeEntity.getHierarchicalURI()) + "/" + mgmtObjEntity.getName());
        mgmtObjEntity.setParentID(nodeEntity.getResourceID());
        mgmtObjEntity.setResourceType(13);
        if (!mgmtObj.getAccessControlPolicyIDs().isEmpty()) {
            mgmtObjEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(mgmtObj.getAccessControlPolicyIDs(), this.transaction));
        } else {
            mgmtObjEntity.getAccessControlPolicies().addAll(acpsToCheck);
        }
        if (!mgmtObj.getDynamicAuthorizationConsultationIDs().isEmpty()) {
            mgmtObjEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(mgmtObj.getDynamicAuthorizationConsultationIDs(), this.transaction));
        }
        if (!UriMapper.addNewUri(mgmtObjEntity.getHierarchicalURI(), mgmtObjEntity.getResourceID(), 13)) {
            throw new ConflictException("Name already present in the parent collection.");
        }
        this.dbs.getDAOFactory().getMgmtObjDAO().create(this.transaction, (Object)mgmtObjEntity);
        MgmtObjEntity mgmtObjFromDB = (MgmtObjEntity)this.dbs.getDAOFactory().getMgmtObjDAO().find(this.transaction, (Object)mgmtObjEntity.getResourceID());
        nodeEntity.addMgmtObj(mgmtObjFromDB);
        dao.update(this.transaction, (Object)nodeEntity);
        for (DynamicAuthorizationConsultationEntity dace : mgmtObjFromDB.getDynamicAuthorizationConsultations()) {
            DynamicAuthorizationConsultationEntity daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
            daceFromDB.addMgmtObj(mgmtObjFromDB);
            this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
        }
        this.transaction.commit();
        if (!mgmtObj.getAnnounceTo().isEmpty()) {
            mgmtObj.setName(mgmtObjFromDB.getName());
            mgmtObj.setResourceID(mgmtObjFromDB.getResourceID());
            mgmtObj.setResourceType(13);
            mgmtObj.setParentID(mgmtObjFromDB.getParentID());
            Announcer.announce((AnnounceableResource)mgmtObj, request.getFrom(), "");
        }
        Notifier.notify(subscriptions, (ResourceEntity)mgmtObjFromDB, 1);
        response.setResponseStatusCode(ResponseStatusCode.CREATED);
        this.setLocationAndCreationContent(request, response, (ResourceEntity)mgmtObjFromDB);
        return response;
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        MgmtObjEntity mgmtObjEntity = (MgmtObjEntity)this.dbs.getDAOFactory().getMgmtObjDAO().find(this.transaction, (Object)request.getTo());
        if (mgmtObjEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        mgmtObjEntity.getAccessControlPolicies();
        this.checkPermissions(request, (ResourceEntity)mgmtObjEntity, mgmtObjEntity.getAccessControlPolicies());
        MgmtObj mgmtObj = EntityMapperFactory.getMapperForMgmtObj().mapEntityToResource(mgmtObjEntity, request);
        response.setContent((Object)mgmtObj);
        response.setResponseStatusCode(ResponseStatusCode.OK);
        return response;
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        return this.processInternalNotifyOrUpdate(request, false);
    }

    @Override
    public ResponsePrimitive doInternalNotify(RequestPrimitive request) {
        return this.processInternalNotifyOrUpdate(request, true);
    }

    private ResponsePrimitive processInternalNotifyOrUpdate(RequestPrimitive request, boolean isInternalNotify) {
        String contentFormat = System.getProperty("org.eclipse.om2m.registration.contentFormat", "application/xml");
        ResponsePrimitive response = new ResponsePrimitive(request);
        MgmtObjEntity mgmtObjEntity = (MgmtObjEntity)this.dbs.getDAOFactory().getMgmtObjDAO().find(this.transaction, (Object)request.getTo());
        this.transaction.lock((Object)mgmtObjEntity);
        if (mgmtObjEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        if (!isInternalNotify) {
            this.checkPermissions(request, (ResourceEntity)mgmtObjEntity, mgmtObjEntity.getAccessControlPolicies());
        }
        MgmtObj modifiedMgmtObj = EntityMapperFactory.getMapperForMgmtObj().mapEntityToResource(mgmtObjEntity, request);
        if (request.getContent() != null) {
            MgmtObj mgmtObj = null;
            try {
                if (request.getRequestContentType().equals("application/obj")) {
                    mgmtObj = (MgmtObj)request.getContent();
                    DataMapperSelector.getDataMapperList().get(contentFormat).objToString((Object)mgmtObj);
                } else {
                    mgmtObj = (MgmtObj)DataMapperSelector.getDataMapperList().get(request.getRequestContentType()).stringToObj((String)request.getContent());
                    if (request.getRequestContentType().equals(contentFormat)) {
                        String cfr_ignored_0 = (String)request.getContent();
                    } else {
                        DataMapperSelector.getDataMapperList().get(contentFormat).objToString((Object)mgmtObj);
                    }
                }
            }
            catch (ClassCastException e) {
                throw new BadRequestException("Incorrect resource representation in content", (Throwable)e);
            }
            if (mgmtObj == null) {
                throw new BadRequestException("Error in provided content");
            }
            if (!mgmtObj.getAccessControlPolicyIDs().isEmpty()) {
                mgmtObjEntity.getAccessControlPolicies().clear();
                mgmtObjEntity.setAccessControlPolicies(ControllerUtil.buildAcpEntityList(mgmtObj.getAccessControlPolicyIDs(), this.transaction));
                modifiedMgmtObj.getAccessControlPolicyIDs().addAll(mgmtObj.getAccessControlPolicyIDs());
            }
            if (!mgmtObj.getDynamicAuthorizationConsultationIDs().isEmpty()) {
                mgmtObjEntity.setDynamicAuthorizationConsultations(ControllerUtil.buildDacEntityList(mgmtObj.getDynamicAuthorizationConsultationIDs(), this.transaction));
                for (DynamicAuthorizationConsultationEntity dace : mgmtObjEntity.getDynamicAuthorizationConsultations()) {
                    DynamicAuthorizationConsultationEntity daceFromDB = (DynamicAuthorizationConsultationEntity)this.dbs.getDAOFactory().getDynamicAuthorizationDAO().find(this.transaction, (Object)dace.getResourceID());
                    daceFromDB.addMgmtObj(mgmtObjEntity);
                    this.dbs.getDAOFactory().getDynamicAuthorizationDAO().update(this.transaction, (Object)daceFromDB);
                }
            }
            if (!mgmtObj.getLabels().isEmpty()) {
                mgmtObjEntity.setLabelsEntitiesFromSring(mgmtObj.getLabels());
                modifiedMgmtObj.getLabels().addAll(mgmtObj.getLabels());
            }
            if (mgmtObj.getExpirationTime() != null) {
                mgmtObjEntity.setExpirationTime(mgmtObj.getExpirationTime());
                modifiedMgmtObj.setExpirationTime(mgmtObj.getExpirationTime());
            }
            if (!mgmtObj.getAnnounceTo().isEmpty()) {
                mgmtObjEntity.getAnnounceTo().clear();
                mgmtObjEntity.getAnnounceTo().addAll(mgmtObj.getAnnounceTo());
                modifiedMgmtObj.getAnnounceTo().addAll(mgmtObj.getAnnounceTo());
            }
            if (!mgmtObj.getAnnouncedAttribute().isEmpty()) {
                mgmtObjEntity.getAnnouncedAttribute().clear();
                mgmtObjEntity.getAnnouncedAttribute().addAll(mgmtObj.getAnnouncedAttribute());
                modifiedMgmtObj.getAnnouncedAttribute().addAll(mgmtObj.getAnnouncedAttribute());
            }
            if (mgmtObj.getMgmtDefinition() != null && !mgmtObjEntity.getMgmtDefinition().equals(mgmtObj.getMgmtDefinition())) {
                throw new BadRequestException("unable to change the mgmtDefinition value");
            }
        }
        mgmtObjEntity.setLastModifiedTime(Util.DateUtil.now());
        modifiedMgmtObj.setLastModifiedTime(mgmtObjEntity.getLastModifiedTime());
        response.setContent((Object)modifiedMgmtObj);
        this.dbs.getDAOFactory().getMgmtObjDAO().update(this.transaction, (Object)mgmtObjEntity);
        this.transaction.commit();
        Notifier.notify(mgmtObjEntity.getSubscriptions(), (ResourceEntity)mgmtObjEntity, (Resource)modifiedMgmtObj, 3);
        response.setResponseStatusCode(ResponseStatusCode.UPDATED);
        return response;
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        ResponsePrimitive response = new ResponsePrimitive(request);
        MgmtObjEntity mgmtObjEntity = (MgmtObjEntity)this.dbs.getDAOFactory().getMgmtObjDAO().find(this.transaction, (Object)request.getTo());
        if (mgmtObjEntity == null) {
            throw new ResourceNotFoundException("Resource not found");
        }
        this.transaction.lock((Object)mgmtObjEntity);
        this.checkPermissions(request, (ResourceEntity)mgmtObjEntity, mgmtObjEntity.getAccessControlPolicies());
        UriMapper.deleteUri(mgmtObjEntity.getHierarchicalURI());
        Notifier.notifyDeletion(mgmtObjEntity.getSubscriptions(), (ResourceEntity)mgmtObjEntity);
        this.dbs.getDAOFactory().getMgmtObjDAO().delete(this.transaction, (Object)mgmtObjEntity);
        this.transaction.commit();
        if (!mgmtObjEntity.getAnnounceTo().isEmpty()) {
            Announcer.deAnnounce((AnnounceableSubordinateEntity)mgmtObjEntity, Constants.ADMIN_REQUESTING_ENTITY);
        }
        response.setResponseStatusCode(ResponseStatusCode.DELETED);
        return response;
    }
}

