/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.resource.AggregatedResponse;
import org.eclipse.om2m.commons.resource.PrimitiveContent;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.router.Router;
import org.eclipse.om2m.core.thread.CoreExecutor;

public class FanOutPointController
extends Controller {
    private String foptSuffix;

    public FanOutPointController() {
    }

    public FanOutPointController(String foptSuffix) {
        this.foptSuffix = foptSuffix;
    }

    protected ResponsePrimitive fanOutRequest(RequestPrimitive request) {
        String targetGroup = request.getTargetId();
        AggregatedResponse aggResp = new AggregatedResponse();
        ResponsePrimitive resp = new ResponsePrimitive(request);
        ArrayList<Future<ResponsePrimitive>> listOfResponse = new ArrayList<Future<ResponsePrimitive>>();
        GroupEntity group = (GroupEntity)this.dbs.getDAOFactory().getGroupDAO().find(this.transaction, (Object)targetGroup);
        List acpList = group.getAccessControlPolicies();
        this.checkACP(acpList, request.getFrom(), request.getOperation());
        for (String string : group.getMemberIDs()) {
            RequestPrimitive fanRequest = request.cloneParameters();
            LOGGER.info((Object)("Suffix in FanOutController " + this.foptSuffix));
            if (this.foptSuffix != null) {
                fanRequest.setTo(String.valueOf(string) + this.foptSuffix);
            } else {
                fanRequest.setTo(string);
            }
            LOGGER.info((Object)fanRequest.getTo());
            fanRequest.setReturnContentType("application/obj");
            listOfResponse.add(CoreExecutor.submit(new FanOutWorker(fanRequest)));
        }
        for (Future future : listOfResponse) {
            try {
                aggResp.getResponsePrimitive().add((ResponsePrimitive)future.get());
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error((Object)"FanOutCallable exception", (Throwable)e);
                ResponsePrimitive responsePrimitive = new ResponsePrimitive();
                PrimitiveContent content = new PrimitiveContent();
                content.getAny().add(e.getMessage());
                responsePrimitive.setContent((Object)content);
                responsePrimitive.setResponseStatusCode(ResponseStatusCode.INTERNAL_SERVER_ERROR);
            }
        }
        resp.setResponseStatusCode(ResponseStatusCode.OK);
        resp.setContent((Object)aggResp);
        return resp;
    }

    @Override
    public ResponsePrimitive doCreate(RequestPrimitive request) {
        return this.fanOutRequest(request);
    }

    @Override
    public ResponsePrimitive doRetrieve(RequestPrimitive request) {
        return this.fanOutRequest(request);
    }

    @Override
    public ResponsePrimitive doUpdate(RequestPrimitive request) {
        return this.fanOutRequest(request);
    }

    @Override
    public ResponsePrimitive doDelete(RequestPrimitive request) {
        return this.fanOutRequest(request);
    }

    private static class FanOutWorker
    implements Callable<ResponsePrimitive> {
        private RequestPrimitive request;

        public FanOutWorker(RequestPrimitive request) {
            this.request = request;
        }

        @Override
        public ResponsePrimitive call() throws Exception {
            ResponsePrimitive resp = new Router().doRequest(this.request);
            resp.setPrimitiveContent(new PrimitiveContent());
            resp.getPritimitiveContent().getAny().add(resp.getContent());
            return resp;
        }
    }
}

