/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContentInstanceEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Entity(name="CNT")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class ContainerEntity
extends AnnounceableSubordinateEntity {
    @Column(name="st")
    protected BigInteger stateTag;
    @Column(name="cr")
    protected String creator;
    @Column(name="mni")
    protected BigInteger maxNrOfInstances;
    @Column(name="mbs")
    protected BigInteger maxByteSize;
    @Column(name="mia")
    protected BigInteger maxInstanceAge;
    @Column(name="li")
    protected String locationID;
    @Column(name="or")
    protected String ontologyRef;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinTable(name="CNT_SUB_JOIN", joinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> subscriptions;
    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="CNT_ACP_JOIN", joinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> accessControlPolicies;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="CNT_CHCNT", joinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CNTCH_ID", referencedColumnName="ri")})
    protected List<ContainerEntity> childContainers;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="CNT_CIN_JOIN", joinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CINCH_ID", referencedColumnName="ri")})
    @OrderBy(value="creationTime")
    protected List<ContentInstanceEntity> childContentInstances;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=ContainerEntity.class)
    @JoinTable(name="CNT_CHCNT", inverseJoinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="CNTCH_ID", referencedColumnName="ri")})
    protected ContainerEntity parentContainer;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=AeEntity.class)
    @JoinTable(name="AE_CNT_JOIN", inverseJoinColumns={@JoinColumn(name="AE_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")})
    protected AeEntity parentAE;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=CSEBaseEntity.class)
    @JoinTable(name="CSEB_CNT_JOIN", inverseJoinColumns={@JoinColumn(name="CSEB_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")})
    protected CSEBaseEntity parentCSEB;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=RemoteCSEEntity.class)
    @JoinTable(name="CSR_CHCNT_JOIN", inverseJoinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="CNT_ID", referencedColumnName="ri")})
    protected RemoteCSEEntity parentCSR;

    public ContainerEntity getParentContainer() {
        return this.parentContainer;
    }

    public void setParentContainer(ContainerEntity parentContainer) {
        this.parentContainer = parentContainer;
    }

    public AeEntity getParentAE() {
        return this.parentAE;
    }

    public void setParentAE(AeEntity parentAE) {
        this.parentAE = parentAE;
    }

    public CSEBaseEntity getParentCSEB() {
        return this.parentCSEB;
    }

    public void setParentCSEB(CSEBaseEntity parentCSEB) {
        this.parentCSEB = parentCSEB;
    }

    public BigInteger getStateTag() {
        return this.stateTag;
    }

    public void setStateTag(BigInteger stateTag) {
        this.stateTag = stateTag;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public BigInteger getMaxNrOfInstances() {
        return this.maxNrOfInstances;
    }

    public void setMaxNrOfInstances(BigInteger maxNrOfInstances) {
        this.maxNrOfInstances = maxNrOfInstances;
    }

    public BigInteger getMaxByteSize() {
        return this.maxByteSize;
    }

    public void setMaxByteSize(BigInteger maxByteSize) {
        this.maxByteSize = maxByteSize;
    }

    public BigInteger getMaxInstanceAge() {
        return this.maxInstanceAge;
    }

    public void setMaxInstanceAge(BigInteger maxInstanceAge) {
        this.maxInstanceAge = maxInstanceAge;
    }

    public String getLocationID() {
        return this.locationID;
    }

    public void setLocationID(String locationID) {
        this.locationID = locationID;
    }

    public String getOntologyRef() {
        return this.ontologyRef;
    }

    public void setOntologyRef(String ontologyRef) {
        this.ontologyRef = ontologyRef;
    }

    public List<ContainerEntity> getChildContainers() {
        if (this.childContainers == null) {
            this.childContainers = new ArrayList<ContainerEntity>();
        }
        return this.childContainers;
    }

    public void setChildContainers(List<ContainerEntity> childContainers) {
        this.childContainers = childContainers;
    }

    public List<AccessControlPolicyEntity> getAccessControlPolicies() {
        if (this.accessControlPolicies == null) {
            this.accessControlPolicies = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.accessControlPolicies;
    }

    public void setAccessControlPolicies(List<AccessControlPolicyEntity> accessControlPolicies) {
        this.accessControlPolicies = accessControlPolicies;
    }

    public List<ContentInstanceEntity> getChildContentInstances() {
        if (this.childContentInstances == null) {
            this.childContentInstances = new ArrayList<ContentInstanceEntity>();
        }
        return this.childContentInstances;
    }

    public void setChildContentInstances(List<ContentInstanceEntity> childContentInstances) {
        this.childContentInstances = childContentInstances;
    }

    public RemoteCSEEntity getParentCSR() {
        return this.parentCSR;
    }

    public void setParentCSR(RemoteCSEEntity parentCSR) {
        this.parentCSR = parentCSR;
    }

    public List<SubscriptionEntity> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<SubscriptionEntity>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(List<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public int getCurrentByteSize() {
        int result = 0;
        for (ContentInstanceEntity cin : this.getChildContentInstances()) {
            result += cin.getByteSize();
        }
        return result;
    }
}

