/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.commands;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandsTracker {
    private Set<String> commandNames = Collections.synchronizedSet(new HashSet());
    private ServiceTracker<Object, Set<String>> commandsTracker = null;
    private static final Object lock = new Object();

    public CommandsTracker(BundleContext bundleContext) {
        try {
            Filter filter = bundleContext.createFilter(String.format("(&(%s=*)(%s=*))", "osgi.command.scope", "osgi.command.function"));
            this.commandsTracker = new ServiceTracker(bundleContext, filter, (ServiceTrackerCustomizer)new CommandsTrackerCustomizer());
            this.commandsTracker.open();
        }
        catch (InvalidSyntaxException invalidSyntaxException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getCommands() {
        Object object = lock;
        synchronized (object) {
            return new HashSet<String>(this.commandNames);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CommandsTrackerCustomizer
    implements ServiceTrackerCustomizer<Object, Set<String>> {
        CommandsTrackerCustomizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> addingService(ServiceReference<Object> reference) {
            Object scope = reference.getProperty("osgi.command.scope");
            Object function = reference.getProperty("osgi.command.function");
            if (scope != null && function != null) {
                Object object = lock;
                synchronized (object) {
                    if (function.getClass().isArray()) {
                        Object[] objectArray = (Object[])function;
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object func = objectArray[n2];
                            CommandsTracker.this.commandNames.add(String.valueOf(scope.toString()) + ":" + func.toString());
                            ++n2;
                        }
                    } else {
                        CommandsTracker.this.commandNames.add(String.valueOf(scope.toString()) + ":" + function.toString());
                    }
                    return CommandsTracker.this.commandNames;
                }
            }
            return null;
        }

        public void modifiedService(ServiceReference<Object> reference, Set<String> commandNames) {
        }

        public void removedService(ServiceReference<Object> reference, Set<String> commandNames) {
            Object scope = reference.getProperty("osgi.command.scope");
            Object function = reference.getProperty("osgi.command.function");
            if (scope != null && function != null) {
                if (!function.getClass().isArray()) {
                    commandNames.remove(String.valueOf(scope.toString()) + ":" + function.toString());
                } else {
                    Object[] objectArray = (Object[])function;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object func = objectArray[n2];
                        commandNames.remove(String.valueOf(scope.toString()) + ":" + func.toString());
                        ++n2;
                    }
                }
            }
        }
    }
}

