/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sample.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.ipe.sample.model.SampleModel;
import org.eclipse.om2m.ipe.sample.monitor.SampleMonitor;
import org.osgi.framework.FrameworkUtil;

public class GUI
extends JFrame {
    static Log LOGGER = LogFactory.getLog(GUI.class);
    private static final long serialVersionUID = 1L;
    private JPanel contentPanel;
    static ImageIcon iconLampON = new ImageIcon(FrameworkUtil.getBundle(GUI.class).getResource("images/Lamp_ON.png"));
    static ImageIcon iconLampOFF = new ImageIcon(FrameworkUtil.getBundle(GUI.class).getResource("images/Lamp_OFF.png"));
    static ImageIcon iconButtonON = new ImageIcon(FrameworkUtil.getBundle(GUI.class).getResource("images/Btn_ON.png"));
    static ImageIcon iconButtonOFF = new ImageIcon(FrameworkUtil.getBundle(GUI.class).getResource("images/Btn_OFF.png"));
    static GUI frame;
    static JLabel LABEL_LAMP_0;
    static JLabel LABEL_LAMP_1;
    static String LAMP_0;
    static String LAMP_1;
    static SampleModel.LampObserver lampObserver;

    static {
        LABEL_LAMP_0 = new JLabel("");
        LABEL_LAMP_1 = new JLabel("");
        LAMP_0 = "LAMP_0";
        LAMP_1 = "LAMP_1";
    }

    public static void init() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    frame = new GUI();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"GUI init Error", (Throwable)e);
                }
            }
        });
    }

    public static void stop() {
        SampleModel.deleteObserver(lampObserver);
        frame.setVisible(false);
        frame.dispose();
    }

    public GUI() {
        this.setLocationByPlatform(true);
        this.setVisible(false);
        this.setResizable(false);
        this.setTitle("Sample Simulated IPE");
        this.setDefaultCloseOperation(0);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 500) / 2, (screenSize.height - 570) / 2, 497, 570);
        this.contentPanel = new JPanel();
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPanel);
        this.contentPanel.setLayout(null);
        JPanel panel_Lamp0 = new JPanel();
        panel_Lamp0.setBounds(10, 5, 319, 260);
        this.contentPanel.add(panel_Lamp0);
        panel_Lamp0.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        panel_Lamp0.setLayout(null);
        LABEL_LAMP_0.setIcon(iconLampOFF);
        LABEL_LAMP_0.setHorizontalTextPosition(0);
        LABEL_LAMP_0.setHorizontalAlignment(0);
        LABEL_LAMP_0.setBounds(10, 9, 149, 240);
        panel_Lamp0.add(LABEL_LAMP_0);
        JButton button_Lamp0 = new JButton();
        button_Lamp0.setOpaque(false);
        button_Lamp0.setPressedIcon(iconButtonON);
        button_Lamp0.setIcon(iconButtonOFF);
        button_Lamp0.setBounds(187, 44, 122, 155);
        panel_Lamp0.add(button_Lamp0);
        button_Lamp0.setMinimumSize(new Dimension(30, 23));
        button_Lamp0.setMaximumSize(new Dimension(30, 23));
        button_Lamp0.setPreferredSize(new Dimension(30, 23));
        JLabel labelSwitcher0 = new JLabel("Switch LAMP_0");
        labelSwitcher0.setFont(new Font("Vani", 3, 14));
        labelSwitcher0.setFocusCycleRoot(true);
        labelSwitcher0.setBorder(null);
        labelSwitcher0.setAutoscrolls(true);
        labelSwitcher0.setBounds(187, 199, 118, 29);
        panel_Lamp0.add(labelSwitcher0);
        button_Lamp0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new Thread(){

                    @Override
                    public void run() {
                        SampleMonitor.switchLamp(LAMP_0);
                    }
                }.start();
            }
        });
        JPanel panel_Lamp1 = new JPanel();
        panel_Lamp1.setBounds(10, 271, 319, 260);
        this.contentPanel.add(panel_Lamp1);
        panel_Lamp1.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        panel_Lamp1.setLayout(null);
        LABEL_LAMP_1.setIcon(iconLampOFF);
        LABEL_LAMP_1.setHorizontalTextPosition(0);
        LABEL_LAMP_1.setHorizontalAlignment(0);
        LABEL_LAMP_1.setBounds(10, 9, 154, 240);
        panel_Lamp1.add(LABEL_LAMP_1);
        JButton button_Lamp1 = new JButton();
        button_Lamp1.setOpaque(false);
        button_Lamp1.setPressedIcon(iconButtonON);
        button_Lamp1.setIcon(iconButtonOFF);
        button_Lamp1.setBounds(187, 44, 122, 156);
        panel_Lamp1.add(button_Lamp1);
        button_Lamp1.setMinimumSize(new Dimension(30, 23));
        button_Lamp1.setMaximumSize(new Dimension(30, 23));
        button_Lamp1.setPreferredSize(new Dimension(30, 23));
        JLabel labelSwitcher1 = new JLabel("Switch LAMP_1");
        labelSwitcher1.setFont(new Font("Vani", 3, 14));
        labelSwitcher1.setFocusCycleRoot(true);
        labelSwitcher1.setBorder(null);
        labelSwitcher1.setAutoscrolls(true);
        labelSwitcher1.setBounds(187, 199, 118, 29);
        panel_Lamp1.add(labelSwitcher1);
        button_Lamp1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new Thread(){

                    @Override
                    public void run() {
                        SampleMonitor.switchLamp(LAMP_1);
                    }
                }.start();
            }
        });
        JButton buttonAllLamp = new JButton();
        buttonAllLamp.setOpaque(false);
        buttonAllLamp.setPressedIcon(iconButtonON);
        buttonAllLamp.setIcon(iconButtonOFF);
        buttonAllLamp.setBounds(339, 190, 145, 168);
        this.contentPanel.add(buttonAllLamp);
        buttonAllLamp.setMinimumSize(new Dimension(30, 23));
        buttonAllLamp.setMaximumSize(new Dimension(30, 23));
        buttonAllLamp.setPreferredSize(new Dimension(30, 23));
        JLabel labelSwitchAll = new JLabel("Switch All");
        labelSwitchAll.setAutoscrolls(true);
        labelSwitchAll.setFont(new Font("Vani", 3, 14));
        labelSwitchAll.setFocusCycleRoot(true);
        labelSwitchAll.setBorder(null);
        labelSwitchAll.setBounds(371, 369, 85, 29);
        this.contentPanel.add(labelSwitchAll);
        buttonAllLamp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                new Thread(){

                    @Override
                    public void run() {
                        SampleMonitor.switchAll();
                    }
                }.start();
            }
        });
        lampObserver = new SampleModel.LampObserver(){

            @Override
            public void onLampStateChange(String lampId, boolean state) {
                GUI.setLabel(lampId, state);
            }
        };
        SampleModel.addObserver(lampObserver);
    }

    public static void setLabel(String appId, boolean newState) {
        JLabel label = new JLabel("");
        if ("LABEL_LAMP_0".endsWith(appId)) {
            label = LABEL_LAMP_0;
        }
        if ("LABEL_LAMP_1".endsWith(appId)) {
            label = LABEL_LAMP_1;
        }
        if (newState) {
            label.setIcon(iconLampON);
        } else {
            label.setIcon(iconLampOFF);
        }
    }
}

