/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.BadRequestException;
import org.eclipse.om2m.commons.exceptions.NotPermittedAttrException;
import org.eclipse.om2m.commons.exceptions.Om2mException;
import org.eclipse.om2m.commons.exceptions.ResourceNotFoundException;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.utils.Util;
import org.eclipse.om2m.core.persistence.PersistenceService;
import org.eclipse.om2m.core.urimapper.UriMapper;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class ControllerUtil {
    private ControllerUtil() {
    }

    public static List<AccessControlPolicyEntity> buildAcpEntityList(List<String> acpUriList, DBTransaction transaction) throws ResourceNotFoundException {
        DBService dbs = PersistenceService.getInstance().getDbService();
        ArrayList<AccessControlPolicyEntity> response = new ArrayList<AccessControlPolicyEntity>();
        for (String acpId : acpUriList) {
            String dbId = UriMapper.getNonHierarchicalUri(acpId);
            if (dbId == null) {
                throw new ResourceNotFoundException("AccessControlPolicy Id [" + acpId + "] is not found");
            }
            AccessControlPolicyEntity acpEntity = (AccessControlPolicyEntity)dbs.getDAOFactory().getAccessControlPolicyDAO().find(transaction, (Object)dbId);
            if (acpEntity == null) {
                throw new Om2mException("AccessControlPolicy Id [" + acpId + "] is not found", ResponseStatusCode.BAD_REQUEST);
            }
            response.add(acpEntity);
        }
        return response;
    }

    public static class CreateUtil {
        private CreateUtil() {
        }

        public static void fillEntityFromGenericResource(Resource resource, ResourceEntity entity) throws NotPermittedAttrException {
            if (resource.getResourceType() != null) {
                throw new NotPermittedAttrException("ResourceType is Not Permitted");
            }
            if (resource.getResourceID() != null) {
                throw new NotPermittedAttrException("ResourceID is Not Permitted");
            }
            if (resource.getParentID() != null) {
                throw new NotPermittedAttrException("ParentID is Not Permitted");
            }
            if (resource.getCreationTime() != null) {
                throw new NotPermittedAttrException("Creation time is Not Permitted");
            }
            entity.setCreationTime(Util.DateUtil.now());
            if (resource.getLastModifiedTime() != null) {
                throw new NotPermittedAttrException("LastTimeModified is Not Permitted");
            }
            entity.setLastModifiedTime(Util.DateUtil.now());
            if (!resource.getLabels().isEmpty()) {
                entity.setLabelsEntitiesFromSring(resource.getLabels());
            }
        }

        public static void fillEntityFromAnnounceableResource(AnnounceableResource resource, AnnounceableSubordinateEntity entity) throws NotPermittedAttrException {
            CreateUtil.fillEntityFromGenericResource((Resource)resource, (ResourceEntity)entity);
            if (!resource.getAnnouncedAttribute().isEmpty()) {
                entity.getAnnouncedAttribute().addAll(resource.getAnnouncedAttribute());
            }
            if (!resource.getAnnounceTo().isEmpty()) {
                entity.getAnnounceTo().addAll(resource.getAnnounceTo());
            }
            if (resource.getExpirationTime() != null) {
                entity.setExpirationTime(resource.getExpirationTime());
            } else {
                entity.setExpirationTime(Util.DateUtil.getDefaultExpirationTime());
            }
        }
    }

    public static class UpdateUtil {
        private UpdateUtil() {
        }

        public static void checkNotPermittedParameters(Resource resource) {
            if (resource.getName() != null) {
                throw new BadRequestException("ResourceName is NP");
            }
            if (resource.getResourceType() != null) {
                throw new BadRequestException("ResourceType is NP");
            }
            if (resource.getResourceID() != null) {
                throw new BadRequestException("ResourceID is NP");
            }
            if (resource.getParentID() != null) {
                throw new BadRequestException("ParentID is NP");
            }
            if (resource.getCreationTime() != null) {
                throw new BadRequestException("CreationTime is NP");
            }
            if (resource.getLastModifiedTime() != null) {
                throw new BadRequestException("LastModifiedTime is NP");
            }
        }
    }
}

