/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.rename;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.style.editor.AbstractStyleEditorDialog;
import org.eclipse.nebula.widgets.nattable.ui.rename.HeaderLabelPanel;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HeaderRenameDialog
extends AbstractStyleEditorDialog {
    private static final Log LOG = LogFactory.getLog(HeaderRenameDialog.class);
    private final String originalLabel;
    private String renamedLabel;
    private final RenameDialogLabels dialogLabels;
    private HeaderLabelPanel headerLabelPanel;

    public HeaderRenameDialog(Shell parent, String originalLabel, String renamedLabel, RenameDialogLabels dialogLabels) {
        super(parent);
        this.originalLabel = originalLabel;
        this.renamedLabel = renamedLabel;
        this.dialogLabels = dialogLabels;
    }

    @Override
    protected void initComponents(final Shell shell) {
        GridLayout shellLayout = new GridLayout();
        shell.setLayout((Layout)shellLayout);
        shell.setText(this.dialogLabels.shellTitle);
        shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                HeaderRenameDialog.this.doFormCancel(shell);
            }
        });
        Composite panel = new Composite((Composite)shell, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData fillGridData = new GridData();
        fillGridData.grabExcessHorizontalSpace = true;
        fillGridData.horizontalAlignment = 4;
        panel.setLayoutData((Object)fillGridData);
        this.headerLabelPanel = new HeaderLabelPanel(panel, this.originalLabel, this.renamedLabel, this.dialogLabels);
        try {
            this.headerLabelPanel.edit(this.renamedLabel);
        }
        catch (Exception e) {
            LOG.warn((Object)e);
        }
    }

    @Override
    protected void doFormOK(Shell shell) {
        this.renamedLabel = this.headerLabelPanel.getNewValue();
        shell.dispose();
    }

    @Override
    protected void doFormClear(Shell shell) {
        this.renamedLabel = null;
        shell.dispose();
    }

    public String getNewLabel() {
        return this.renamedLabel;
    }

    public static enum RenameDialogLabels {
        COLUMN_RENAME(Messages.getString("ColumnGroups.renameColumnGroup"), Messages.getString("ColumnLabel.editorName")){}
        ,
        ROW_RENAME(Messages.getString("RowGroups.renameRowGroup"), Messages.getString("RowRenameDialog.editorName")){};

        public final String shellTitle;
        public final String editorName;

        private RenameDialogLabels(String shellTitle, String editorName) {
            this.shellTitle = shellTitle;
            this.editorName = editorName;
        }
    }
}

