/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.strategy;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.search.strategy.GridSearchStrategy;

public class CellDisplayValueSearchUtil {
    static List<PositionCoordinate> getCellCoordinates(ILayer contextLayer, int startingColumnPosition, int startingRowPosition, int width, int height) {
        ArrayList<PositionCoordinate> coordinates = new ArrayList<PositionCoordinate>(width * height);
        int columnPosition = 0;
        while (columnPosition < width) {
            int rowPosition = 0;
            while (rowPosition < height) {
                PositionCoordinate coordinate = new PositionCoordinate(contextLayer, startingColumnPosition, startingRowPosition++);
                coordinates.add(coordinate);
                ++rowPosition;
            }
            ++startingColumnPosition;
            ++columnPosition;
        }
        return coordinates;
    }

    static List<PositionCoordinate> getDescendingCellCoordinates(ILayer contextLayer, int startingColumnPosition, int startingRowPosition, int width, int height) {
        ArrayList<PositionCoordinate> coordinates = new ArrayList<PositionCoordinate>(width * height);
        int columnPosition = width;
        while (columnPosition >= 0 && startingColumnPosition >= 0) {
            int rowPosition = height;
            while (rowPosition >= 0 && startingRowPosition >= 0) {
                PositionCoordinate coordinate = new PositionCoordinate(contextLayer, startingColumnPosition, startingRowPosition--);
                coordinates.add(coordinate);
                --rowPosition;
            }
            --startingColumnPosition;
            --columnPosition;
        }
        return coordinates;
    }

    static List<PositionCoordinate> getCellCoordinatesRowFirst(ILayer contextLayer, int startingColumnPosition, int startingRowPosition, int width, int height) {
        ArrayList<PositionCoordinate> coordinates = new ArrayList<PositionCoordinate>(width * height);
        int rowPosition = 0;
        while (rowPosition < height) {
            int columnPosition = 0;
            while (columnPosition < width) {
                PositionCoordinate coordinate = new PositionCoordinate(contextLayer, startingColumnPosition++, startingRowPosition);
                coordinates.add(coordinate);
                ++columnPosition;
            }
            ++startingRowPosition;
            ++rowPosition;
        }
        return coordinates;
    }

    static List<PositionCoordinate> getDescendingCellCoordinatesRowFirst(ILayer contextLayer, int startingColumnPosition, int startingRowPosition, int width, int height) {
        ArrayList<PositionCoordinate> coordinates = new ArrayList<PositionCoordinate>(width * height);
        int rowPosition = height;
        while (rowPosition >= 0 && startingRowPosition >= 0) {
            int columnPosition = width;
            while (columnPosition >= 0 && startingColumnPosition >= 0) {
                PositionCoordinate coordinate = new PositionCoordinate(contextLayer, startingColumnPosition--, startingRowPosition);
                coordinates.add(coordinate);
                --columnPosition;
            }
            --startingRowPosition;
            --rowPosition;
        }
        return coordinates;
    }

    static PositionCoordinate findCell(ILayer layer, IConfigRegistry configRegistry, PositionCoordinate[] cellsToSearch, Object valueToMatch, Comparator<String> comparator, boolean caseSensitive, boolean wholeWord, boolean regex, boolean includeCollapsed) throws PatternSyntaxException {
        String stringValue = caseSensitive ? valueToMatch.toString() : valueToMatch.toString().toLowerCase();
        Pattern pattern = regex ? Pattern.compile(stringValue) : null;
        int cellIndex = 0;
        while (cellIndex < cellsToSearch.length) {
            PositionCoordinate cellCoordinate = cellsToSearch[cellIndex];
            if (CellDisplayValueSearchUtil.compare(layer, configRegistry, pattern, stringValue, comparator, caseSensitive, wholeWord, regex, cellCoordinate.columnPosition, cellCoordinate.rowPosition)) {
                return cellCoordinate;
            }
            ++cellIndex;
        }
        return null;
    }

    static PositionCoordinate findCell(ILayer layer, IConfigRegistry configRegistry, List<GridSearchStrategy.GridRectangle> cellRectangles, Object valueToMatch, Comparator<String> comparator, boolean caseSensitive, boolean wholeWord, boolean regex, boolean columnFirst, boolean includeCollapsed) throws PatternSyntaxException {
        String stringValue = caseSensitive ? valueToMatch.toString() : valueToMatch.toString().toLowerCase();
        Pattern pattern = regex ? Pattern.compile(stringValue) : null;
        for (GridSearchStrategy.GridRectangle cellRectangle : cellRectangles) {
            int direction = cellRectangle.firstDim.size() > 0 || cellRectangle.secondDim.size() > 0 ? 1 : -1;
            int i = cellRectangle.firstDim.start;
            while (Math.abs(cellRectangle.firstDim.end - i) > 0) {
                PositionCoordinate result = CellDisplayValueSearchUtil.findCell(layer, configRegistry, i, cellRectangle.secondDim.start, cellRectangle.secondDim.end, direction, pattern, stringValue, comparator, caseSensitive, wholeWord, regex, columnFirst, includeCollapsed);
                if (result != null) {
                    return result;
                }
                i += direction;
            }
        }
        return null;
    }

    private static PositionCoordinate findCell(ILayer layer, IConfigRegistry configRegistry, int firstDimIndex, int secondDimStart, int secondDimEnd, int direction, Pattern pattern, String stringValue, Comparator<String> comparator, boolean caseSensitive, boolean wholeWord, boolean regex, boolean columnFirst, boolean includeCollapsed) throws PatternSyntaxException {
        int rowPosition;
        int columnPosition;
        if (columnFirst) {
            columnPosition = firstDimIndex;
            rowPosition = secondDimStart;
        } else {
            columnPosition = secondDimStart;
            rowPosition = firstDimIndex;
        }
        int i = secondDimStart;
        while (direction * (secondDimEnd - i) > 0) {
            ILayerCell cellByPosition = layer.getCellByPosition(columnPosition, rowPosition);
            if (direction >= 0 || cellByPosition.getOriginColumnPosition() == cellByPosition.getColumnPosition() && cellByPosition.getOriginRowPosition() == cellByPosition.getRowPosition()) {
                PositionCoordinate searchAnchor = CellDisplayValueSearchUtil.getSearchAnchor(cellByPosition, direction);
                if (searchAnchor.columnPosition == columnPosition && searchAnchor.rowPosition == rowPosition && CellDisplayValueSearchUtil.compare(layer, configRegistry, pattern, stringValue, comparator, caseSensitive, wholeWord, regex, columnPosition, rowPosition)) {
                    return new PositionCoordinate(layer, columnPosition, rowPosition);
                }
            }
            if (columnFirst) {
                rowPosition += direction;
            } else {
                columnPosition += direction;
            }
            i += direction;
        }
        return null;
    }

    private static PositionCoordinate getSearchAnchor(ILayerCell cell, int direction) {
        return new PositionCoordinate(cell.getLayer(), cell.getOriginColumnPosition(), cell.getOriginRowPosition());
    }

    private static boolean compare(ILayer layer, IConfigRegistry configRegistry, Pattern pattern, String stringValue, Comparator<String> comparator, boolean caseSensitive, boolean wholeWord, boolean regex, int columnPosition, int rowPosition) {
        LabelStack labels = layer.getConfigLabelsByPosition(columnPosition, rowPosition);
        if (!labels.hasLabel("SKIP_SEARCH_RESULT")) {
            ILayerCell cell;
            IDisplayConverter displayConverter = configRegistry.getConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, "NORMAL", labels.getLabels());
            Object dataValue = null;
            if (displayConverter != null && (cell = layer.getCellByPosition(columnPosition, rowPosition)) != null) {
                dataValue = displayConverter.canonicalToDisplayValue(cell, configRegistry, cell.getDataValue());
            }
            if (dataValue instanceof Comparable) {
                String dataValueString;
                String string = dataValueString = caseSensitive ? dataValue.toString() : dataValue.toString().toLowerCase();
                if (regex) {
                    if (pattern.matcher(dataValueString).matches()) {
                        return true;
                    }
                } else {
                    if (comparator.compare(stringValue, dataValueString) == 0) {
                        return true;
                    }
                    if (!wholeWord && dataValueString.contains(stringValue)) {
                        return true;
                    }
                    if (wholeWord) {
                        String[] split;
                        String[] stringArray = split = dataValueString.split("\\b");
                        int n = split.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String word = stringArray[n2];
                            if (comparator.compare(stringValue, word) == 0) {
                                return true;
                            }
                            ++n2;
                        }
                    }
                }
            }
        }
        return false;
    }
}

