/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit.command;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.event.DataUpdateEvent;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;

public class UpdateDataCommandHandler
extends AbstractLayerCommandHandler<UpdateDataCommand> {
    private static final Log LOG = LogFactory.getLog(UpdateDataCommandHandler.class);
    private final DataLayer dataLayer;
    private final boolean performEqualsCheck;

    public UpdateDataCommandHandler(DataLayer dataLayer) {
        this(dataLayer, true);
    }

    public UpdateDataCommandHandler(DataLayer dataLayer, boolean performEqualsCheck) {
        this.dataLayer = dataLayer;
        this.performEqualsCheck = performEqualsCheck;
    }

    @Override
    public Class<UpdateDataCommand> getCommandClass() {
        return UpdateDataCommand.class;
    }

    @Override
    protected boolean doCommand(UpdateDataCommand command) {
        try {
            int columnPosition = command.getColumnPosition();
            int rowPosition = command.getRowPosition();
            Object currentValue = this.dataLayer.getDataValueByPosition(columnPosition, rowPosition);
            if (!this.performEqualsCheck || currentValue == null && command.getNewValue() != null || command.getNewValue() == null && currentValue != null || currentValue != null && command.getNewValue() != null && !currentValue.equals(command.getNewValue())) {
                this.dataLayer.setDataValueByPosition(columnPosition, rowPosition, command.getNewValue());
                this.dataLayer.fireLayerEvent(new DataUpdateEvent(this.dataLayer, columnPosition, rowPosition, currentValue, command.getNewValue()));
            }
            return true;
        }
        catch (Exception e) {
            LOG.error((Object)("Failed to update value to: " + command.getNewValue()), (Throwable)e);
            return false;
        }
    }
}

