/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.runner;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class NavContentProvider
implements ITreeContentProvider {
    private Map<String, Collection<String>> pathToChildrenMap;

    private Collection<String> getChildren(String parentPath) {
        Collection<String> children = this.pathToChildrenMap.get(parentPath);
        if (children == null) {
            children = new LinkedHashSet<String>();
            this.pathToChildrenMap.put(parentPath, children);
        }
        return children;
    }

    public void dispose() {
        this.pathToChildrenMap = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.pathToChildrenMap = new HashMap<String, Collection<String>>();
    }

    public Object[] getChildren(Object parent) {
        return this.pathToChildrenMap.get(parent).toArray();
    }

    public Object getParent(Object element) {
        String str = (String)element;
        int lastSlashIndex = str.lastIndexOf(47);
        if (lastSlashIndex < 0) {
            return null;
        }
        return str.substring(0, lastSlashIndex);
    }

    public boolean hasChildren(Object element) {
        return this.pathToChildrenMap.get(element) != null;
    }

    public Object[] getElements(Object inputElement) {
        String[] examplePaths;
        LinkedHashSet<String> topLevelElements = new LinkedHashSet<String>();
        String[] stringArray = examplePaths = (String[])inputElement;
        int n = examplePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String examplePath = stringArray[n2];
            String parentPath = "";
            String absolutePath = "";
            String path = examplePath;
            if (examplePath.startsWith("Tutorial Examples/")) {
                path = examplePath.replace("/org/eclipse/nebula/widgets/nattable/examples", "");
            } else if (examplePath.startsWith("Classic Examples/")) {
                path = examplePath.replace("/org/eclipse/nebula/widgets/nattable/examples/examples", "");
            }
            StringTokenizer tok = new StringTokenizer(path, "/");
            while (tok.hasMoreTokens()) {
                String pathElement = tok.nextToken();
                if (parentPath.length() == 0) {
                    topLevelElements.add("/" + pathElement);
                }
                absolutePath = String.valueOf(absolutePath) + "/" + pathElement;
                Collection<String> children = this.getChildren(parentPath);
                children.add(absolutePath);
                parentPath = absolutePath;
            }
            ++n2;
        }
        return topLevelElements.toArray();
    }
}

