/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._100_Layers._101_Header;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.columnChooser.command.DisplayColumnChooserCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.PricingTypeBean;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.RowDataListFixture;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.PricingTypeBeanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.export.ExportConfigAttributes;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.extension.poi.HSSFExcelExporter;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.stack.ColumnGroupBodyLayerStack;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DynamicColumnHeaderHeightExample
extends AbstractNatExample {
    private final ColumnGroupModel columnGroupModel = new ColumnGroupModel();
    private ColumnHeaderLayer columnHeaderLayer;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new DynamicColumnHeaderHeightExample());
    }

    @Override
    public String getDescription() {
        return "This example demonstrates dynamic column header height configuration.\nIt uses column grouping and filter row which are are related for height calculation.\n\nFollowing functions will change the column header height:\n* GROUP SELECTED COLUMNS with ctrl-g or popup menu.\n* UNGROUP SELECTED COLUMNS with ctrl-u or popup menu until no column group is available.\n* Press button to enable/disable the filter row.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        ConfigRegistry configRegistry = new ConfigRegistry();
        EventList eventList = GlazedLists.eventList((Collection)RowDataListFixture.getList((int)200));
        FilterList filterList = new FilterList(eventList);
        String[] propertyNames = RowDataListFixture.getPropertyNames();
        Map propertyToLabelMap = RowDataListFixture.getPropertyToLabelMap();
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider bodyDataProvider = new ListDataProvider((List)filterList, (IColumnAccessor)columnPropertyAccessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        ColumnGroupBodyLayerStack bodyLayer = new ColumnGroupBodyLayerStack((IUniqueIndexLayer)bodyDataLayer, new ColumnGroupModel[]{this.columnGroupModel});
        ColumnOverrideLabelAccumulator bodyLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)bodyLabelAccumulator);
        bodyLabelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"pricing_type"), new String[]{"PRICING_TYPE_PROP_NAME"});
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        this.columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)bodyLayer, bodyLayer.getSelectionLayer());
        ColumnGroupHeaderLayer columnGroupHeaderLayer = new ColumnGroupHeaderLayer((ILayer)this.columnHeaderLayer, bodyLayer.getSelectionLayer(), this.columnGroupModel);
        columnGroupHeaderLayer.addColumnsIndexesToGroup("Group 1", new int[]{1, 2});
        columnGroupHeaderLayer.setCalculateHeight(true);
        final FilterRowHeaderComposite filterRowHeaderLayer = new FilterRowHeaderComposite((IFilterStrategy)new DefaultGlazedListsFilterStrategy(filterList, (IColumnAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry), (ILayer)columnGroupHeaderLayer, (IDataProvider)columnHeaderDataProvider, (IConfigRegistry)configRegistry);
        filterRowHeaderLayer.setFilterRowVisible(false);
        ColumnOverrideLabelAccumulator labelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)columnHeaderDataLayer);
        columnHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)labelAccumulator);
        labelAccumulator.registerColumnOverrides(RowDataListFixture.getColumnIndexOfProperty((String)"rating"), new String[]{"CUSTOM_COMPARATOR_LABEL"});
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)bodyLayer, bodyLayer.getSelectionLayer());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)filterRowHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)bodyLayer, (ILayer)filterRowHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        DisplayColumnChooserCommandHandler columnChooserCommandHandler = new DisplayColumnChooserCommandHandler(bodyLayer.getSelectionLayer(), bodyLayer.getColumnHideShowLayer(), this.columnHeaderLayer, (DataLayer)columnHeaderDataLayer, columnGroupHeaderLayer, this.columnGroupModel);
        bodyLayer.registerCommandHandler((ILayerCommandHandler)columnChooserCommandHandler);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable){

            protected PopupMenuBuilder createColumnHeaderMenu(NatTable natTable) {
                return super.createColumnHeaderMenu(natTable).withColumnChooserMenuItem();
            }
        });
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(ExportConfigAttributes.EXPORTER, (Object)new HSSFExcelExporter());
            }
        });
        natTable.addConfiguration((IConfiguration)new FilterRowCustomConfiguration());
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.configure();
        Button button = new Button(parent, 0);
        button.setText("Switch FilterRow visibility");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                filterRowHeaderLayer.setFilterRowVisible(!filterRowHeaderLayer.isFilterRowVisible());
            }
        });
        return natTable;
    }

    private static Comparator<?> getIngnorecaseComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        };
    }

    public static class FilterRowCustomConfiguration
    extends AbstractRegistryConfiguration {
        final DefaultDoubleDisplayConverter doubleDisplayConverter = new DefaultDoubleDisplayConverter();

        public void configureRegistry(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_COMPARATOR, (Object)DynamicColumnHeaderHeightExample.getIngnorecaseComparator(), "NORMAL", "FILTER_COLUMN_2");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, (Object)this.doubleDisplayConverter, "NORMAL", "FILTER_COLUMN_5");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, (Object)TextMatchingMode.REGULAR_EXPRESSION, "NORMAL", "FILTER_COLUMN_5");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, (Object)this.doubleDisplayConverter, "NORMAL", "FILTER_COLUMN_6");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, (Object)TextMatchingMode.REGULAR_EXPRESSION, "NORMAL", "FILTER_COLUMN_6");
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new ComboBoxCellEditor(Arrays.asList(new PricingTypeBean("MN"), new PricingTypeBean("AT"))), "NORMAL", "FILTER_COLUMN_4");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, (Object)new PricingTypeBeanDisplayConverter(), "NORMAL", "FILTER_COLUMN_4");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new PricingTypeBeanDisplayConverter(), "NORMAL", "FILTER_COLUMN_4");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new PricingTypeBeanDisplayConverter(), "NORMAL", "PRICING_TYPE_PROP_NAME");
            Style rowStyle = new Style();
            rowStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.getColor((int)197, (int)212, (int)231));
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)rowStyle, "NORMAL", "FILTER_ROW");
        }
    }
}

