/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._100_Layers;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TreeList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultComparator;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.edit.CheckBoxStateEnum;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.action.CellEditDragMode;
import org.eclipse.nebula.widgets.nattable.edit.action.MouseEditAction;
import org.eclipse.nebula.widgets.nattable.edit.action.ToggleCheckBoxColumnAction;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.edit.editor.CheckBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeData;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.tree.GlazedListTreeRowModel;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.CellVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ColumnHeaderCheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TreeCheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortConfigAttributes;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.sort.painter.SortableHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.SortableTreeComparator;
import org.eclipse.nebula.widgets.nattable.tree.TreeLayer;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.CellPainterMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TreeGridWithCheckBoxFieldsExample
extends AbstractNatExample {
    protected static final String NO_SORT_LABEL = "noSortLabel";
    private Map<String, Datum> datums = new HashMap<String, Datum>();

    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(800, 400, new TreeGridWithCheckBoxFieldsExample());
    }

    @Override
    public Control createExampleControl(Composite parent) {
        ConfigRegistry configRegistry = new ConfigRegistry();
        configRegistry.registerConfigAttribute(SortConfigAttributes.SORT_COMPARATOR, (Object)DefaultComparator.getInstance());
        this.createDatums();
        EventList eventList = GlazedLists.eventList(this.datums.values());
        SortedList sortedList = new SortedList(eventList, null);
        String[] propertyNames = new String[]{"self", "bar"};
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        GlazedListsSortModel sortModel = new GlazedListsSortModel(sortedList, (IColumnPropertyAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry, (ILayer)columnHeaderDataLayer);
        TreeList treeList = new TreeList((EventList)sortedList, (TreeList.Format)new DatumTreeFormat((ISortModel)sortModel), (TreeList.ExpansionModel)new DatumExpansionModel());
        GlazedListTreeData treeData = new GlazedListTreeData(treeList);
        ListDataProvider bodyDataProvider = new ListDataProvider((List)treeList, (IColumnAccessor)columnPropertyAccessor);
        final DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        bodyDataLayer.registerCommandHandler((ILayerCommandHandler)new UpdateDataCommandHandler(bodyDataLayer){

            protected boolean doCommand(UpdateDataCommand command) {
                int columnPosition = command.getColumnPosition();
                int rowPosition = command.getRowPosition();
                if (columnPosition == 0) {
                    Datum datum = (Datum)bodyDataLayer.getDataProvider().getDataValue(columnPosition, rowPosition);
                    datum.setOn((Boolean)command.getNewValue());
                    bodyDataLayer.fireLayerEvent((ILayerEvent)new CellVisualChangeEvent((ILayer)bodyDataLayer, columnPosition, rowPosition));
                    return true;
                }
                return super.doCommand(command);
            }
        });
        ColumnReorderLayer columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)bodyDataLayer);
        ColumnHideShowLayer columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)columnReorderLayer);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)columnHideShowLayer);
        TreeLayer treeLayer = new TreeLayer((IUniqueIndexLayer)selectionLayer, (ITreeRowModel)new GlazedListTreeRowModel(treeData));
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)treeLayer);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        ColumnOverrideLabelAccumulator labelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)columnHeaderDataLayer);
        columnHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)labelAccumulator);
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)sortModel, false);
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)sortHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)sortHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        NatTable natTable = new NatTable(parent, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable));
        natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        columnHeaderDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnLabelAccumulator());
        final ColumnHeaderCheckBoxPainter columnHeaderCheckBoxPainter = new ColumnHeaderCheckBoxPainter((IUniqueIndexLayer)bodyDataLayer){

            protected Boolean convertDataType(ILayerCell cell, IConfigRegistry configRegistry) {
                Datum dataValue = (Datum)cell.getDataValue();
                return dataValue.isOn();
            }
        };
        TreeCheckBoxPainter checkBoxPainter = new TreeCheckBoxPainter(){

            protected CheckBoxStateEnum getCheckBoxState(ILayerCell cell) {
                Datum dataValue = (Datum)cell.getDataValue();
                return dataValue.getCheckBoxState();
            }
        };
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration((ICellPainter)checkBoxPainter, bodyDataLayer){
            private final /* synthetic */ ICellPainter val$checkBoxPainter;
            private final /* synthetic */ DataLayer val$bodyDataLayer;
            {
                this.val$checkBoxPainter = iCellPainter;
                this.val$bodyDataLayer = dataLayer;
            }

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new BeveledBorderDecorator((ICellPainter)new CellPainterDecorator((ICellPainter)new SortableHeaderTextPainter(), CellEdgeEnum.LEFT, (ICellPainter)columnHeaderCheckBoxPainter)), "NORMAL", "COLUMN_0");
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new BackgroundPainter((ICellPainter)new CellPainterDecorator((ICellPainter)new TextPainter(){

                    protected String convertDataType(ILayerCell cell, IConfigRegistry configRegistry) {
                        Datum dataValue = (Datum)cell.getDataValue();
                        return dataValue.getName();
                    }
                }, CellEdgeEnum.LEFT, this.val$checkBoxPainter)), "NORMAL", "TREE_COLUMN_CELL");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), "NORMAL", "TREE_COLUMN_CELL");
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE, "EDIT", "TREE_COLUMN_CELL");
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new CheckBoxCellEditor(){

                    public void setCanonicalValue(Object canonicalValue) {
                        Datum value = (Datum)canonicalValue;
                        super.setCanonicalValue((Object)value.isOn());
                    }
                }, "NORMAL", "TREE_COLUMN_CELL");
            }

            public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
                uiBindingRegistry.registerFirstSingleClickBinding((IMouseEventMatcher)new CellPainterMouseEventMatcher("COLUMN_HEADER", 1, (ICellPainter)columnHeaderCheckBoxPainter), (IMouseAction)new ToggleCheckBoxColumnAction(columnHeaderCheckBoxPainter, (IUniqueIndexLayer)this.val$bodyDataLayer));
                uiBindingRegistry.registerFirstSingleClickBinding((IMouseEventMatcher)new CellPainterMouseEventMatcher("BODY", 1, this.val$checkBoxPainter), (IMouseAction)new MouseEditAction());
                uiBindingRegistry.registerFirstMouseDragMode((IMouseEventMatcher)new CellPainterMouseEventMatcher("BODY", 1, this.val$checkBoxPainter), (IDragMode)new CellEditDragMode());
            }
        });
        natTable.configure();
        return natTable;
    }

    protected void printTree(TreeList<Datum> treeList, ITreeData<Datum> treeData) {
        System.out.println(treeList.size());
        int i = 0;
        while (i < treeList.size()) {
            Datum location = (Datum)treeList.get(i);
            int depth = treeList.depth(i);
            boolean hasChildren = treeList.hasChildren(i);
            boolean isExpanded = treeList.isExpanded(i);
            int j = 0;
            while (j < depth) {
                System.out.print("\t");
                ++j;
            }
            if (hasChildren) {
                System.out.print(isExpanded ? "- " : "+ ");
            } else {
                System.out.print("  ");
            }
            System.out.println(location.getName());
            ++i;
        }
    }

    private void createDatum(String parent, String foo, boolean fooFlag, int bar) {
        Datum datum = new Datum(this.datums.get(parent), foo, fooFlag, bar);
        this.datums.put(foo, datum);
    }

    private void createDatums() {
        this.createDatum(null, "root", false, 1);
        this.createDatum("root", "A", false, 10);
        this.createDatum("A", "A.1", false, 100);
        this.createDatum("A", "A.2", false, 110);
        this.createDatum("A", "A.3", true, 120);
        this.createDatum("root", "B", true, 20);
        this.createDatum("B", "B.1", true, 200);
        this.createDatum("B", "B.2", true, 210);
        this.createDatum("root", "C", false, 30);
        this.createDatum("C", "C.1", true, 330);
        this.createDatum("C", "C.2", false, 370);
        this.createDatum("C", "C.3", true, 322);
        this.createDatum("C", "C.4", false, 310);
        this.createDatum("C", "C.5", true, 315);
        this.createDatum(null, "root2", false, 2);
        this.createDatum("root2", "X", false, 70);
        this.createDatum("X", "X.1", false, 700);
        this.createDatum("X", "X.2", false, 710);
        this.createDatum("X", "X.3", false, 720);
        this.createDatum("root2", "Y", false, 80);
        this.createDatum("Y", "Y.1", false, 800);
        this.createDatum("Y", "Y.2", false, 810);
        this.createDatum("root2", "Z", false, 90);
        this.createDatum("Z", "Z.1", false, 900);
        this.createDatum("Z", "Z.2", false, 910);
        this.createDatum("Z", "Z.3", false, 920);
        this.createDatum("Z", "Z.4", false, 930);
        this.createDatum("Z", "Z.5", false, 940);
    }

    public class Datum
    implements Comparable<Datum> {
        private final Datum parent;
        private final List<Datum> children = new ArrayList<Datum>();
        private final String name;
        private boolean on;
        private int bar;

        public Datum(Datum parent, String name, boolean on, int bar) {
            this.parent = parent;
            if (parent != null) {
                parent.addChild(this);
            }
            this.name = name;
            this.on = on;
            this.bar = bar;
        }

        public Datum getParent() {
            return this.parent;
        }

        public void addChild(Datum child) {
            this.children.add(child);
        }

        public List<Datum> getChildren() {
            return this.children;
        }

        public Datum getSelf() {
            return this;
        }

        public String getName() {
            return this.name;
        }

        public boolean isOn() {
            if (this.children.size() == 0) {
                return this.on;
            }
            return this.getCheckBoxState() == CheckBoxStateEnum.CHECKED;
        }

        public void setOn(boolean on) {
            if (this.children.size() == 0) {
                this.on = on;
            } else {
                for (Datum child : this.children) {
                    child.setOn(on);
                }
            }
        }

        public int getBar() {
            return this.bar;
        }

        public CheckBoxStateEnum getCheckBoxState() {
            if (this.children.size() == 0) {
                return this.on ? CheckBoxStateEnum.CHECKED : CheckBoxStateEnum.UNCHECKED;
            }
            boolean atLeastOneChildChecked = false;
            boolean atLeastOneChildUnchecked = false;
            for (Datum child : this.children) {
                CheckBoxStateEnum childCheckBoxState = child.getCheckBoxState();
                switch (childCheckBoxState) {
                    case CHECKED: {
                        atLeastOneChildChecked = true;
                        break;
                    }
                    case SEMICHECKED: {
                        return CheckBoxStateEnum.SEMICHECKED;
                    }
                    case UNCHECKED: {
                        atLeastOneChildUnchecked = true;
                    }
                }
            }
            if (atLeastOneChildChecked) {
                if (atLeastOneChildUnchecked) {
                    return CheckBoxStateEnum.SEMICHECKED;
                }
                return CheckBoxStateEnum.CHECKED;
            }
            return CheckBoxStateEnum.UNCHECKED;
        }

        public String toString() {
            return "[parent=" + this.parent + ", name=" + this.name + ", on=" + this.on + ", bar=" + this.bar + "]";
        }

        @Override
        public int compareTo(Datum o) {
            return this.name.compareTo(o.name);
        }
    }

    private static class DatumExpansionModel
    implements TreeList.ExpansionModel<Datum> {
        private DatumExpansionModel() {
        }

        public boolean isExpanded(Datum element, List<Datum> path) {
            return true;
        }

        public void setExpanded(Datum element, List<Datum> path, boolean expanded) {
        }
    }

    private static class DatumTreeFormat
    implements TreeList.Format<Datum> {
        private final ISortModel sortModel;

        public DatumTreeFormat(ISortModel sortModel) {
            this.sortModel = sortModel;
        }

        public void getPath(List<Datum> path, Datum element) {
            path.add(element);
            Datum parent = element.getParent();
            while (parent != null) {
                path.add(parent);
                parent = parent.getParent();
            }
            Collections.reverse(path);
        }

        public boolean allowsChildren(Datum element) {
            return true;
        }

        public Comparator<Datum> getComparator(int depth) {
            return new SortableTreeComparator(GlazedLists.beanPropertyComparator(Datum.class, (String)"self", (String[])new String[0]), this.sortModel);
        }
    }
}

