/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._501_Data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.command.VisualRefreshCommand;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.AutomaticSpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.NumberValues;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.SpanningDataLayer;
import org.eclipse.nebula.widgets.nattable.persistence.command.DisplayPersistenceDialogCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.IMouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.IMenuItemProvider;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class _5015_AutomaticDataSpanningExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 300, new _5015_AutomaticDataSpanningExample());
    }

    @Override
    public String getDescription() {
        return "This example shows the usage of automatic spanning. This means adjacent cells that contain the same values get spanned automatically.\nThe automatic spanning type (column/row/none) can be changed via body context menu entry 'Toggle auto spanning'";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[] propertyNames = new String[]{"columnOneNumber", "columnTwoNumber", "columnThreeNumber", "columnFourNumber", "columnFiveNumber"};
        ReflectiveColumnPropertyAccessor cpa = new ReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider dataProvider = new ListDataProvider(this.createNumberValueList(), (IColumnAccessor)cpa);
        AutomaticSpanningDataProvider spanningDataProvider = new AutomaticSpanningDataProvider((IDataProvider)dataProvider, true, false);
        NatTable natTable = new NatTable(parent, (ILayer)new ViewportLayer((IUniqueIndexLayer)new SelectionLayer((IUniqueIndexLayer)new SpanningDataLayer((ISpanningDataProvider)spanningDataProvider))), false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new BodyMenuConfiguration(natTable, spanningDataProvider));
        natTable.configure();
        natTable.registerCommandHandler((ILayerCommandHandler)new DisplayPersistenceDialogCommandHandler());
        return natTable;
    }

    private List<NumberValues> createNumberValueList() {
        ArrayList<NumberValues> result = new ArrayList<NumberValues>();
        NumberValues nv = new NumberValues();
        nv.setColumnOneNumber(5);
        nv.setColumnTwoNumber(4);
        nv.setColumnThreeNumber(3);
        nv.setColumnFourNumber(1);
        nv.setColumnFiveNumber(1);
        result.add(nv);
        nv = new NumberValues();
        nv.setColumnOneNumber(1);
        nv.setColumnTwoNumber(1);
        nv.setColumnThreeNumber(2);
        nv.setColumnFourNumber(2);
        nv.setColumnFiveNumber(3);
        result.add(nv);
        nv = new NumberValues();
        nv.setColumnOneNumber(1);
        nv.setColumnTwoNumber(2);
        nv.setColumnThreeNumber(2);
        nv.setColumnFourNumber(3);
        nv.setColumnFiveNumber(3);
        result.add(nv);
        nv = new NumberValues();
        nv.setColumnOneNumber(1);
        nv.setColumnTwoNumber(2);
        nv.setColumnThreeNumber(4);
        nv.setColumnFourNumber(4);
        nv.setColumnFiveNumber(3);
        result.add(nv);
        nv = new NumberValues();
        nv.setColumnOneNumber(5);
        nv.setColumnTwoNumber(4);
        nv.setColumnThreeNumber(4);
        nv.setColumnFourNumber(4);
        nv.setColumnFiveNumber(7);
        result.add(nv);
        return result;
    }

    class BodyMenuConfiguration
    extends AbstractUiBindingConfiguration {
        private Menu bodyMenu;
        private AutomaticSpanningDataProvider dataProvider;

        public BodyMenuConfiguration(NatTable natTable, AutomaticSpanningDataProvider dataProvider) {
            this.bodyMenu = this.createBodyMenu(natTable).build();
            this.dataProvider = dataProvider;
        }

        protected PopupMenuBuilder createBodyMenu(NatTable natTable) {
            return new PopupMenuBuilder(natTable).withMenuItemProvider(new IMenuItemProvider(){

                public void addMenuItem(final NatTable natTable, Menu popupMenu) {
                    MenuItem menuItem = new MenuItem(popupMenu, 8);
                    menuItem.setText("Toggle auto spanning");
                    menuItem.setEnabled(true);
                    menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            if (BodyMenuConfiguration.this.dataProvider.isAutoColumnSpan()) {
                                BodyMenuConfiguration.this.dataProvider.setAutoColumnSpan(false);
                                BodyMenuConfiguration.this.dataProvider.setAutoRowSpan(true);
                            } else if (BodyMenuConfiguration.this.dataProvider.isAutoRowSpan()) {
                                BodyMenuConfiguration.this.dataProvider.setAutoRowSpan(false);
                            } else {
                                BodyMenuConfiguration.this.dataProvider.setAutoColumnSpan(true);
                            }
                            natTable.doCommand((ILayerCommand)new VisualRefreshCommand());
                        }
                    });
                }
            }).withStateManagerMenuItemProvider();
        }

        public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
            if (this.bodyMenu != null) {
                uiBindingRegistry.registerMouseDownBinding((IMouseEventMatcher)new MouseEventMatcher(0, null, 3), (IMouseAction)new PopupMenuAction(this.bodyMenu));
            }
        }
    }
}

