/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._500_Layers._501_Data;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _5011_DataLayerExample
extends AbstractNatExample {
    private boolean showDefaultColumnWidth = true;
    private boolean showDefaultRowHeight = true;

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _5011_DataLayerExample());
    }

    @Override
    public String getDescription() {
        return "This example shows a simple NatTable that is only able to show data and supports different column/row sizes.\nBy pressing the buttons 'Toggle column width' and 'Toggle row height' you can see how to change column/row sizes programmatically.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        ReflectiveColumnPropertyAccessor columnPropertyAccessor = new ReflectiveColumnPropertyAccessor(propertyNames);
        ListDataProvider bodyDataProvider = new ListDataProvider(PersonService.getPersons((int)10), (IColumnAccessor)columnPropertyAccessor);
        final DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        final NatTable natTable = new NatTable(parent, 538181632, (ILayer)bodyDataLayer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        Button b1 = new Button(parent, 8);
        b1.setText("Toggle column width");
        b1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                _5011_DataLayerExample.this.showDefaultColumnWidth = !_5011_DataLayerExample.this.showDefaultColumnWidth;
                if (_5011_DataLayerExample.this.showDefaultColumnWidth) {
                    bodyDataLayer.setColumnWidthByPosition(0, 100, false);
                    bodyDataLayer.setColumnWidthByPosition(1, 100, false);
                    bodyDataLayer.setColumnWidthByPosition(2, 100, false);
                    bodyDataLayer.setColumnWidthByPosition(3, 100, false);
                    bodyDataLayer.setColumnWidthByPosition(4, 100, true);
                } else {
                    bodyDataLayer.setColumnWidthByPosition(0, 70, false);
                    bodyDataLayer.setColumnWidthByPosition(1, 70, false);
                    bodyDataLayer.setColumnWidthByPosition(2, 50, false);
                    bodyDataLayer.setColumnWidthByPosition(3, 30, false);
                    bodyDataLayer.setColumnWidthByPosition(4, 200, true);
                }
            }
        });
        Button b2 = new Button(parent, 8);
        b2.setText("Toggle row height");
        b2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                _5011_DataLayerExample.this.showDefaultRowHeight = !_5011_DataLayerExample.this.showDefaultRowHeight;
                if (_5011_DataLayerExample.this.showDefaultRowHeight) {
                    bodyDataLayer.setDefaultRowHeight(20);
                } else {
                    bodyDataLayer.setDefaultRowHeight(50);
                }
                natTable.refresh(false);
            }
        });
        return natTable;
    }
}

