/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._300_Data;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultIntegerDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.PercentageDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.NumberValues;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.formula.FormulaDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.ColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnOverrideLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.reorder.ColumnReorderLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _306_CalculatedFormulaDataExample
extends AbstractNatExample {
    public static String COLUMN_ONE_LABEL = "ColumnOneLabel";
    public static String COLUMN_TWO_LABEL = "ColumnTwoLabel";
    public static String COLUMN_THREE_LABEL = "ColumnThreeLabel";
    public static String COLUMN_FOUR_LABEL = "ColumnFourLabel";
    public static String COLUMN_FIVE_LABEL = "ColumnFiveLabel";
    private EventList<NumberValues> valuesToShow = GlazedLists.eventList(new ArrayList());

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(new _306_CalculatedFormulaDataExample());
    }

    @Override
    public String getDescription() {
        return "This example demonstrates how to create a NatTable that contains calculated values as formulas.\nThe first three columns are editable, while the last two columns contain the calculated values.\nThe values in column four and five will automatically update when committing the edited values.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        Composite gridPanel = new Composite(panel, 0);
        gridPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)gridPanel);
        Composite buttonPanel = new Composite(panel, 0);
        buttonPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        String[] propertyNames = new String[]{"columnOneNumber", "columnTwoNumber", "columnThreeNumber", "columnFourNumber", "columnFiveNumber"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("columnOneNumber", "100%");
        propertyToLabelMap.put("columnTwoNumber", "Value One");
        propertyToLabelMap.put("columnThreeNumber", "Value Two");
        propertyToLabelMap.put("columnFourNumber", "Sum");
        propertyToLabelMap.put("columnFiveNumber", "Percentage");
        this.valuesToShow.add((Object)this.createNumberValues());
        this.valuesToShow.add((Object)this.createNumberValues());
        ConfigRegistry configRegistry = new ConfigRegistry();
        CalculatingGridLayer gridLayer = new CalculatingGridLayer(this.valuesToShow, configRegistry, propertyNames, propertyToLabelMap);
        DataLayer bodyDataLayer = gridLayer.getBodyDataLayer();
        ColumnOverrideLabelAccumulator columnLabelAccumulator = new ColumnOverrideLabelAccumulator((ILayer)bodyDataLayer);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)columnLabelAccumulator);
        this.registerColumnLabels(columnLabelAccumulator);
        final NatTable natTable = new NatTable(gridPanel, (ILayer)gridLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new CalculatingEditConfiguration());
        natTable.configure();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        Button addRowButton = new Button(buttonPanel, 8);
        addRowButton.setText("add row");
        addRowButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                _306_CalculatedFormulaDataExample.this.valuesToShow.add((Object)_306_CalculatedFormulaDataExample.this.createNumberValues());
                natTable.refresh();
            }
        });
        Button resetButton = new Button(buttonPanel, 8);
        resetButton.setText("reset");
        resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                _306_CalculatedFormulaDataExample.this.valuesToShow.clear();
                _306_CalculatedFormulaDataExample.this.valuesToShow.add((Object)_306_CalculatedFormulaDataExample.this.createNumberValues());
                _306_CalculatedFormulaDataExample.this.valuesToShow.add((Object)_306_CalculatedFormulaDataExample.this.createNumberValues());
                natTable.refresh();
            }
        });
        return panel;
    }

    private void registerColumnLabels(ColumnOverrideLabelAccumulator columnLabelAccumulator) {
        columnLabelAccumulator.registerColumnOverrides(0, new String[]{COLUMN_ONE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(1, new String[]{COLUMN_TWO_LABEL});
        columnLabelAccumulator.registerColumnOverrides(2, new String[]{COLUMN_THREE_LABEL});
        columnLabelAccumulator.registerColumnOverrides(3, new String[]{COLUMN_FOUR_LABEL});
        columnLabelAccumulator.registerColumnOverrides(4, new String[]{COLUMN_FIVE_LABEL});
    }

    private NumberValues createNumberValues() {
        NumberValues nv = new NumberValues();
        nv.setColumnOneNumber(100);
        nv.setColumnTwoNumber(20);
        nv.setColumnThreeNumber(30);
        return nv;
    }

    class CalculatingBodyLayerStack
    extends AbstractLayerTransform {
        private final DataLayer bodyDataLayer;
        private final ColumnReorderLayer columnReorderLayer;
        private final ColumnHideShowLayer columnHideShowLayer;
        private final SelectionLayer selectionLayer;
        private final ViewportLayer viewportLayer;

        public CalculatingBodyLayerStack(EventList<NumberValues> valuesToShow, ConfigRegistry configRegistry) {
            ReflectiveColumnPropertyAccessor ca = new ReflectiveColumnPropertyAccessor(new String[]{"columnOneNumber", "columnTwoNumber", "columnThreeNumber"});
            CalculatingDataProvider dataProvider = new CalculatingDataProvider((List<NumberValues>)valuesToShow, (IColumnAccessor<NumberValues>)ca);
            FormulaDataProvider fda = new FormulaDataProvider((IDataProvider)dataProvider);
            this.bodyDataLayer = new DataLayer((IDataProvider)fda);
            this.columnReorderLayer = new ColumnReorderLayer((IUniqueIndexLayer)this.bodyDataLayer);
            this.columnHideShowLayer = new ColumnHideShowLayer((IUniqueIndexLayer)this.columnReorderLayer);
            this.selectionLayer = new SelectionLayer((IUniqueIndexLayer)this.columnHideShowLayer);
            this.viewportLayer = new ViewportLayer((IUniqueIndexLayer)this.selectionLayer);
            this.setUnderlyingLayer((ILayer)this.viewportLayer);
            this.registerCommandHandler((ILayerCommandHandler)new CopyDataCommandHandler(this.selectionLayer));
        }

        public DataLayer getDataLayer() {
            return this.bodyDataLayer;
        }

        public SelectionLayer getSelectionLayer() {
            return this.selectionLayer;
        }
    }

    class CalculatingDataProvider
    extends ListDataProvider<NumberValues> {
        IRowDataProvider<NumberValues> dataProvider;

        public CalculatingDataProvider(List<NumberValues> list, IColumnAccessor<NumberValues> columnAccessor) {
            super(list, columnAccessor);
        }

        public Object getDataValue(int columnIndex, int rowIndex) {
            int formulaRowIndex = rowIndex + 1;
            if (columnIndex < 3) {
                return super.getDataValue(columnIndex, rowIndex);
            }
            if (columnIndex == 3) {
                return "=SUM(B" + formulaRowIndex + ";C" + formulaRowIndex + ")";
            }
            if (columnIndex == 4) {
                return "=(B" + formulaRowIndex + "+C" + formulaRowIndex + ")/A" + formulaRowIndex;
            }
            return "";
        }

        public int getColumnCount() {
            return 5;
        }
    }

    class CalculatingEditConfiguration
    extends AbstractRegistryConfiguration {
        CalculatingEditConfiguration() {
        }

        public void configureRegistry(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, "EDIT", COLUMN_FOUR_LABEL);
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, "EDIT", COLUMN_FIVE_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultIntegerDisplayConverter(), "NORMAL");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultIntegerDisplayConverter(), "EDIT");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new PercentageDisplayConverter(), "NORMAL", COLUMN_FIVE_LABEL);
        }
    }

    class CalculatingGridLayer
    extends GridLayer {
        public CalculatingGridLayer(EventList<NumberValues> valuesToShow, ConfigRegistry configRegistry, String[] propertyNames, Map<String, String> propertyToLabelMap) {
            super(true);
            this.init(valuesToShow, configRegistry, propertyNames, propertyToLabelMap);
        }

        private void init(EventList<NumberValues> valuesToShow, ConfigRegistry configRegistry, String[] propertyNames, Map<String, String> propertyToLabelMap) {
            CalculatingBodyLayerStack bodyLayer = new CalculatingBodyLayerStack(valuesToShow, configRegistry);
            SelectionLayer selectionLayer = bodyLayer.getSelectionLayer();
            DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
            ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider), (ILayer)bodyLayer, selectionLayer);
            DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider(bodyLayer.getDataLayer().getDataProvider());
            RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider), (ILayer)bodyLayer, selectionLayer);
            CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider)), (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
            this.setBodyLayer((ILayer)bodyLayer);
            this.setColumnHeaderLayer((ILayer)columnHeaderLayer);
            this.setRowHeaderLayer((ILayer)rowHeaderLayer);
            this.setCornerLayer((ILayer)cornerLayer);
        }

        public DataLayer getBodyDataLayer() {
            return ((CalculatingBodyLayerStack)this.getBodyLayer()).getDataLayer();
        }
    }
}

