/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.grid.command.ClientAreaResizeCommand;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.print.command.PrintEntireGridCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.selection.ScrollSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.MoveSelectionCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.ScrollSelectionCommand;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.nebula.widgets.nattable.viewport.HorizontalScrollBarHandler;
import org.eclipse.nebula.widgets.nattable.viewport.VerticalScrollBarHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.RecalculateScrollBarsCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ShowCellInViewportCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ShowColumnInViewportCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ShowRowInViewportCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportDragCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportSelectColumnCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportSelectRowCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.event.ScrollEvent;
import org.eclipse.nebula.widgets.nattable.viewport.event.ViewportEventHandler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ScrollBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewportLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private HorizontalScrollBarHandler hBarListener;
    private VerticalScrollBarHandler vBarListener;
    private final IUniqueIndexLayer scrollableLayer;
    private final PositionCoordinate origin = new PositionCoordinate(this, 0, 0);
    private final PositionCoordinate minimumOrigin = new PositionCoordinate(this, 0, 0);
    private boolean viewportOff = false;
    private int savedOriginColumn;
    private int savedOriginRow = 0;
    private List<Integer> cachedColumnIndexOrder;
    private List<Integer> cachedRowIndexOrder;
    private int cachedClientAreaWidth = 0;
    private int cachedClientAreaHeight = 0;
    private int cachedWidth = -1;
    private int cachedHeight = -1;
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private Point edgeHoverScrollOffset = new Point(0, 0);
    private ScheduledFuture<?> edgeHoverScrollFuture;

    public ViewportLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
        this.scrollableLayer = underlyingLayer;
        this.registerCommandHandlers();
        this.registerEventHandler(new ViewportEventHandler(this));
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.hBarListener != null) {
            this.hBarListener.dispose();
        }
        if (this.vBarListener != null) {
            this.vBarListener.dispose();
        }
        this.scheduler.shutdown();
    }

    public int getMinimumOriginColumnPosition() {
        return this.minimumOrigin.columnPosition;
    }

    public void setMinimumOriginColumnPosition(int minColumnPosition) {
        int previousOriginColumnPosition = this.origin.columnPosition;
        if (previousOriginColumnPosition == this.minimumOrigin.columnPosition || this.getOriginColumnPosition() < minColumnPosition) {
            this.minimumOrigin.columnPosition = minColumnPosition;
            this.origin.columnPosition = minColumnPosition;
        } else {
            this.origin.columnPosition = this.getOriginColumnPosition() + minColumnPosition - this.minimumOrigin.columnPosition;
            this.minimumOrigin.columnPosition = minColumnPosition;
        }
        if (this.origin.columnPosition != previousOriginColumnPosition) {
            this.invalidateHorizontalStructure();
        }
        this.recalculateHorizontalScrollBar();
    }

    public int getMinimumOriginRowPosition() {
        return this.minimumOrigin.rowPosition;
    }

    public void setMinimumOriginRowPosition(int minRowPosition) {
        int previousOriginRowPosition = this.origin.rowPosition;
        this.origin.rowPosition = this.getOriginRowPosition() < minRowPosition ? minRowPosition : this.getOriginRowPosition() + minRowPosition - this.minimumOrigin.rowPosition;
        this.minimumOrigin.rowPosition = minRowPosition;
        if (this.origin.rowPosition != previousOriginRowPosition) {
            this.invalidateVerticalStructure();
        }
        this.recalculateVerticalScrollBar();
    }

    public void setMinimumOriginPosition(int minColumnPosition, int minRowPosition) {
        this.setMinimumOriginColumnPosition(minColumnPosition);
        this.setMinimumOriginRowPosition(minRowPosition);
    }

    public int getOriginColumnPosition() {
        return this.viewportOff ? this.minimumOrigin.columnPosition : this.origin.columnPosition;
    }

    public void setOriginColumnPosition(int scrollableColumnPosition) {
        if (scrollableColumnPosition < this.minimumOrigin.columnPosition) {
            scrollableColumnPosition = this.minimumOrigin.columnPosition;
        }
        if (scrollableColumnPosition >= this.getUnderlyingLayer().getColumnCount()) {
            scrollableColumnPosition = this.getUnderlyingLayer().getColumnCount() - 1;
        }
        int originalOriginColumnPosition = this.getOriginColumnPosition();
        int adjustedOriginColumnPosition = this.adjustColumnOrigin(scrollableColumnPosition);
        if (adjustedOriginColumnPosition != originalOriginColumnPosition && this.getUnderlyingLayer().getColumnIndexByPosition(adjustedOriginColumnPosition) >= 0) {
            this.invalidateHorizontalStructure();
            this.origin.columnPosition = adjustedOriginColumnPosition;
            this.fireScrollEvent();
        }
    }

    public int getOriginRowPosition() {
        return this.viewportOff ? this.minimumOrigin.rowPosition : this.origin.rowPosition;
    }

    public void setOriginRowPosition(int scrollableRowPosition) {
        if (scrollableRowPosition < this.minimumOrigin.rowPosition) {
            scrollableRowPosition = this.minimumOrigin.rowPosition;
        }
        int originalOriginRowPosition = this.getOriginRowPosition();
        int adjustedOriginRowPosition = this.adjustRowOrigin(scrollableRowPosition);
        if (adjustedOriginRowPosition != originalOriginRowPosition && this.getUnderlyingLayer().getRowIndexByPosition(adjustedOriginRowPosition) >= 0) {
            this.invalidateVerticalStructure();
            this.origin.rowPosition = adjustedOriginRowPosition;
            this.fireScrollEvent();
        }
    }

    public void resetOrigin(int columnPosition, int rowPosition) {
        int previousOriginColumnPosition = this.origin.columnPosition;
        int previousOriginRowPosition = this.origin.rowPosition;
        this.minimumOrigin.columnPosition = 0;
        this.origin.columnPosition = columnPosition;
        this.minimumOrigin.rowPosition = 0;
        this.origin.rowPosition = rowPosition;
        if (this.origin.columnPosition != previousOriginColumnPosition) {
            this.invalidateHorizontalStructure();
        }
        if (this.origin.rowPosition != previousOriginRowPosition) {
            this.invalidateVerticalStructure();
        }
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new RecalculateScrollBarsCommandHandler(this));
        this.registerCommandHandler(new ScrollSelectionCommandHandler(this));
        this.registerCommandHandler(new ShowCellInViewportCommandHandler(this));
        this.registerCommandHandler(new ShowColumnInViewportCommandHandler(this));
        this.registerCommandHandler(new ShowRowInViewportCommandHandler(this));
        this.registerCommandHandler(new ViewportSelectColumnCommandHandler(this));
        this.registerCommandHandler(new ViewportSelectRowCommandHandler(this));
        this.registerCommandHandler(new ViewportDragCommandHandler(this));
    }

    @Override
    public int getColumnCount() {
        if (this.viewportOff) {
            return this.scrollableLayer.getColumnCount() - this.minimumOrigin.columnPosition;
        }
        return this.getColumnIndexes().size();
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.scrollableLayer.getColumnPositionByIndex(columnIndex) - this.getOriginColumnPosition();
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        int underlyingPosition = this.getOriginColumnPosition() + localColumnPosition;
        if (underlyingPosition < this.getMinimumOriginColumnPosition()) {
            return -1;
        }
        return underlyingPosition;
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        if (sourceUnderlyingLayer != this.getUnderlyingLayer()) {
            return -1;
        }
        return underlyingColumnPosition - this.getOriginColumnPosition();
    }

    private List<Integer> getColumnIndexes() {
        int availableWidth;
        if ((this.cachedColumnIndexOrder == null || this.cachedColumnIndexOrder.size() == 0) && (availableWidth = this.getClientAreaWidth()) >= 0) {
            if (this.getOriginColumnPosition() < this.minimumOrigin.columnPosition) {
                this.origin.columnPosition = this.minimumOrigin.columnPosition;
            }
            this.recalculateAvailableWidthAndColumnIndexes();
        }
        return this.cachedColumnIndexOrder;
    }

    @Override
    public int getWidth() {
        if (this.viewportOff) {
            return this.scrollableLayer.getWidth() - this.scrollableLayer.getStartXOfColumnPosition(this.minimumOrigin.columnPosition);
        }
        if (this.cachedWidth < 0) {
            this.recalculateAvailableWidthAndColumnIndexes();
        }
        return this.cachedWidth;
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        return this.getUnderlyingLayer().isColumnPositionResizable(this.getOriginColumnPosition() + columnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        int originPos = this.getOriginColumnPosition();
        int originX = this.getUnderlyingLayer().getStartXOfColumnPosition(originPos);
        int columnPos = this.getUnderlyingLayer().getColumnPositionByX(originX + x) - originPos;
        return columnPos;
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return this.getUnderlyingLayer().getStartXOfColumnPosition(this.getOriginColumnPosition() + columnPosition) - this.getUnderlyingLayer().getStartXOfColumnPosition(this.getOriginColumnPosition());
    }

    @Override
    public int getRowCount() {
        if (this.viewportOff) {
            return this.scrollableLayer.getRowCount() - this.minimumOrigin.rowPosition;
        }
        return this.getRowIndexes().size();
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.scrollableLayer.getRowPositionByIndex(rowIndex) - this.getOriginRowPosition();
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        int underlyingPosition = this.getOriginRowPosition() + localRowPosition;
        if (underlyingPosition < this.getMinimumOriginRowPosition()) {
            return -1;
        }
        return underlyingPosition;
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        if (sourceUnderlyingLayer != this.getUnderlyingLayer()) {
            return -1;
        }
        return underlyingRowPosition - this.getOriginRowPosition();
    }

    private List<Integer> getRowIndexes() {
        int availableHeight;
        if ((this.cachedRowIndexOrder == null || this.cachedRowIndexOrder.size() == 0) && (availableHeight = this.getClientAreaHeight()) >= 0) {
            if (this.getOriginRowPosition() < this.minimumOrigin.rowPosition) {
                this.origin.rowPosition = this.minimumOrigin.rowPosition;
            }
            this.recalculateAvailableHeightAndRowIndexes();
        }
        return this.cachedRowIndexOrder;
    }

    @Override
    public int getHeight() {
        if (this.viewportOff) {
            return this.scrollableLayer.getHeight() - this.scrollableLayer.getStartYOfRowPosition(this.minimumOrigin.rowPosition);
        }
        if (this.cachedHeight < 0) {
            this.recalculateAvailableHeightAndRowIndexes();
        }
        return this.cachedHeight;
    }

    @Override
    public int getRowPositionByY(int y) {
        int originY = this.getUnderlyingLayer().getStartYOfRowPosition(this.getOriginRowPosition());
        return this.getUnderlyingLayer().getRowPositionByY(originY + y) - this.getOriginRowPosition();
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        return this.getUnderlyingLayer().getStartYOfRowPosition(this.getOriginRowPosition() + rowPosition) - this.getUnderlyingLayer().getStartYOfRowPosition(this.getOriginRowPosition());
    }

    @Override
    public Rectangle getBoundsByPosition(int columnPosition, int rowPosition) {
        int underlyingColumnPosition = this.localToUnderlyingColumnPosition(columnPosition);
        int underlyingRowPosition = this.localToUnderlyingRowPosition(rowPosition);
        Rectangle bounds = this.getUnderlyingLayer().getBoundsByPosition(underlyingColumnPosition, underlyingRowPosition);
        bounds.x -= this.getUnderlyingLayer().getStartXOfColumnPosition(this.getOriginColumnPosition());
        bounds.y -= this.getUnderlyingLayer().getStartYOfRowPosition(this.getOriginRowPosition());
        return bounds;
    }

    public void invalidateHorizontalStructure() {
        this.cachedColumnIndexOrder = null;
        this.cachedClientAreaWidth = 0;
        this.cachedWidth = -1;
    }

    public void invalidateVerticalStructure() {
        this.cachedRowIndexOrder = null;
        this.cachedClientAreaHeight = 0;
        this.cachedHeight = -1;
    }

    protected void recalculateAvailableWidthAndColumnIndexes() {
        int availableWidth = this.getClientAreaWidth();
        ILayer underlyingLayer = this.getUnderlyingLayer();
        this.cachedWidth = 0;
        this.cachedColumnIndexOrder = new ArrayList<Integer>();
        int columnPosition = this.getOriginColumnPosition();
        while (columnPosition < underlyingLayer.getColumnCount() && availableWidth > 0) {
            int columnIndex = underlyingLayer.getColumnIndexByPosition(columnPosition);
            int width = underlyingLayer.getColumnWidthByPosition(columnPosition);
            availableWidth -= width;
            this.cachedWidth += width;
            this.cachedColumnIndexOrder.add(columnIndex);
            ++columnPosition;
        }
        int lastColumnPosition = underlyingLayer.getColumnCount() - 1;
        if (this.origin.columnPosition > lastColumnPosition) {
            this.origin.columnPosition = lastColumnPosition;
        }
    }

    protected void recalculateAvailableHeightAndRowIndexes() {
        int availableHeight = this.getClientAreaHeight();
        ILayer underlyingLayer = this.getUnderlyingLayer();
        this.cachedHeight = 0;
        this.cachedRowIndexOrder = new ArrayList<Integer>();
        int currentPosition = this.getOriginRowPosition();
        while (currentPosition < underlyingLayer.getRowCount() && availableHeight > 0) {
            int rowIndex = underlyingLayer.getRowIndexByPosition(currentPosition);
            int height = underlyingLayer.getRowHeightByPosition(rowIndex);
            availableHeight -= height;
            this.cachedHeight += height;
            this.cachedRowIndexOrder.add(rowIndex);
            ++currentPosition;
        }
        int lastRowPosition = underlyingLayer.getRowCount() - 1;
        if (this.origin.rowPosition > lastRowPosition) {
            this.origin.rowPosition = lastRowPosition < 0 ? 0 : lastRowPosition;
        }
    }

    public void moveCellPositionIntoViewport(int scrollableColumnPosition, int scrollableRowPosition, boolean forceEntireCellIntoViewport) {
        this.moveColumnPositionIntoViewport(scrollableColumnPosition, forceEntireCellIntoViewport);
        this.moveRowPositionIntoViewport(scrollableRowPosition, forceEntireCellIntoViewport);
    }

    public void moveColumnPositionIntoViewport(int scrollableColumnPosition, boolean forceEntireCellIntoViewport) {
        ILayer underlyingLayer = this.getUnderlyingLayer();
        if (underlyingLayer.getColumnIndexByPosition(scrollableColumnPosition) >= 0 && scrollableColumnPosition >= this.getMinimumOriginColumnPosition()) {
            int originColumnPosition = this.getOriginColumnPosition();
            if (scrollableColumnPosition < originColumnPosition) {
                this.setOriginColumnPosition(scrollableColumnPosition);
            } else {
                int scrollableColumnStartX = underlyingLayer.getStartXOfColumnPosition(scrollableColumnPosition);
                int scrollableColumnEndX = scrollableColumnStartX + underlyingLayer.getColumnWidthByPosition(scrollableColumnPosition);
                int clientAreaWidth = this.getClientAreaWidth();
                int viewportEndX = underlyingLayer.getStartXOfColumnPosition(this.getOriginColumnPosition()) + clientAreaWidth;
                if (viewportEndX < scrollableColumnEndX) {
                    int targetOriginColumnPosition = forceEntireCellIntoViewport || this.isLastColumn(scrollableColumnPosition) ? underlyingLayer.getColumnPositionByX(scrollableColumnEndX - clientAreaWidth) + 1 : underlyingLayer.getColumnPositionByX(scrollableColumnStartX - clientAreaWidth) + 1;
                    this.setOriginColumnPosition(targetOriginColumnPosition);
                }
            }
            this.adjustHorizontalScrollBar();
        }
    }

    public void moveRowPositionIntoViewport(int scrollableRowPosition, boolean forceEntireCellIntoViewport) {
        ILayer underlyingLayer = this.getUnderlyingLayer();
        if (underlyingLayer.getRowIndexByPosition(scrollableRowPosition) >= 0 && scrollableRowPosition >= this.getMinimumOriginRowPosition()) {
            int originRowPosition = this.getOriginRowPosition();
            if (scrollableRowPosition < originRowPosition) {
                this.setOriginRowPosition(scrollableRowPosition);
            } else {
                int scrollableRowStartY = underlyingLayer.getStartYOfRowPosition(scrollableRowPosition);
                int scrollableRowEndY = scrollableRowStartY + underlyingLayer.getRowHeightByPosition(scrollableRowPosition);
                int clientAreaHeight = this.getClientAreaHeight();
                int viewportEndY = underlyingLayer.getStartYOfRowPosition(this.getOriginRowPosition()) + clientAreaHeight;
                if (viewportEndY < scrollableRowEndY) {
                    int targetOriginRowPosition = forceEntireCellIntoViewport || this.isLastRow(scrollableRowPosition) ? underlyingLayer.getRowPositionByY(scrollableRowEndY - clientAreaHeight) + 1 : underlyingLayer.getRowPositionByY(scrollableRowStartY - clientAreaHeight) + 1;
                    this.setOriginRowPosition(targetOriginRowPosition);
                }
            }
            this.adjustVerticalScrollBar();
        }
    }

    private boolean isLastColumn(int scrollableColumnPosition) {
        return scrollableColumnPosition == this.getUnderlyingLayer().getColumnCount() - 1;
    }

    private boolean isLastRow(int scrollableRowPosition) {
        return scrollableRowPosition == this.getUnderlyingLayer().getRowCount() - 1;
    }

    protected void fireScrollEvent() {
        this.fireLayerEvent(new ScrollEvent(this));
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ClientAreaResizeCommand && command.convertToTargetLayer(this)) {
            ClientAreaResizeCommand clientAreaResizeCommand = (ClientAreaResizeCommand)command;
            int widthDiff = clientAreaResizeCommand.getScrollable().getClientArea().width - clientAreaResizeCommand.getCalcArea().width;
            int heightDiff = clientAreaResizeCommand.getScrollable().getClientArea().height - clientAreaResizeCommand.getCalcArea().height;
            ScrollBar hBar = clientAreaResizeCommand.getScrollable().getHorizontalBar();
            ScrollBar vBar = clientAreaResizeCommand.getScrollable().getVerticalBar();
            if (this.hBarListener == null) {
                this.hBarListener = new HorizontalScrollBarHandler(this, hBar);
            }
            if (this.vBarListener == null) {
                this.vBarListener = new VerticalScrollBarHandler(this, vBar);
            }
            this.handleGridResize();
            Rectangle possibleArea = clientAreaResizeCommand.getScrollable().getClientArea();
            possibleArea.width -= widthDiff;
            possibleArea.height -= heightDiff;
            clientAreaResizeCommand.setCalcArea(possibleArea);
        } else {
            if (command instanceof TurnViewportOffCommand) {
                this.savedOriginColumn = this.localToUnderlyingColumnPosition(0);
                this.savedOriginRow = this.localToUnderlyingRowPosition(0);
                this.viewportOff = true;
                return true;
            }
            if (command instanceof TurnViewportOnCommand) {
                this.viewportOff = false;
                this.setOriginColumnPosition(this.savedOriginColumn);
                this.setOriginRowPosition(this.savedOriginRow);
                return true;
            }
            if (command instanceof PrintEntireGridCommand) {
                this.moveCellPositionIntoViewport(0, 0, false);
            }
        }
        return super.doCommand(command);
    }

    private void recalculateHorizontalScrollBar() {
        if (this.hBarListener != null) {
            this.hBarListener.recalculateScrollBarSize();
            if (!this.hBarListener.scrollBar.getEnabled()) {
                this.setOriginColumnPosition(0);
            }
        }
    }

    private void recalculateVerticalScrollBar() {
        if (this.vBarListener != null) {
            this.vBarListener.recalculateScrollBarSize();
            if (!this.vBarListener.scrollBar.getEnabled()) {
                this.setOriginRowPosition(0);
            }
        }
    }

    public void recalculateScrollBars() {
        this.recalculateHorizontalScrollBar();
        this.recalculateVerticalScrollBar();
    }

    protected void handleGridResize() {
        this.setOriginColumnPosition(this.origin.columnPosition);
        this.recalculateHorizontalScrollBar();
        this.setOriginRowPosition(this.origin.rowPosition);
        this.recalculateVerticalScrollBar();
    }

    protected int adjustColumnOrigin(int originColumnPosition) {
        if (this.getColumnCount() == 0) {
            return 0;
        }
        int availableWidth = this.getClientAreaWidth() - (this.scrollableLayer.getWidth() - this.scrollableLayer.getStartXOfColumnPosition(originColumnPosition));
        if (availableWidth < 0) {
            return originColumnPosition;
        }
        int previousColPosition = originColumnPosition - 1;
        while (previousColPosition >= 0) {
            int previousColWidth = this.getUnderlyingLayer().getColumnWidthByPosition(previousColPosition);
            if (availableWidth < previousColWidth || originColumnPosition - 1 < this.minimumOrigin.columnPosition) break;
            --originColumnPosition;
            availableWidth -= previousColWidth;
            --previousColPosition;
        }
        return originColumnPosition;
    }

    protected int adjustRowOrigin(int originRowPosition) {
        if (this.getRowCount() == 0) {
            return 0;
        }
        int availableHeight = this.getClientAreaHeight() - (this.scrollableLayer.getHeight() - this.scrollableLayer.getStartYOfRowPosition(originRowPosition));
        if (availableHeight < 0) {
            return originRowPosition;
        }
        int previousRowPosition = originRowPosition - 1;
        while (previousRowPosition >= 0) {
            int previousRowHeight = this.getUnderlyingLayer().getRowHeightByPosition(previousRowPosition);
            if (availableHeight < previousRowHeight || originRowPosition - 1 < this.minimumOrigin.rowPosition) break;
            --originRowPosition;
            availableHeight -= previousRowHeight;
            --previousRowPosition;
        }
        return originRowPosition;
    }

    public void scrollVerticallyByAPage(ScrollSelectionCommand scrollSelectionCommand) {
        this.getUnderlyingLayer().doCommand(this.scrollVerticallyByAPageCommand(scrollSelectionCommand));
    }

    protected MoveSelectionCommand scrollVerticallyByAPageCommand(ScrollSelectionCommand scrollSelectionCommand) {
        return new MoveSelectionCommand(scrollSelectionCommand.getDirection(), this.getRowCount(), scrollSelectionCommand.isShiftMask(), scrollSelectionCommand.isControlMask());
    }

    protected boolean isLastColumnCompletelyDisplayed() {
        int lastDisplayableColumnIndex = this.getUnderlyingLayer().getColumnIndexByPosition(this.getUnderlyingLayer().getColumnCount() - 1);
        int visibleColumnCount = this.getColumnCount();
        int lastVisibleColumnIndex = this.getColumnIndexByPosition(visibleColumnCount - 1);
        return lastVisibleColumnIndex == lastDisplayableColumnIndex && this.getClientAreaWidth() >= this.getWidth();
    }

    protected boolean isLastRowCompletelyDisplayed() {
        int lastDisplayableRowIndex = this.getUnderlyingLayer().getRowIndexByPosition(this.getUnderlyingLayer().getRowCount() - 1);
        int visibleRowCount = this.getRowCount();
        int lastVisibleRowIndex = this.getRowIndexByPosition(visibleRowCount - 1);
        return lastVisibleRowIndex == lastDisplayableRowIndex && this.getClientAreaHeight() >= this.getHeight();
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof IStructuralChangeEvent) {
            IStructuralChangeEvent structuralChangeEvent = (IStructuralChangeEvent)event;
            if (structuralChangeEvent.isHorizontalStructureChanged()) {
                this.invalidateHorizontalStructure();
            }
            if (structuralChangeEvent.isVerticalStructureChanged()) {
                this.invalidateVerticalStructure();
            }
        }
        if (event instanceof CellSelectionEvent) {
            this.processSelection((CellSelectionEvent)event);
        } else if (event instanceof ColumnSelectionEvent) {
            this.processColumnSelection((ColumnSelectionEvent)event);
        } else if (event instanceof RowSelectionEvent) {
            this.processRowSelection((RowSelectionEvent)event);
        }
        super.handleLayerEvent(event);
    }

    private void processSelection(CellSelectionEvent selectionEvent) {
        this.moveCellPositionIntoViewport(selectionEvent.getColumnPosition(), selectionEvent.getRowPosition(), selectionEvent.isForcingEntireCellIntoViewport());
        this.adjustHorizontalScrollBar();
        this.adjustVerticalScrollBar();
    }

    private void processColumnSelection(ColumnSelectionEvent selectionEvent) {
        for (Range columnPositionRange : selectionEvent.getColumnPositionRanges()) {
            this.moveColumnPositionIntoViewport(columnPositionRange.end - 1, false);
            this.adjustHorizontalScrollBar();
        }
    }

    private void processRowSelection(RowSelectionEvent selectionEvent) {
        int rowPositionToMoveIntoViewport = selectionEvent.getRowPositionToMoveIntoViewport();
        if (rowPositionToMoveIntoViewport >= 0) {
            this.moveRowPositionIntoViewport(rowPositionToMoveIntoViewport, false);
            this.adjustVerticalScrollBar();
        }
    }

    private void adjustHorizontalScrollBar() {
        if (this.hBarListener != null) {
            this.hBarListener.adjustScrollBar();
        }
    }

    private void adjustVerticalScrollBar() {
        if (this.vBarListener != null) {
            this.vBarListener.adjustScrollBar();
        }
    }

    public int getClientAreaWidth() {
        int clientAreaWidth = this.getClientAreaProvider().getClientArea().width;
        if (clientAreaWidth != this.cachedClientAreaWidth) {
            this.invalidateHorizontalStructure();
            this.cachedClientAreaWidth = clientAreaWidth;
        }
        return this.cachedClientAreaWidth;
    }

    public int getClientAreaHeight() {
        int clientAreaHeight = this.getClientAreaProvider().getClientArea().height;
        if (clientAreaHeight != this.cachedClientAreaHeight) {
            this.invalidateVerticalStructure();
            this.cachedClientAreaHeight = clientAreaHeight;
        }
        return this.cachedClientAreaHeight;
    }

    public SelectionLayer getSelectionLayer() {
        return (SelectionLayer)this.getUnderlyingLayer();
    }

    public IUniqueIndexLayer getScrollableLayer() {
        return this.scrollableLayer;
    }

    @Override
    public String toString() {
        return "Viewport Layer";
    }

    protected PositionCoordinate getOrigin() {
        return this.origin;
    }

    protected PositionCoordinate getMinmumOrigin() {
        return this.minimumOrigin;
    }

    public void drag(int x, int y) {
        this.edgeHoverScrollOffset.x = 0;
        this.edgeHoverScrollOffset.y = 0;
        if (x < 0 && y < 0) {
            this.cancelEdgeHoverScroll();
            return;
        }
        Rectangle clientArea = this.getClientAreaProvider().getClientArea();
        int minX = clientArea.x;
        int maxX = clientArea.x + clientArea.width;
        if (x >= minX && x < minX + 10) {
            this.edgeHoverScrollOffset.x = -1;
        } else if (x > maxX - 10 && x < maxX) {
            this.edgeHoverScrollOffset.x = 1;
        }
        int minY = clientArea.y;
        int maxY = clientArea.y + clientArea.height;
        if (y >= minY && y < minY + 10) {
            this.edgeHoverScrollOffset.y = -1;
        } else if (y > maxY - 10 && y < maxY) {
            this.edgeHoverScrollOffset.y = 1;
        }
        if (this.edgeHoverScrollOffset.x != 0 || this.edgeHoverScrollOffset.y != 0) {
            if (this.edgeHoverScrollFuture == null || this.edgeHoverScrollFuture.isDone()) {
                this.edgeHoverScrollFuture = this.scheduler.schedule(new MoveViewportRunnable(), 500L, TimeUnit.MILLISECONDS);
            }
        } else {
            this.cancelEdgeHoverScroll();
        }
    }

    private void cancelEdgeHoverScroll() {
        this.edgeHoverScrollOffset.x = 0;
        this.edgeHoverScrollOffset.y = 0;
        if (this.edgeHoverScrollFuture != null) {
            this.edgeHoverScrollFuture.cancel(false);
            this.edgeHoverScrollFuture = null;
        }
    }

    class MoveViewportRunnable
    implements Runnable {
        MoveViewportRunnable() {
        }

        public void run() {
            if (((ViewportLayer)ViewportLayer.this).edgeHoverScrollOffset.x != 0 || ((ViewportLayer)ViewportLayer.this).edgeHoverScrollOffset.y != 0) {
                ViewportLayer.this.setOriginColumnPosition(((ViewportLayer)ViewportLayer.this).origin.columnPosition + ((ViewportLayer)ViewportLayer.this).edgeHoverScrollOffset.x);
                ViewportLayer.this.setOriginRowPosition(((ViewportLayer)ViewportLayer.this).origin.rowPosition + ((ViewportLayer)ViewportLayer.this).edgeHoverScrollOffset.y);
                ViewportLayer.this.edgeHoverScrollFuture = ViewportLayer.this.scheduler.schedule(new MoveViewportRunnable(), 100L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

