/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.swt.graphics.Rectangle;

public abstract class AbstractLayerCell
implements ILayerCell {
    private boolean isDisplayModeCached = false;
    private String displayMode = null;
    private boolean isConfigLabelsCached = false;
    private LabelStack configLabels = null;
    private boolean isDataValueCached = false;
    private Object dataValue = null;
    private boolean isBoundsCached = false;
    private Rectangle bounds = null;

    public boolean isSpannedCell() {
        return this.getColumnSpan() > 1 || this.getRowSpan() > 1;
    }

    public String getDisplayMode() {
        if (!this.isDisplayModeCached) {
            this.isDisplayModeCached = true;
            this.displayMode = this.getLayer().getDisplayModeByPosition(this.getColumnPosition(), this.getRowPosition());
        }
        return this.displayMode;
    }

    public LabelStack getConfigLabels() {
        if (!this.isConfigLabelsCached) {
            this.isConfigLabelsCached = true;
            this.configLabels = this.getLayer().getConfigLabelsByPosition(this.getColumnPosition(), this.getRowPosition());
        }
        return this.configLabels;
    }

    public Object getDataValue() {
        if (!this.isDataValueCached) {
            this.isDataValueCached = true;
            this.dataValue = this.getLayer().getDataValueByPosition(this.getColumnPosition(), this.getRowPosition());
        }
        return this.dataValue;
    }

    public Rectangle getBounds() {
        if (!this.isBoundsCached) {
            this.isBoundsCached = true;
            this.bounds = this.getLayer().getBoundsByPosition(this.getColumnPosition(), this.getRowPosition());
        }
        return this.bounds;
    }
}

